/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class BeanHandler
extends DefaultHandler {
    private static final Log LOG = LogFactory.getLog((String)BeanHandler.class.getName());
    private final Object bean;
    private ElementInfo element;
    private Locator locator;

    public BeanHandler(Object bean) {
        this.bean = bean;
    }

    public final void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.element == null) {
            this.element = new ElementInfo(qName, this.bean);
        } else {
            Object child = this.createChild(this.element, qName);
            this.element = new ElementInfo(this.element, qName, child);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attrName = attributes.getQName(i);
            String attrValue = attributes.getValue(i);
            this.setAttribute(this.element, attrName, attrValue);
        }
    }

    public final void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.element.parent != null) {
            this.addChild(this.element.parent.bean, this.element.bean, qName);
        }
        this.element = this.element.parent;
    }

    private Object createChild(ElementInfo parent, String name) throws SAXException {
        try {
            Class<?> parentClass = parent.bean.getClass();
            Method method = BeanHandler.findCreateMethod(parentClass, name);
            if (method != null) {
                return method.invoke(parent.bean, new Object[0]);
            }
            method = this.findSetMethod(parentClass, "add", name);
            if (method != null) {
                return BeanHandler.createInstance(parent.bean, method.getParameterTypes()[0]);
            }
        }
        catch (Exception e) {
            throw new SAXException(this.getLocation() + ": Could not create nested element <" + name + ">.");
        }
        throw new SAXException(this.getLocation() + ": Element <" + parent.elementName + "> does not allow nested <" + name + "> elements.");
    }

    private static Object createInstance(Object parent, Class childClass) throws Exception {
        Constructor<?>[] constructors = childClass.getConstructors();
        ArrayList candidates = new ArrayList();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> constructor = constructors[i];
            Class<?>[] params = constructor.getParameterTypes();
            if (params.length == 0) {
                candidates.add(constructor);
                continue;
            }
            if (params.length != 1 || !params[0].isInstance(parent)) continue;
            candidates.add(constructor);
        }
        switch (candidates.size()) {
            case 0: {
                throw new Exception("No constructor for class " + childClass.getName());
            }
            case 1: {
                break;
            }
            default: {
                throw new Exception("Multiple constructors for class " + childClass.getName());
            }
        }
        Constructor constructor = (Constructor)candidates.remove(0);
        if (constructor.getParameterTypes().length == 0) {
            return constructor.newInstance(new Object[0]);
        }
        return constructor.newInstance(parent);
    }

    private static Method findCreateMethod(Class objClass, String name) {
        String methodName = BeanHandler.makeMethodName("create", name);
        Method[] methods = objClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(methodName) || Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType().isPrimitive() || method.getReturnType().isArray()) continue;
            return method;
        }
        return null;
    }

    private static String makeMethodName(String prefix, String name) {
        return prefix + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private void setAttribute(ElementInfo element, String attrName, String attrValue) throws SAXException {
        try {
            Class<?> objClass = element.bean.getClass();
            Method method = this.findSetMethod(objClass, "set", attrName);
            if (method != null) {
                Object realValue = BeanHandler.convert(method.getParameterTypes()[0], attrValue);
                method.invoke(element.bean, realValue);
                return;
            }
            if (element.elementName.equals("ehcache")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Ignoring ehcache attribute " + attrName));
                }
                return;
            }
        }
        catch (InvocationTargetException e) {
            throw new SAXException(this.getLocation() + ": Could not set attribute \"" + attrName + "\"." + ". Message was: " + e.getTargetException());
        }
        catch (Exception e) {
            throw new SAXException(this.getLocation() + ": Could not set attribute \"" + attrName + "\".");
        }
        throw new SAXException(this.getLocation() + ": Element <" + element.elementName + "> does not allow attribute \"" + attrName + "\".");
    }

    private static Object convert(Class toClass, String value) throws Exception {
        if (value == null) {
            return null;
        }
        if (toClass.isInstance(value)) {
            return value;
        }
        if (toClass == Long.class || toClass == Long.TYPE) {
            return Long.decode(value);
        }
        if (toClass == Integer.class || toClass == Integer.TYPE) {
            return Integer.decode(value);
        }
        if (toClass == Boolean.class || toClass == Boolean.TYPE) {
            return Boolean.valueOf(value);
        }
        throw new Exception("Cannot convert attribute value to class " + toClass.getName());
    }

    private Method findSetMethod(Class objClass, String prefix, String name) throws Exception {
        String methodName = BeanHandler.makeMethodName(prefix, name);
        Method[] methods = objClass.getMethods();
        Method candidate = null;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(methodName) || Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 1 || !method.getReturnType().equals(Void.TYPE)) continue;
            if (candidate != null) {
                throw new Exception("Multiple " + methodName + "() methods in class " + objClass.getName() + ".");
            }
            candidate = method;
        }
        return candidate;
    }

    private void addChild(Object parent, Object child, String name) throws SAXException {
        try {
            Method method = this.findSetMethod(parent.getClass(), "add", name);
            if (method != null) {
                method.invoke(parent, child);
            }
        }
        catch (InvocationTargetException e) {
            SAXException exc = new SAXException(this.getLocation() + ": Could not finish element <" + name + ">." + " Message was: " + e.getTargetException());
            throw exc;
        }
        catch (Exception e) {
            throw new SAXException(this.getLocation() + ": Could not finish element <" + name + ">.");
        }
    }

    private String getLocation() {
        return this.locator.getSystemId() + ':' + this.locator.getLineNumber();
    }

    private static final class ElementInfo {
        private final ElementInfo parent;
        private final String elementName;
        private final Object bean;

        public ElementInfo(String elementName, Object bean) {
            this.parent = null;
            this.elementName = elementName;
            this.bean = bean;
        }

        public ElementInfo(ElementInfo parent, String elementName, Object bean) {
            this.parent = parent;
            this.elementName = elementName;
            this.bean = bean;
        }
    }
}

