/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.imageio;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.dcm4che2.data.ConfigurationError;
import org.dcm4che2.util.CloseUtils;

class ImageReaderWriterFactory {
    protected final Properties config;

    protected ImageReaderWriterFactory(String key, String def) {
        URL url;
        block7: {
            this.config = new Properties();
            String val = System.getProperty(key, def);
            try {
                url = new URL(val);
            }
            catch (MalformedURLException e) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl != null && (url = cl.getResource(val)) != null || (url = ImageReaderWriterFactory.class.getClassLoader().getResource(val)) != null) break block7;
                throw new ConfigurationError("missing resource: " + val);
            }
        }
        InputStream is = null;
        try {
            is = url.openStream();
            this.config.load(is);
        }
        catch (IOException e) {
            throw new ConfigurationError("failed to load imageio configuration from " + url, (Throwable)e);
        }
        finally {
            CloseUtils.safeClose((Closeable)is);
        }
    }
}

