/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;
import java.text.NumberFormat;

public class IntegerStringAttribute
extends StringAttribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/IntegerStringAttribute.java,v 1.9 2005/01/02 21:16:43 dclunie Exp $";

    public IntegerStringAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public IntegerStringAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream);
    }

    public IntegerStringAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, (long)l, dicomInputStream);
    }

    public byte[] getVR() {
        return ValueRepresentation.IS;
    }

    public String[] getStringValues(NumberFormat numberFormat) throws DicomException {
        String[] stringArray = null;
        if (numberFormat == null) {
            stringArray = super.getStringValues(null);
        } else {
            long[] lArray = this.getLongValues();
            if (lArray != null) {
                stringArray = new String[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    stringArray[i] = numberFormat.format(lArray[i]);
                }
            }
        }
        return stringArray;
    }
}

