/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.event.RegionSelectionChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.EventContext;
import com.pixelmed.geometry.GeometryOfSlice;
import com.pixelmed.geometry.GeometryOfVolume;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.SwingUtilities;

class SingleImagePanelWithRegionDetection
extends SingleImagePanel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SingleImagePanelWithRegionDetection.java,v 1.1 2006/08/05 20:39:53 dclunie Exp $";
    private int regionSelectionCenterX;
    private int regionSelectionCenterY;
    private int regionSelectionTLHCX;
    private int regionSelectionTLHCY;
    private int regionSelectionBRHCX;
    private int regionSelectionBRHCY;
    protected Point2D startPoint;
    static final int crossSize = 5;

    public SingleImagePanelWithRegionDetection(SourceImage sourceImage, EventContext eventContext, int[] nArray, Vector vector, Vector vector2, GeometryOfVolume geometryOfVolume) {
        super(sourceImage, eventContext, nArray, vector, vector2, geometryOfVolume);
    }

    public SingleImagePanelWithRegionDetection(SourceImage sourceImage, EventContext eventContext, GeometryOfVolume geometryOfVolume) {
        super(sourceImage, eventContext, geometryOfVolume);
    }

    public SingleImagePanelWithRegionDetection(SourceImage sourceImage, EventContext eventContext) {
        super(sourceImage, eventContext);
    }

    public SingleImagePanelWithRegionDetection(SourceImage sourceImage) {
        super(sourceImage);
    }

    private void setRegionSelection(int n, int n2, int n3, int n4, int n5, int n6) {
        this.regionSelectionCenterX = n;
        this.regionSelectionCenterY = n2;
        if (n3 < n5) {
            this.regionSelectionTLHCX = n3;
            this.regionSelectionBRHCX = n5;
        } else {
            this.regionSelectionTLHCX = n5;
            this.regionSelectionBRHCX = n3;
        }
        if (n4 < n6) {
            this.regionSelectionTLHCY = n4;
            this.regionSelectionBRHCY = n6;
        } else {
            this.regionSelectionTLHCY = n6;
            this.regionSelectionBRHCY = n4;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.dragInteractiveDrawing(mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.mouseDragged(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.startInteractiveDrawing(mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.endInteractiveDrawing(mouseEvent.getX(), mouseEvent.getY());
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new RegionSelectionChangeEvent(this.typeOfPanelEventContext, this.regionSelectionCenterX, this.regionSelectionCenterY, this.regionSelectionTLHCX, this.regionSelectionTLHCY, this.regionSelectionBRHCX, this.regionSelectionBRHCY));
        } else {
            super.mouseReleased(mouseEvent);
        }
    }

    private IntegerPointWithValue[] findLongestAndShortestPaths(Collection collection, double[] dArray) throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        IntegerPointWithValue integerPointWithValue;
        double d = dArray == null ? 0.0 : (dArray[0] == dArray[1] ? dArray[0] : 0.0);
        Object[] objectArray = collection.toArray();
        int n6 = objectArray.length;
        int n7 = -1;
        int n8 = -1;
        int n9 = 0;
        for (int i = 0; i < n6; ++i) {
            integerPointWithValue = (IntegerPointWithValue)objectArray[i];
            n5 = integerPointWithValue.getX();
            n4 = integerPointWithValue.getY();
            for (n3 = i + 1; n3 < n6; ++n3) {
                int n10;
                IntegerPointWithValue integerPointWithValue2 = (IntegerPointWithValue)objectArray[n3];
                n2 = integerPointWithValue2.getX();
                int n11 = n2 - n5;
                int n12 = n11 * n11 + (n10 = (n = integerPointWithValue2.getY()) - n4) * n10;
                if (n12 <= n9) continue;
                n9 = n12;
                n7 = i;
                n8 = n3;
            }
        }
        if (n7 < 0 || n8 < 0) {
            return null;
        }
        IntegerPointWithValue integerPointWithValue3 = (IntegerPointWithValue)objectArray[n7];
        integerPointWithValue = (IntegerPointWithValue)objectArray[n8];
        n5 = integerPointWithValue3.getX();
        n4 = integerPointWithValue.getX();
        n3 = n4 - n5;
        if (n3 < 0) {
            int n13 = n7;
            n7 = n8;
            n8 = n13;
            integerPointWithValue3 = (IntegerPointWithValue)objectArray[n7];
            integerPointWithValue = (IntegerPointWithValue)objectArray[n8];
            n5 = integerPointWithValue3.getX();
            n4 = integerPointWithValue.getX();
            n3 = n4 - n5;
        }
        int n14 = integerPointWithValue3.getY();
        n2 = integerPointWithValue.getY();
        n = -(n2 - n14);
        double d2 = Math.sqrt(n3 * n3 + n * n);
        double d3 = Math.atan((double)n / (double)n3);
        System.err.println("Long axis length=" + d2 + " pixels (" + d2 * d + " mm)");
        double d4 = 0.0;
        double d5 = 0.0;
        IntegerPointWithValue integerPointWithValue4 = null;
        IntegerPointWithValue integerPointWithValue5 = null;
        IntegerPointWithValue integerPointWithValue6 = null;
        IntegerPointWithValue integerPointWithValue7 = null;
        for (int i = 0; i < n6; ++i) {
            IntegerPointWithValue integerPointWithValue8 = (IntegerPointWithValue)objectArray[i];
            int n15 = integerPointWithValue8.getX();
            int n16 = integerPointWithValue8.getY();
            int n17 = n15 - n5;
            int n18 = -(n16 - n14);
            double d6 = Math.sqrt(n17 * n17 + n18 * n18);
            double d7 = Math.atan((double)n18 / (double)n17);
            double d8 = d7 - d3;
            double d9 = d6 * Math.cos(d8);
            double d10 = d6 * Math.sin(d8);
            int n19 = (int)(d9 * Math.cos(d3));
            int n20 = (int)(d9 * Math.sin(d3));
            int n21 = n5 + n19;
            int n22 = n14 - n20;
            if (d10 < d4 && d8 <= 1.5707963267948966 && d8 >= -1.5707963267948966) {
                d4 = d10;
                integerPointWithValue4 = integerPointWithValue8;
                integerPointWithValue6 = new IntegerPointWithValue(n21, n22, 0);
            }
            if (!(d10 > d5) || !(d8 <= 1.5707963267948966) || !(d8 >= -1.5707963267948966)) continue;
            d5 = d10;
            integerPointWithValue5 = integerPointWithValue8;
            integerPointWithValue7 = new IntegerPointWithValue(n21, n22, 0);
        }
        System.err.println("Short axis most negative side length=" + d4 + " pixels (" + d4 * d + " mm)");
        System.err.println("Short axis most positive side length=" + d5 + " pixels (" + d5 * d + " mm)");
        System.err.println("Short axis total length=" + (Math.abs(d4) + Math.abs(d5)) + " pixels (" + (Math.abs(d4) + Math.abs(d5)) * d + " mm)");
        IntegerPointWithValue[] integerPointWithValueArray = new IntegerPointWithValue[]{integerPointWithValue3, integerPointWithValue, integerPointWithValue4, integerPointWithValue6, integerPointWithValue5, integerPointWithValue7};
        return integerPointWithValueArray;
    }

    private void detectAndDrawRegion(BufferedImage bufferedImage, double[] dArray, Vector vector, int n, int n2, int n3, int n4, int n5, int n6) throws Exception {
        int n7;
        int n8;
        int n9;
        int n10;
        HashSet<IntegerPointWithValue> hashSet = new HashSet<IntegerPointWithValue>();
        HashSet<IntegerPointWithValue> hashSet2 = new HashSet<IntegerPointWithValue>();
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n11 = writableRaster.getSample(n, n2, 0);
        hashSet2.add(new IntegerPointWithValue(n, n2, n11));
        int n12 = 1;
        double d = n11;
        double d2 = 0.0;
        double d3 = 0.0;
        int n13 = 16;
        double d4 = 2.0;
        int n14 = 20;
        int n15 = n11;
        do {
            Iterator iterator;
            if (!(iterator = hashSet2.iterator()).hasNext()) continue;
            IntegerPointWithValue integerPointWithValue = (IntegerPointWithValue)iterator.next();
            iterator.remove();
            hashSet.add(integerPointWithValue);
            int n16 = integerPointWithValue.getX();
            int n17 = integerPointWithValue.getY();
            n10 = writableRaster.getSample(n16, n17, 0);
            double d5 = (double)n10 - d;
            double d6 = d + d5 / (double)(n12 + 1);
            d = d6;
            d2 = Math.sqrt((d3 += d5 * ((double)n10 - d6)) / (double)n12);
            if (++n12 > n13) {
                n14 = (int)(d2 * d4);
            } else {
                n15 = (int)d;
            }
            for (n9 = -1; n9 <= 1; ++n9) {
                for (n8 = -1; n8 <= 1; ++n8) {
                    IntegerPointWithValue integerPointWithValue2;
                    int n18;
                    if (n9 == 0 && n8 == 0) continue;
                    int n19 = n16 + n9;
                    int n20 = n17 + n8;
                    if (n19 < n3 || n19 > n5 || n20 < n4 || n20 > n6 || Math.abs(n15 - (n18 = writableRaster.getSample(n19, n20, 0))) > n14 || hashSet.contains(integerPointWithValue2 = new IntegerPointWithValue(n19, n20, n18))) continue;
                    hashSet2.add(integerPointWithValue2);
                }
            }
        } while (!hashSet2.isEmpty());
        int n21 = bufferedImage.getWidth();
        int n22 = bufferedImage.getHeight();
        int[] nArray = new int[n21];
        int[] nArray2 = new int[n21];
        for (n10 = 0; n10 < n21; ++n10) {
            nArray[n10] = n22;
            nArray2[n10] = -1;
        }
        for (IntegerPointWithValue integerPointWithValue : hashSet) {
            n7 = integerPointWithValue.getX();
            int n23 = integerPointWithValue.getY();
            if (n23 < nArray[n7]) {
                nArray[n7] = n23;
            }
            if (n23 <= nArray2[n7]) continue;
            nArray2[n7] = n23;
        }
        GeneralPath generalPath = new GeneralPath();
        n7 = 0;
        int n24 = -1;
        int n25 = -1;
        for (n9 = 0; n9 < n21; ++n9) {
            n8 = nArray[n9];
            if (n8 >= n22) continue;
            if (n7 == 0) {
                generalPath.moveTo(n9, n8);
                n7 = 1;
                n24 = n9;
                n25 = n8;
                continue;
            }
            generalPath.lineTo(n9, n8);
        }
        for (n9 = n21 - 1; n9 >= 0; --n9) {
            n8 = nArray2[n9];
            if (n8 < 0) continue;
            if (n7 == 0) {
                generalPath.moveTo(n9, n8);
                n7 = 1;
                n24 = n9;
                n25 = n8;
                continue;
            }
            generalPath.lineTo(n9, n8);
        }
        if (n7 != 0) {
            generalPath.lineTo(n24, n25);
            IntegerPointWithValue[] integerPointWithValueArray = null;
            try {
                integerPointWithValueArray = this.findLongestAndShortestPaths(hashSet, dArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (integerPointWithValueArray != null) {
                generalPath.moveTo(integerPointWithValueArray[0].getX(), integerPointWithValueArray[0].getY());
                generalPath.lineTo(integerPointWithValueArray[1].getX(), integerPointWithValueArray[1].getY());
                if (integerPointWithValueArray[2] != null && integerPointWithValueArray[3] != null) {
                    generalPath.moveTo(integerPointWithValueArray[2].getX(), integerPointWithValueArray[2].getY());
                    generalPath.lineTo(integerPointWithValueArray[3].getX(), integerPointWithValueArray[3].getY());
                }
                if (integerPointWithValueArray[4] != null && integerPointWithValueArray[5] != null) {
                    generalPath.moveTo(integerPointWithValueArray[4].getX(), integerPointWithValueArray[4].getY());
                    generalPath.lineTo(integerPointWithValueArray[5].getX(), integerPointWithValueArray[5].getY());
                }
                vector.add(generalPath);
            }
        }
    }

    protected void startInteractiveDrawing(int n, int n2) {
        this.startPoint = this.getImageCoordinateFromWindowCoordinate(n, n2);
    }

    protected void dragInteractiveDrawing(int n, int n2) {
        int n3;
        this.interactiveDrawingShapes = new Vector();
        int n4 = (int)this.startPoint.getX();
        int n5 = (int)this.startPoint.getY();
        Point point = this.getImageCoordinateFromWindowCoordinate(n, n2);
        int n6 = (int)point.getX();
        int n7 = (int)point.getY();
        this.interactiveDrawingShapes.add(new Line2D.Float(this.startPoint, point));
        int n8 = (n6 - n4) * 2;
        if (n8 < 0) {
            n8 = -n8;
        }
        if ((n3 = (n7 - n5) * 2) < 0) {
            n3 = -n3;
        }
        int n9 = n4 - n8 / 2;
        int n10 = n5 - n3 / 2;
        this.interactiveDrawingShapes.add(new Rectangle(n9, n10, n8, n3));
        this.repaint();
    }

    protected void endInteractiveDrawing(int n, int n2) {
        int n3;
        this.interactiveDrawingShapes = new Vector();
        int n4 = (int)this.startPoint.getX();
        int n5 = (int)this.startPoint.getY();
        Point point = this.getImageCoordinateFromWindowCoordinate(n, n2);
        int n6 = (int)point.getX();
        int n7 = (int)point.getY();
        int n8 = (n6 - n4) * 2;
        if (n8 < 0) {
            n8 = -n8;
        }
        if ((n3 = (n7 - n5) * 2) < 0) {
            n3 = -n3;
        }
        int n9 = n4 - n8 / 2;
        int n10 = n5 - n3 / 2;
        this.setRegionSelection(n4, n5, n9, n10, n9 + n8, n10 + n3);
        try {
            int n11 = this.currentSrcImageSortOrder != null ? this.currentSrcImageSortOrder[this.currentSrcImageIndex] : this.currentSrcImageIndex;
            GeometryOfVolume geometryOfVolume = this.getImageGeometry();
            GeometryOfSlice[] geometryOfSliceArray = geometryOfVolume == null ? null : geometryOfVolume.getGeometryOfSlices();
            GeometryOfSlice geometryOfSlice = geometryOfSliceArray == null ? null : geometryOfSliceArray[n11];
            double[] dArray = geometryOfSlice == null ? null : geometryOfSlice.getVoxelSpacingArray();
            this.detectAndDrawRegion(this.sImg.getBufferedImage(n11), dArray, this.interactiveDrawingShapes, this.regionSelectionCenterX, this.regionSelectionCenterY, this.regionSelectionTLHCX, this.regionSelectionTLHCY, this.regionSelectionBRHCX, this.regionSelectionBRHCY);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.repaint();
    }

    private class IntegerPointWithValue {
        private int x;
        private int y;
        private int v;

        public IntegerPointWithValue(int n, int n2, int n3) throws Exception {
            if (n > 65535 || n < 0 || n2 > 65535 || n2 < 0) {
                throw new Exception("coordinate too large");
            }
            this.x = n;
            this.y = n2;
            this.v = n3;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int getV() {
            return this.v;
        }

        public final boolean equals(Object object) {
            IntegerPointWithValue integerPointWithValue = (IntegerPointWithValue)object;
            return this.x == integerPointWithValue.x && this.y == integerPointWithValue.y;
        }

        public final int hashCode() {
            return this.x << 16 + this.y;
        }
    }
}

