/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DisplayShutter;
import com.pixelmed.dicom.ModalityTransform;
import com.pixelmed.dicom.OtherWordAttributeOnDisk;
import com.pixelmed.dicom.RealWorldValueTransform;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.VOITransform;
import com.pixelmed.dicom.ValueRepresentation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Cleaner;

public class SourceImage {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SourceImage.java,v 1.47 2008/05/11 18:26:00 dclunie Exp $";
    BufferedImage[] imgs;
    int width;
    int height;
    int nframes;
    int imgMin;
    int imgMax;
    double imgMean;
    double imgStandardDeviation;
    boolean signed;
    boolean inverted;
    boolean isGrayscale;
    boolean isPaletteColor;
    int pad;
    int padRangeLimit;
    boolean hasPad;
    int backgroundValue;
    String title;
    private int largestGray;
    private int firstValueMapped;
    private int numberOfEntries;
    private int bitsPerEntry;
    private short[] redTable;
    private short[] greenTable;
    private short[] blueTable;
    private RealWorldValueTransform realWorldValueTransform;
    private ModalityTransform modalityTransform;
    private VOITransform voiTransform;
    private DisplayShutter displayShutter;
    protected BufferedImageSource bufferedImageSource = null;
    protected FileInputStream memoryMappedFileInputStream = null;
    protected FileChannel memoryMappedFileChannel = null;
    protected MappedByteBuffer memoryMappedByteBuffer = null;

    private static BufferedImage createUnsignedShortGrayscaleImage(int n, int n2, short[] sArray, int n3) {
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{16}, false, false, 1, 1);
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(1, n, n2, 1, n, new int[]{0});
        DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray, n, n3);
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferUShort, new Point(0, 0));
        return new BufferedImage(componentColorModel, writableRaster, true, null);
    }

    private static BufferedImage createSignedShortGrayscaleImage(int n, int n2, short[] sArray, int n3) {
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{16}, false, false, 1, 1);
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(1, n, n2, 1, n, new int[]{0});
        DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray, n, n3);
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferUShort, new Point(0, 0));
        return new BufferedImage(componentColorModel, writableRaster, true, null);
    }

    private static BufferedImage createByteGrayscaleImage(int n, int n2, byte[] byArray, int n3) {
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, n, n2, 1, n, new int[]{0});
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n, n3);
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
        return new BufferedImage(componentColorModel, writableRaster, true, null);
    }

    private static BufferedImage createPixelInterleavedByteRGBImage(int n, int n2, byte[] byArray, int n3) {
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, n, n2, 3, n * 3, new int[]{0, 1, 2});
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n, n3);
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
        return new BufferedImage(componentColorModel, writableRaster, true, null);
    }

    private static BufferedImage createBandInterleavedByteRGBImage(int n, int n2, byte[] byArray, int n3) {
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, n, n2, 1, n, new int[]{0, n * n2, n * n2 * 2});
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n, n3);
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
        return new BufferedImage(componentColorModel, writableRaster, true, null);
    }

    public SourceImage(InputStream inputStream, int n, int n2, int n3) throws IOException {
        this.constructSourceImage(inputStream, n, n2, n3, 1);
    }

    public SourceImage(InputStream inputStream, int n, int n2, int n3, int n4) throws IOException {
        this.constructSourceImage(inputStream, n, n2, n3, n4);
    }

    private void constructSourceImage(InputStream inputStream, int n, int n2, int n3, int n4) throws IOException {
        this.width = n;
        this.height = n2;
        this.nframes = n4;
        if (this.nframes < 1) {
            return;
        }
        this.imgs = new BufferedImage[this.nframes];
        this.imgMin = 65536;
        this.imgMax = 0;
        for (int i = 0; i < this.nframes; ++i) {
            int n5;
            int n6;
            int n7;
            Object[] objectArray;
            if (n3 > 8) {
                objectArray = new short[this.width * this.height];
                byte[] byArray = new byte[this.width * this.height * 2];
                inputStream.read(byArray, 0, this.width * this.height * 2);
                n7 = 0;
                for (n6 = 0; n6 < this.height; ++n6) {
                    for (n5 = 0; n5 < this.width; ++n5) {
                        short s;
                        int n8 = byArray[n7++] & 0xFF;
                        int n9 = byArray[n7++] & 0xFF;
                        objectArray[n6 * n + n5] = s = (short)((n9 << 8) + n8);
                        if (s > this.imgMax && s <= this.largestGray) {
                            this.imgMax = s;
                        }
                        if (s >= this.imgMin) continue;
                        this.imgMin = s;
                    }
                }
                this.imgs[i] = SourceImage.createUnsignedShortGrayscaleImage(this.width, this.height, objectArray, 0);
                continue;
            }
            objectArray = new byte[this.width * this.height];
            inputStream.read((byte[])objectArray, 0, this.width * this.height);
            int n10 = 0;
            for (n7 = 0; n7 < this.height; ++n7) {
                for (n6 = 0; n6 < this.width; ++n6) {
                    if ((n5 = objectArray[n10++] & 0xFF) > this.imgMax && n5 <= this.largestGray) {
                        this.imgMax = n5;
                    }
                    if (n5 >= this.imgMin) continue;
                    this.imgMin = n5;
                }
            }
            this.imgs[i] = SourceImage.createByteGrayscaleImage(this.width, this.height, (byte[])objectArray, 0);
        }
    }

    private static String buildInstanceTitleFromAttributeList(AttributeList attributeList) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientName));
        stringBuffer.append("[");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientID));
        stringBuffer.append("]");
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyID));
        stringBuffer.append("[");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDate));
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDescription));
        stringBuffer.append("]");
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber));
        stringBuffer.append("[");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Modality));
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesDescription));
        stringBuffer.append("]");
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.InstanceNumber));
        stringBuffer.append(":");
        return stringBuffer.toString();
    }

    public SourceImage(String string) throws IOException, DicomException {
        AttributeList attributeList = new AttributeList();
        attributeList.read(string);
        if (attributeList.get(TagFromName.PixelData) != null) {
            this.constructSourceImage(attributeList);
        }
    }

    public SourceImage(DicomInputStream dicomInputStream) throws IOException, DicomException {
        AttributeList attributeList = new AttributeList();
        attributeList.read(dicomInputStream);
        if (attributeList.get(TagFromName.PixelData) != null) {
            this.constructSourceImage(attributeList);
        }
    }

    public SourceImage(AttributeList attributeList) throws DicomException {
        if (attributeList.get(TagFromName.PixelData) != null) {
            this.constructSourceImage(attributeList);
        }
    }

    protected static void clean(final Object object) throws Exception {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Method method = object.getClass().getMethod("cleaner", new Class[0]);
                    method.setAccessible(true);
                    Cleaner cleaner = (Cleaner)method.invoke(object, new Object[0]);
                    cleaner.clean();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
                return null;
            }
        });
    }

    public void close() throws Throwable {
        this.bufferedImageSource = null;
        if (this.memoryMappedByteBuffer != null) {
            SourceImage.clean(this.memoryMappedByteBuffer);
            this.memoryMappedByteBuffer = null;
        }
        if (this.memoryMappedFileChannel != null) {
            this.memoryMappedFileChannel.close();
            this.memoryMappedFileChannel = null;
        }
        if (this.memoryMappedFileInputStream != null) {
            this.memoryMappedFileInputStream.close();
            this.memoryMappedFileInputStream = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    void constructSourceImage(AttributeList attributeList) throws DicomException {
        Attribute attribute;
        this.title = SourceImage.buildInstanceTitleFromAttributeList(attributeList);
        this.width = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0);
        this.height = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0);
        int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, 0);
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 1);
        boolean bl = n2 > 1 && Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PlanarConfiguration, 0) == 1;
        this.nframes = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        int n6 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsStored, n);
        while (n6-- > 0) {
            n3 = n3 << 1 | 1;
            n5 <<= 1;
        }
        n5 >>= 1;
        n4 = ~n3;
        this.signed = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PixelRepresentation, 0) == 1;
        this.imgMin = this.signed ? Short.MAX_VALUE : 65535;
        this.imgMax = this.signed ? Short.MIN_VALUE : 0;
        this.pad = 0;
        this.hasPad = false;
        Attribute attribute2 = attributeList.get(TagFromName.PixelPaddingValue);
        if (attribute2 != null) {
            this.hasPad = true;
            this.pad = attribute2.getSingleIntegerValueOrDefault(0);
            this.padRangeLimit = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PixelPaddingRangeLimit, this.pad);
        }
        String string = Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.PhotometricInterpretation, "MONOCHROME2");
        this.inverted = string.equals("MONOCHROME1");
        this.isGrayscale = string.equals("MONOCHROME1") || string.equals("MONOCHROME2");
        this.isPaletteColor = string.equals("PALETTE COLOR");
        Attribute attribute3 = attributeList.get(TagFromName.LargestMonochromePixelValue);
        Attribute attribute4 = attributeList.get(TagFromName.RedPaletteColorLookupTableDescriptor);
        Attribute attribute5 = attributeList.get(TagFromName.GreenPaletteColorLookupTableDescriptor);
        Attribute attribute6 = attributeList.get(TagFromName.BluePaletteColorLookupTableDescriptor);
        this.largestGray = this.signed ? Short.MAX_VALUE : 65535;
        boolean bl2 = false;
        if (attribute3 != null && attribute3.getVM() == 1) {
            bl2 = true;
            this.largestGray = attribute3.getIntegerValues()[0];
        }
        boolean bl3 = false;
        if (!bl2 && (attribute = attributeList.get(TagFromName.LargestImagePixelValue)) != null && attribute.getVM() == 1) {
            bl3 = true;
            this.largestGray = attribute.getIntegerValues()[0];
        }
        boolean bl4 = false;
        if (attribute4 != null && attribute5 != null && attribute6 != null && attribute4 != null && attribute4.getVM() == 3) {
            this.numberOfEntries = attribute4.getIntegerValues()[0];
            if (this.numberOfEntries == 0) {
                this.numberOfEntries = 65536;
            }
            this.firstValueMapped = attribute4.getIntegerValues()[1];
            if (!bl2 && !bl3 || attributeList.get(TagFromName.PhotometricInterpretation).getStringValues()[0].equals("PALETTE COLOR")) {
                bl4 = true;
                this.largestGray = this.firstValueMapped - 1;
            }
            this.bitsPerEntry = attribute4.getIntegerValues()[2];
            Attribute attribute7 = attributeList.get(TagFromName.RedPaletteColorLookupTableData);
            Attribute attribute8 = attributeList.get(TagFromName.GreenPaletteColorLookupTableData);
            Attribute attribute9 = attributeList.get(TagFromName.BluePaletteColorLookupTableData);
            if (attribute7 != null && attribute8 != null && attribute9 != null) {
                this.redTable = attribute7.getShortValues();
                this.greenTable = attribute8.getShortValues();
                this.blueTable = attribute9.getShortValues();
            }
        }
        this.bufferedImageSource = null;
        int n7 = this.width * this.height;
        int n8 = n7 * n2;
        int n9 = n8 * this.nframes;
        if ((this.isGrayscale || this.isPaletteColor) && n2 == 1 && n > 8) {
            Attribute attribute10 = attributeList.get(TagFromName.PixelData);
            if (attribute10 instanceof OtherWordAttributeOnDisk) {
                OtherWordAttributeOnDisk otherWordAttributeOnDisk = (OtherWordAttributeOnDisk)attribute10;
                this.memoryMappedFileInputStream = null;
                this.memoryMappedFileChannel = null;
                try {
                    this.memoryMappedFileInputStream = new FileInputStream(otherWordAttributeOnDisk.getFile());
                    this.memoryMappedFileChannel = this.memoryMappedFileInputStream.getChannel();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new DicomException("Cannot find file to memory map " + otherWordAttributeOnDisk.getFile() + " " + fileNotFoundException);
                }
                this.memoryMappedByteBuffer = null;
                int n10 = 100;
                int n11 = 1000;
                int n12 = 10;
                Exception exception = null;
                while (this.memoryMappedByteBuffer == null && n10-- > 0) {
                    if (n12-- <= 0) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(n11);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace(System.err);
                        }
                    }
                    try {
                        System.gc();
                        System.runFinalization();
                        this.memoryMappedByteBuffer = this.memoryMappedFileChannel.map(FileChannel.MapMode.READ_ONLY, otherWordAttributeOnDisk.getByteOffset(), n9 * 2);
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace(System.err);
                        exception = exception2;
                    }
                }
                if (this.memoryMappedByteBuffer == null) {
                    throw new DicomException("Cannot memory map file " + otherWordAttributeOnDisk.getFile() + " " + exception);
                }
                this.memoryMappedByteBuffer.order(otherWordAttributeOnDisk.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
                ShortBuffer shortBuffer = this.memoryMappedByteBuffer.asShortBuffer();
                this.bufferedImageSource = this.signed ? new SignedShortGrayscaleBufferedImageSource(shortBuffer, this.width, this.height, n3, n5, n4, this.largestGray) : new UnsignedShortGrayscaleBufferedImageSource(shortBuffer, this.width, this.height, n3, this.largestGray);
            } else {
                short[] sArray = attribute10.getShortValues();
                if (this.signed) {
                    this.imgs = null;
                    this.bufferedImageSource = new SignedShortGrayscaleBufferedImageSource(sArray, this.width, this.height, n3, n5, n4, this.largestGray);
                } else {
                    this.imgs = null;
                    this.bufferedImageSource = new UnsignedShortGrayscaleBufferedImageSource(sArray, this.width, this.height, n3, this.largestGray);
                }
            }
        } else if ((this.isGrayscale || this.isPaletteColor) && n2 == 1 && n <= 8) {
            byte[] byArray = null;
            Attribute attribute11 = attributeList.get(TagFromName.PixelData);
            if (ValueRepresentation.isOtherByteVR(attribute11.getVR())) {
                byte[] byArray2 = attribute11.getByteValues();
                byArray = new byte[n9];
                for (int i = 0; i < n9; ++i) {
                    int n13 = byArray2[i] & n3;
                    if (this.signed && (n13 & n5) != 0) {
                        n13 |= n4;
                    }
                    byArray[i] = (byte)n13;
                    if (n13 > this.imgMax && n13 <= this.largestGray) {
                        this.imgMax = n13;
                    }
                    if (n13 >= this.imgMin) continue;
                    this.imgMin = n13;
                }
            } else {
                short[] sArray = attribute11.getShortValues();
                byArray = new byte[n9];
                int n14 = n9 / 2;
                int n15 = 0;
                int n16 = 0;
                while (n15 < n14) {
                    int n17 = sArray[n15++] & 0xFFFF;
                    int n18 = n17 & n3;
                    if (this.signed && (n18 & n5) != 0) {
                        n18 |= n4;
                    }
                    byArray[n16++] = (byte)n18;
                    if (n18 > this.imgMax && n18 <= this.largestGray) {
                        this.imgMax = n18;
                    }
                    if (n18 < this.imgMin) {
                        this.imgMin = n18;
                    }
                    int n19 = n17 >> 8 & n3;
                    if (this.signed && (n19 & n5) != 0) {
                        n19 |= n4;
                    }
                    byArray[n16++] = (byte)n19;
                    if (n19 > this.imgMax && n19 <= this.largestGray) {
                        this.imgMax = n19;
                    }
                    if (n19 >= this.imgMin) continue;
                    this.imgMin = n19;
                }
            }
            this.imgs = null;
            this.bufferedImageSource = new ByteGrayscaleBufferedImageSource(byArray, this.width, this.height);
        } else if (!this.isGrayscale && n2 == 3 && n <= 8) {
            byte[] byArray = null;
            Attribute attribute12 = attributeList.get(TagFromName.PixelData);
            if (ValueRepresentation.isOtherByteVR(attribute12.getVR())) {
                byArray = attribute12.getByteValues();
            } else {
                short[] sArray = attribute12.getShortValues();
                byArray = new byte[n9];
                int n20 = n9 / 2;
                int n21 = 0;
                int n22 = 0;
                while (n21 < n20) {
                    int n23 = sArray[n21++] & 0xFFFF;
                    int n24 = n23 & 0xFF;
                    byArray[n22++] = (byte)n24;
                    int n25 = n23 >> 8 & 0xFF;
                    byArray[n22++] = (byte)n25;
                }
            }
            this.imgs = null;
            this.bufferedImageSource = bl ? new BandInterleavedByteRGBBufferedImageSource(byArray, this.width, this.height) : new PixelInterleavedByteRGBBufferedImageSource(byArray, this.width, this.height);
        } else {
            throw new DicomException("Unsupported image photometric interpretation \"" + string + "\" or bit depth " + n);
        }
        this.realWorldValueTransform = new RealWorldValueTransform(attributeList);
        this.modalityTransform = new ModalityTransform(attributeList);
        this.voiTransform = new VOITransform(attributeList);
        this.displayShutter = new DisplayShutter(attributeList);
        this.backgroundValue = this.hasPad ? this.pad : (this.isGrayscale ? (this.inverted ? (this.signed ? n3 >> 1 : n3) : (this.signed ? (n3 >> 1) + 1 | n4 : 0)) : 0);
    }

    public BufferedImage getBufferedImage() {
        return this.getBufferedImage(0);
    }

    public BufferedImage getBufferedImage(int n) {
        BufferedImage bufferedImage = null;
        if (this.bufferedImageSource == null) {
            bufferedImage = this.imgs == null && n < this.imgs.length ? null : this.imgs[n];
        } else {
            bufferedImage = this.bufferedImageSource.getBufferedImage(n);
            this.imgMin = this.bufferedImageSource.getMinimumPixelValueOfMostRecentBufferedImage(this.imgMin);
            this.imgMax = this.bufferedImageSource.getMaximumPixelValueOfMostRecentBufferedImage(this.imgMax);
        }
        return bufferedImage;
    }

    public int getNumberOfBufferedImages() {
        return this.nframes;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    public int getMinimum() {
        return this.imgMin;
    }

    public int getMaximum() {
        return this.imgMax;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public boolean isPadded() {
        return this.hasPad;
    }

    public int getPadValue() {
        return this.pad;
    }

    public int getPadRangeLimit() {
        return this.padRangeLimit;
    }

    public int getBackgroundValue() {
        return this.backgroundValue;
    }

    public boolean isGrayscale() {
        return this.isGrayscale;
    }

    public String getTitle() {
        return this.title;
    }

    public int getNumberOfFrames() {
        return this.nframes;
    }

    public int getPaletteColorLargestGray() {
        return this.largestGray;
    }

    public int getPaletteColorFirstValueMapped() {
        return this.firstValueMapped;
    }

    public int getPaletteColorNumberOfEntries() {
        return this.numberOfEntries;
    }

    public int getPaletteColorBitsPerEntry() {
        return this.bitsPerEntry;
    }

    public short[] getPaletteColorRedTable() {
        return this.redTable;
    }

    public short[] getPaletteColorGreenTable() {
        return this.greenTable;
    }

    public short[] getPaletteColorBlueTable() {
        return this.blueTable;
    }

    public RealWorldValueTransform getRealWorldValueTransform() {
        return this.realWorldValueTransform;
    }

    public ModalityTransform getModalityTransform() {
        return this.modalityTransform;
    }

    public VOITransform getVOITransform() {
        return this.voiTransform;
    }

    public DisplayShutter getDisplayShutter() {
        return this.displayShutter;
    }

    private class PixelInterleavedByteRGBBufferedImageSource
    extends ByteBufferedImageSource {
        PixelInterleavedByteRGBBufferedImageSource(byte[] byArray, int n, int n2) {
            super(byArray, n, n2, 3);
        }

        public BufferedImage getUncachedBufferedImage(int n) {
            return SourceImage.createPixelInterleavedByteRGBImage(SourceImage.this.width, SourceImage.this.height, this.data, this.nframesamples * n);
        }
    }

    private class BandInterleavedByteRGBBufferedImageSource
    extends ByteBufferedImageSource {
        BandInterleavedByteRGBBufferedImageSource(byte[] byArray, int n, int n2) {
            super(byArray, n, n2, 3);
        }

        public BufferedImage getUncachedBufferedImage(int n) {
            return SourceImage.createBandInterleavedByteRGBImage(SourceImage.this.width, SourceImage.this.height, this.data, this.nframesamples * n);
        }
    }

    private class ByteGrayscaleBufferedImageSource
    extends ByteBufferedImageSource {
        ByteGrayscaleBufferedImageSource(byte[] byArray, int n, int n2) {
            super(byArray, n, n2, 1);
        }

        public BufferedImage getUncachedBufferedImage(int n) {
            return SourceImage.createByteGrayscaleImage(SourceImage.this.width, SourceImage.this.height, this.data, this.nframesamples * n);
        }
    }

    private class UnsignedShortGrayscaleBufferedImageSource
    extends ShortBufferedImageSource {
        protected int mask;
        protected int largestGray;

        UnsignedShortGrayscaleBufferedImageSource(short[] sArray, int n, int n2, int n3, int n4) {
            super(sArray, n, n2, 1);
            this.mask = n3;
            this.largestGray = n4;
            this.imgMin = 65535;
            this.imgMax = 0;
        }

        UnsignedShortGrayscaleBufferedImageSource(ShortBuffer shortBuffer, int n, int n2, int n3, int n4) {
            super(shortBuffer, n, n2, 1);
            this.mask = n3;
            this.largestGray = n4;
            this.imgMin = 65535;
            this.imgMax = 0;
        }

        public BufferedImage getUncachedBufferedImage(int n) {
            int n2;
            short[] sArray;
            if (this.data == null) {
                sArray = new short[this.nframesamples];
                int n3 = this.nframesamples * n;
                this.buffer.position(n3);
                this.buffer.get(sArray);
                n2 = 0;
            } else {
                sArray = this.data;
                n2 = this.nframesamples * n;
            }
            short[] sArray2 = new short[this.nframesamples];
            int n4 = n2;
            for (int i = 0; i < this.nframesamples; ++i) {
                int n5 = sArray[n4] & this.mask;
                sArray2[i] = (short)n5;
                if (n5 > this.imgMax && n5 <= this.largestGray) {
                    this.imgMax = n5;
                }
                if (n5 < this.imgMin) {
                    this.imgMin = n5;
                }
                ++n4;
            }
            this.minMaxSet = true;
            return SourceImage.createUnsignedShortGrayscaleImage(SourceImage.this.width, SourceImage.this.height, sArray2, 0);
        }
    }

    private class SignedShortGrayscaleBufferedImageSource
    extends ShortBufferedImageSource {
        protected int mask;
        protected int signbit;
        protected int extend;
        protected int largestGray;

        SignedShortGrayscaleBufferedImageSource(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6) {
            super(sArray, n, n2, 1);
            this.mask = n3;
            this.signbit = n4;
            this.extend = n5;
            this.largestGray = n6;
            this.imgMin = Short.MAX_VALUE;
            this.imgMax = Short.MIN_VALUE;
        }

        SignedShortGrayscaleBufferedImageSource(ShortBuffer shortBuffer, int n, int n2, int n3, int n4, int n5, int n6) {
            super(shortBuffer, n, n2, 1);
            this.mask = n3;
            this.signbit = n4;
            this.extend = n5;
            this.largestGray = n6;
            this.imgMin = Short.MAX_VALUE;
            this.imgMax = Short.MIN_VALUE;
        }

        public BufferedImage getUncachedBufferedImage(int n) {
            int n2;
            short[] sArray;
            if (this.data == null) {
                sArray = new short[this.nframesamples];
                int n3 = this.nframesamples * n;
                this.buffer.position(n3);
                this.buffer.get(sArray);
                n2 = 0;
            } else {
                sArray = this.data;
                n2 = this.nframesamples * n;
            }
            short[] sArray2 = new short[this.nframesamples];
            int n4 = n2;
            for (int i = 0; i < this.nframesamples; ++i) {
                int n5 = sArray[n4] & this.mask;
                if ((n5 & this.signbit) != 0) {
                    n5 |= this.extend;
                }
                sArray2[i] = (short)n5;
                if (n5 > this.imgMax && n5 <= this.largestGray) {
                    this.imgMax = n5;
                }
                if (n5 < this.imgMin) {
                    this.imgMin = n5;
                }
                ++n4;
            }
            this.minMaxSet = true;
            return SourceImage.createSignedShortGrayscaleImage(SourceImage.this.width, SourceImage.this.height, sArray2, 0);
        }
    }

    private abstract class ByteBufferedImageSource
    extends BufferedImageSource {
        protected byte[] data;

        ByteBufferedImageSource(byte[] byArray, int n, int n2, int n3) {
            super(n * n2 * n3);
            this.data = byArray;
        }
    }

    private abstract class ShortBufferedImageSource
    extends BufferedImageSource {
        protected short[] data;
        protected ShortBuffer buffer;
        protected boolean minMaxSet;
        protected int imgMin;
        protected int imgMax;

        public int getMinimumPixelValueOfMostRecentBufferedImage(int n) {
            return this.minMaxSet ? this.imgMin : n;
        }

        public int getMaximumPixelValueOfMostRecentBufferedImage(int n) {
            return this.minMaxSet ? this.imgMax : n;
        }

        ShortBufferedImageSource(short[] sArray, int n, int n2, int n3) {
            super(n * n2 * n3);
            this.data = sArray;
            this.minMaxSet = false;
        }

        ShortBufferedImageSource(ShortBuffer shortBuffer, int n, int n2, int n3) {
            super(n * n2 * n3);
            this.buffer = shortBuffer;
            this.minMaxSet = false;
        }

        protected void finalize() throws Throwable {
            this.data = null;
            this.buffer = null;
            super.finalize();
        }
    }

    private abstract class BufferedImageSource {
        protected int nframesamples;
        private int cachedIndex;
        BufferedImage cachedBufferedImage;

        BufferedImageSource(int n) {
            this.nframesamples = n;
            this.cachedIndex = -1;
            this.cachedBufferedImage = null;
        }

        protected void finalize() throws Throwable {
            this.cachedBufferedImage = null;
            super.finalize();
        }

        public BufferedImage getBufferedImage(int n) {
            if (n != this.cachedIndex) {
                this.cachedBufferedImage = this.getUncachedBufferedImage(n);
                this.cachedIndex = this.cachedBufferedImage != null ? n : -1;
            }
            return this.cachedBufferedImage;
        }

        public abstract BufferedImage getUncachedBufferedImage(int var1);

        public int getMinimumPixelValueOfMostRecentBufferedImage(int n) {
            return n;
        }

        public int getMaximumPixelValueOfMostRecentBufferedImage(int n) {
            return n;
        }
    }
}

