/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.utils.ByteArray;

class AReleasePDU {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/AReleasePDU.java,v 1.5 2003/10/09 21:38:36 dclunie Exp $";
    private byte[] b;
    private int pduType;
    private int pduLength;

    public AReleasePDU(int n) throws DicomNetworkException {
        this.pduType = n;
        this.b = new byte[10];
        this.b[0] = (byte)n;
        this.b[1] = 0;
        this.pduLength = 4;
        this.b[2] = (byte)(this.pduLength >> 24);
        this.b[3] = (byte)(this.pduLength >> 16);
        this.b[4] = (byte)(this.pduLength >> 8);
        this.b[5] = (byte)this.pduLength;
        this.b[6] = 0;
        this.b[7] = 0;
        this.b[8] = 0;
        this.b[9] = 0;
    }

    public AReleasePDU(byte[] byArray) throws DicomNetworkException {
        this.b = byArray;
        this.pduType = this.b[0] & 0xFF;
        this.pduLength = ByteArray.bigEndianToUnsignedInt(this.b, 2, 4);
    }

    public byte[] getBytes() {
        return this.b;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PDU Type: 0x");
        stringBuffer.append(this.pduType);
        stringBuffer.append(this.pduType == 5 ? " (A-RELEASE-RQ)" : (this.pduType == 6 ? " (A-RELEASE-RP)" : " unrecognized"));
        stringBuffer.append("\n");
        stringBuffer.append("Length: 0x");
        stringBuffer.append(Integer.toHexString(this.pduLength));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

