/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.DicomStreamCopier;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.network.AReleaseException;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationFactory;
import com.pixelmed.network.AssociationInitiator;
import com.pixelmed.network.AssociationOutputStream;
import com.pixelmed.network.CStoreRequestCommandMessage;
import com.pixelmed.network.CompositeResponseHandler;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.MultipleInstanceTransferStatusHandler;
import com.pixelmed.network.PresentationContextListFactory;
import com.pixelmed.utils.CopyStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class StorageSOPClassSCU
extends SOPClass {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/StorageSOPClassSCU.java,v 1.41 2007/07/23 12:16:34 dclunie Exp $";
    protected int debugLevel;

    protected boolean sendOneSOPInstance(Association association, String string, String string2, String string3, DicomInputStream dicomInputStream, byte by, String string4) throws AReleaseException, DicomNetworkException, DicomException, IOException {
        return this.sendOneSOPInstance(association, string, string2, string3, dicomInputStream, by, string4, null, -1);
    }

    protected boolean sendOneSOPInstance(Association association, String string, String string2, String string3, DicomInputStream dicomInputStream, byte by, String string4, String string5, int n) throws AReleaseException, DicomNetworkException, DicomException, IOException {
        byte[] byArray = new CStoreRequestCommandMessage(string, string2, string5, n).getBytes();
        CStoreResponseHandler cStoreResponseHandler = new CStoreResponseHandler(this.debugLevel);
        association.setReceivedDataHandler(cStoreResponseHandler);
        association.send(by, byArray, null);
        AssociationOutputStream associationOutputStream = association.getAssociationOutputStream(by);
        if (string3.equals(string4)) {
            CopyStream.copy(dicomInputStream, associationOutputStream);
            ((OutputStream)associationOutputStream).close();
        } else {
            if (this.debugLevel > 0) {
                System.err.println("StorageSOPClassSCU.sendOneSOPInstance(): different transfer syntaxes; converting " + string3 + " to " + string4);
            }
            DicomOutputStream dicomOutputStream = new DicomOutputStream(associationOutputStream, null, string4);
            new DicomStreamCopier(dicomInputStream, dicomOutputStream);
        }
        if (this.debugLevel > 0) {
            System.err.println("StorageSOPClassSCU.sendOneSOPInstance(): about to wait for PDUs");
        }
        association.waitForCommandPDataPDUs();
        return cStoreResponseHandler.wasSuccessful();
    }

    protected boolean sendOneSOPInstance(Association association, String string, String string2, AttributeList attributeList, byte by, String string3, String string4, int n) throws AReleaseException, DicomNetworkException, DicomException, IOException {
        byte[] byArray = new CStoreRequestCommandMessage(string, string2, string4, n).getBytes();
        CStoreResponseHandler cStoreResponseHandler = new CStoreResponseHandler(this.debugLevel);
        association.setReceivedDataHandler(cStoreResponseHandler);
        association.send(by, byArray, null);
        AssociationOutputStream associationOutputStream = association.getAssociationOutputStream(by);
        if (this.debugLevel > 0) {
            System.err.println("StorageSOPClassSCU.sendOneSOPInstance(): writing attribute list as " + string3);
        }
        attributeList.write(associationOutputStream, string3, false, true, false);
        if (this.debugLevel > 0) {
            System.err.println("StorageSOPClassSCU.sendOneSOPInstance(): about to wait for PDUs");
        }
        association.waitForCommandPDataPDUs();
        return cStoreResponseHandler.wasSuccessful();
    }

    protected StorageSOPClassSCU() throws DicomNetworkException, DicomException, IOException {
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2, int n3) throws DicomNetworkException, DicomException, IOException {
        this(string, n, string2, string3, string4, string5, string6, n2, null, -1, n3);
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2, String string7, int n3, int n4) throws DicomNetworkException, DicomException, IOException {
        String string8;
        Object object;
        BufferedInputStream bufferedInputStream;
        DicomInputStream dicomInputStream;
        this.debugLevel = n4;
        if (n4 > 0) {
            System.err.println("StorageSOPClassSCU: storing " + string4);
        }
        if ((dicomInputStream = new DicomInputStream(bufferedInputStream = new BufferedInputStream(new FileInputStream(string4)))).haveMetaHeader()) {
            object = new AttributeList();
            ((AttributeList)object).readOnlyMetaInformationHeader(dicomInputStream);
            if (n4 > 0) {
                System.err.println("Meta header information = " + object);
            }
            string5 = Attribute.getSingleStringValueOrNull((AttributeList)object, TagFromName.MediaStorageSOPClassUID);
            string6 = Attribute.getSingleStringValueOrNull((AttributeList)object, TagFromName.MediaStorageSOPInstanceUID);
            string8 = Attribute.getSingleStringValueOrNull((AttributeList)object, TagFromName.TransferSyntaxUID);
        } else {
            string8 = dicomInputStream.getTransferSyntaxToReadDataSet().getUID();
        }
        if (n4 > 0) {
            System.err.println("Using inputTransferSyntax " + string8);
        }
        if (string5 == null) {
            throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Affected SOP Class UID");
        }
        if (string6 == null) {
            throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Affected SOP Instance UID");
        }
        object = new PresentationContextListFactory();
        LinkedList linkedList = PresentationContextListFactory.createNewPresentationContextList(string5, string8, n2);
        AssociationInitiator associationInitiator = AssociationFactory.createNewAssociation(string, n, string2, string3, linkedList, null, false, n4);
        if (n4 > 0) {
            System.err.println(associationInitiator);
        }
        byte by = associationInitiator.getSuitablePresentationContextID(string5);
        if (n4 > 0) {
            System.err.println("Using context ID " + by);
        }
        String string9 = associationInitiator.getTransferSyntaxForPresentationContextID(by);
        if (n4 > 0) {
            System.err.println("Using outputTransferSyntax " + string9);
        }
        boolean bl = false;
        try {
            bl = this.sendOneSOPInstance(associationInitiator, string5, string6, string8, dicomInputStream, by, string9, string7, n3);
            associationInitiator.release();
        }
        catch (AReleaseException aReleaseException) {
            // empty catch block
        }
        if (n4 > 0) {
            System.err.println("Send " + (bl ? "succeeded" : "failed"));
        }
    }

    public StorageSOPClassSCU(Association association, SetOfDicomFiles setOfDicomFiles, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, int n) {
        this(association, setOfDicomFiles, multipleInstanceTransferStatusHandler, null, -1, n);
    }

    public StorageSOPClassSCU(Association association, SetOfDicomFiles setOfDicomFiles, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, String string, int n, int n2) {
        this.debugLevel = n2;
        try {
            this.sendMultipleSOPInstances(association, setOfDicomFiles, multipleInstanceTransferStatusHandler, string, n);
        }
        catch (AReleaseException aReleaseException) {
        }
        catch (DicomNetworkException dicomNetworkException) {
            dicomNetworkException.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, SetOfDicomFiles setOfDicomFiles, int n2, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, int n3) {
        this(string, n, string2, string3, setOfDicomFiles, n2, multipleInstanceTransferStatusHandler, null, -1, n3);
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, SetOfDicomFiles setOfDicomFiles, int n2, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, String string4, int n3, int n4) {
        this.debugLevel = n4;
        try {
            PresentationContextListFactory presentationContextListFactory = new PresentationContextListFactory();
            LinkedList linkedList = PresentationContextListFactory.createNewPresentationContextList(setOfDicomFiles, n2);
            AssociationInitiator associationInitiator = AssociationFactory.createNewAssociation(string, n, string2, string3, linkedList, null, false, n4);
            this.sendMultipleSOPInstances((Association)associationInitiator, setOfDicomFiles, multipleInstanceTransferStatusHandler, string4, n3);
            associationInitiator.release();
        }
        catch (AReleaseException aReleaseException) {
        }
        catch (DicomNetworkException dicomNetworkException) {
            dicomNetworkException.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, Set set, AttributeList[] attributeListArray, int n2, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, String string4, int n3, int n4) {
        this.debugLevel = n4;
        try {
            PresentationContextListFactory presentationContextListFactory = new PresentationContextListFactory();
            LinkedList linkedList = PresentationContextListFactory.createNewPresentationContextList(set, n2);
            AssociationInitiator associationInitiator = AssociationFactory.createNewAssociation(string, n, string2, string3, linkedList, null, false, n4);
            this.sendMultipleSOPInstances((Association)associationInitiator, attributeListArray, multipleInstanceTransferStatusHandler, string4, n3);
            associationInitiator.release();
        }
        catch (AReleaseException aReleaseException) {
        }
        catch (DicomNetworkException dicomNetworkException) {
            dicomNetworkException.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }

    protected void sendMultipleSOPInstances(Association association, SetOfDicomFiles setOfDicomFiles, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, String string, int n) throws AReleaseException, DicomNetworkException, IOException {
        int n2 = setOfDicomFiles.size();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.debugLevel > 0) {
            System.err.println(association);
        }
        Iterator iterator = setOfDicomFiles.iterator();
        while (iterator.hasNext()) {
            --n2;
            ++n3;
            SetOfDicomFiles.DicomFile dicomFile = (SetOfDicomFiles.DicomFile)iterator.next();
            String string2 = dicomFile.getFileName();
            if (this.debugLevel > 0) {
                System.err.println("Sending " + string2);
            }
            boolean bl = false;
            String string3 = null;
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
                String string4 = null;
                String string5 = null;
                DicomInputStream dicomInputStream = new DicomInputStream(bufferedInputStream);
                if (dicomInputStream.haveMetaHeader()) {
                    AttributeList attributeList = new AttributeList();
                    attributeList.readOnlyMetaInformationHeader(dicomInputStream);
                    if (this.debugLevel > 0) {
                        System.err.println("Meta header information = " + attributeList);
                    }
                    string5 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.MediaStorageSOPClassUID);
                    string3 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.MediaStorageSOPInstanceUID);
                    string4 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.TransferSyntaxUID);
                } else {
                    string5 = dicomFile.getSOPClassUID();
                    string3 = dicomFile.getSOPInstanceUID();
                    string4 = dicomInputStream.getTransferSyntaxToReadDataSet().getUID();
                }
                if (this.debugLevel > 1) {
                    System.err.println("StorageSOPClassSCU(): affectedSOPClass = " + string5);
                }
                if (this.debugLevel > 1) {
                    System.err.println("StorageSOPClassSCU(): affectedSOPInstance = " + string3);
                }
                if (this.debugLevel > 1) {
                    System.err.println("StorageSOPClassSCU(): inputTransferSyntax = " + string4);
                }
                if (string5 == null) {
                    throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Affected SOP Class UID");
                }
                if (string3 == null) {
                    throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Affected SOP Instance UID");
                }
                if (string4 == null) {
                    throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Transfer Syntax UID");
                }
                byte by = association.getSuitablePresentationContextID(string5);
                if (this.debugLevel > 0) {
                    System.err.println("Using context ID " + by);
                }
                String string6 = association.getTransferSyntaxForPresentationContextID(by);
                if (this.debugLevel > 0) {
                    System.err.println("Using outputTransferSyntax " + string6);
                }
                bl = this.sendOneSOPInstance(association, string5, string3, string4, dicomInputStream, by, string6, string, n);
            }
            catch (DicomNetworkException dicomNetworkException) {
                dicomNetworkException.printStackTrace(System.err);
                bl = false;
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
                bl = false;
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                bl = false;
            }
            if (!bl) {
                ++n4;
            }
            if (this.debugLevel > 0) {
                System.err.println("Send " + string2 + " " + (bl ? "succeeded" : "failed"));
            }
            if (multipleInstanceTransferStatusHandler == null) continue;
            multipleInstanceTransferStatusHandler.updateStatus(n2, n3, n4, n5, string3);
        }
        if (this.debugLevel > 0) {
            System.err.println("StorageSOPClassSCU(): Finished sending all files nRemaining=" + n2 + " nCompleted=" + n3 + " nFailed=" + n4 + " nWarning=" + n5);
        }
    }

    protected void sendMultipleSOPInstances(Association association, AttributeList[] attributeListArray, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, String string, int n) throws AReleaseException, DicomNetworkException, IOException {
        int n2 = attributeListArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.debugLevel > 0) {
            System.err.println(association);
        }
        for (int i = 0; i < attributeListArray.length; ++i) {
            --n2;
            ++n3;
            AttributeList attributeList = attributeListArray[i];
            boolean bl = false;
            String string2 = null;
            try {
                String string3 = null;
                string3 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPClassUID);
                string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID);
                if (this.debugLevel > 0) {
                    System.err.println("Sending " + string2);
                }
                if (this.debugLevel > 1) {
                    System.err.println("StorageSOPClassSCU(): affectedSOPClass = " + string3);
                }
                if (string3 == null) {
                    throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Affected SOP Class UID");
                }
                if (string2 == null) {
                    throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Affected SOP Instance UID");
                }
                byte by = association.getSuitablePresentationContextID(string3);
                if (this.debugLevel > 0) {
                    System.err.println("Using context ID " + by);
                }
                String string4 = association.getTransferSyntaxForPresentationContextID(by);
                if (this.debugLevel > 0) {
                    System.err.println("Using outputTransferSyntax " + string4);
                }
                bl = this.sendOneSOPInstance(association, string3, string2, attributeList, by, string4, string, n);
            }
            catch (DicomNetworkException dicomNetworkException) {
                dicomNetworkException.printStackTrace(System.err);
                bl = false;
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
                bl = false;
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                bl = false;
            }
            if (!bl) {
                ++n4;
            }
            if (this.debugLevel > 0) {
                System.err.println("Send " + string2 + " " + (bl ? "succeeded" : "failed"));
            }
            if (multipleInstanceTransferStatusHandler == null) continue;
            multipleInstanceTransferStatusHandler.updateStatus(n2, n3, n4, n5, string2);
        }
        if (this.debugLevel > 0) {
            System.err.println("StorageSOPClassSCU(): Finished sending all files nRemaining=" + n2 + " nCompleted=" + n3 + " nFailed=" + n4 + " nWarning=" + n5);
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = null;
            int n = -1;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            int n2 = 0;
            int n3 = 0;
            if (stringArray.length == 9) {
                string = stringArray[0];
                n = Integer.parseInt(stringArray[1]);
                string2 = stringArray[2];
                string3 = stringArray[3];
                string4 = stringArray[4];
                string5 = stringArray[5];
                string6 = stringArray[6];
                n2 = Integer.parseInt(stringArray[7]);
                n3 = Integer.parseInt(stringArray[8]);
            } else if (stringArray.length == 7) {
                string = stringArray[0];
                n = Integer.parseInt(stringArray[1]);
                string2 = stringArray[2];
                string3 = stringArray[3];
                string4 = stringArray[4];
                string5 = null;
                string6 = null;
                n2 = Integer.parseInt(stringArray[5]);
                n3 = Integer.parseInt(stringArray[6]);
            } else {
                throw new Exception("Argument list must be 7 or 9 values");
            }
            if (string4.equals("-")) {
                SetOfDicomFiles setOfDicomFiles = new SetOfDicomFiles();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                String string7 = bufferedReader.readLine();
                while (string7 != null) {
                    if (string5 == null) {
                        setOfDicomFiles.add(string7);
                    } else {
                        setOfDicomFiles.add(string7, string5, null, null);
                    }
                    string7 = bufferedReader.readLine();
                }
                new StorageSOPClassSCU(string, n, string2, string3, setOfDicomFiles, n2, null, null, 0, n3);
            } else {
                new StorageSOPClassSCU(string, n, string2, string3, string4, string5, string6, n2, n3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }

    protected class CStoreResponseHandler
    extends CompositeResponseHandler {
        CStoreResponseHandler(int n) {
            super(n);
        }

        protected void evaluateStatusAndSetSuccess(AttributeList attributeList) {
            int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Status, 65535);
            this.success = n == 0 || n == 45056 || n == 45063 || n == 45062;
        }
    }
}

