/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.scpecg;

import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.scpecg.SCPTreeRecord;
import com.pixelmed.scpecg.Section;
import com.pixelmed.scpecg.SectionHeader;
import com.pixelmed.utils.HexDump;
import java.io.IOException;

public class Section8Or11
extends Section {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/scpecg/Section8Or11.java,v 1.3 2004/01/25 03:47:20 dclunie Exp $";
    private int confirmed;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int numberOfStatements;
    private int[] sequenceNumbers;
    private int[] statementLengths;
    private byte[][] statements;

    public String getSectionName() {
        return this.header.getSectionIDNumber() == 8 ? "Textual Diagnosis" : "Universal Interpretative Statement Codes";
    }

    public int getConfirmed() {
        return this.confirmed;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getNumberOfStatements() {
        return this.numberOfStatements;
    }

    public int[] getSequenceNumbers() {
        return this.sequenceNumbers;
    }

    public int[] getStatementLengths() {
        return this.statementLengths;
    }

    public byte[][] getStatements() {
        return this.statements;
    }

    public Section8Or11(SectionHeader sectionHeader) {
        super(sectionHeader);
    }

    public long read(BinaryInputStream binaryInputStream) throws IOException {
        int n;
        this.confirmed = binaryInputStream.readUnsigned8();
        ++this.bytesRead;
        --this.sectionBytesRemaining;
        this.year = binaryInputStream.readUnsigned16();
        this.bytesRead += 2L;
        this.sectionBytesRemaining -= 2L;
        this.month = binaryInputStream.readUnsigned8();
        ++this.bytesRead;
        --this.sectionBytesRemaining;
        this.day = binaryInputStream.readUnsigned8();
        ++this.bytesRead;
        --this.sectionBytesRemaining;
        this.hour = binaryInputStream.readUnsigned8();
        ++this.bytesRead;
        --this.sectionBytesRemaining;
        this.minute = binaryInputStream.readUnsigned8();
        ++this.bytesRead;
        --this.sectionBytesRemaining;
        this.second = binaryInputStream.readUnsigned8();
        ++this.bytesRead;
        --this.sectionBytesRemaining;
        this.numberOfStatements = binaryInputStream.readUnsigned8();
        ++this.bytesRead;
        --this.sectionBytesRemaining;
        this.sequenceNumbers = new int[this.numberOfStatements];
        this.statementLengths = new int[this.numberOfStatements];
        this.statements = new byte[this.numberOfStatements][];
        for (n = 0; this.sectionBytesRemaining > 0L && n < this.numberOfStatements; ++n) {
            this.sequenceNumbers[n] = binaryInputStream.readUnsigned8();
            ++this.bytesRead;
            --this.sectionBytesRemaining;
            this.statementLengths[n] = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            int n2 = this.statementLengths[n];
            if (n2 <= 0) continue;
            if ((long)n2 > this.sectionBytesRemaining) {
                System.err.println("Section " + this.header.getSectionIDNumber() + " Statement length wanted " + n2 + " is longer than " + this.sectionBytesRemaining + " dec bytes remaining in section" + ", giving up on rest of section");
                this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
                continue;
            }
            this.statements[n] = new byte[n2];
            binaryInputStream.readInsistently(this.statements[n], 0, n2);
            this.bytesRead += (long)n2;
            this.sectionBytesRemaining -= (long)n2;
        }
        if (n != this.numberOfStatements) {
            System.err.println("Section " + this.header.getSectionIDNumber() + " Number of statements specified as " + this.numberOfStatements + " but encountered only " + n + " (valid) statements");
        }
        this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
        return this.bytesRead;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Confirmed = " + this.confirmed + " dec (0x" + Integer.toHexString(this.confirmed) + ")\n");
        stringBuffer.append("Date = " + this.year + "/" + this.month + "/" + this.day + "\n");
        stringBuffer.append("Time = " + this.hour + ":" + this.minute + ":" + this.second + "\n");
        stringBuffer.append("Number of Statements = " + this.numberOfStatements + " dec\n");
        stringBuffer.append("Statements:\n");
        for (n = 0; n < this.numberOfStatements; ++n) {
            stringBuffer.append("\tStatement " + n + ":\n");
            stringBuffer.append("\t\tSequence Number " + this.sequenceNumbers[n] + " dec (0x" + Integer.toHexString(this.sequenceNumbers[n]) + ")\n");
            stringBuffer.append("\t\tStatement Length " + this.statementLengths[n] + " dec (0x" + Integer.toHexString(this.statementLengths[n]) + ")\n");
            stringBuffer.append("\t\tStatement <" + (this.statements[n] == null ? "" : Section8Or11.makeStringFromByteArrayRemovingAnyNulls(this.statements[n])) + ")\n");
            stringBuffer.append(HexDump.dump(this.statements[n]));
        }
        stringBuffer.append("\tStatements combined:\n");
        for (n = 0; n < this.numberOfStatements; ++n) {
            stringBuffer.append((this.statements[n] == null ? "" : Section8Or11.makeStringFromByteArrayRemovingAnyNulls(this.statements[n])) + ")\n");
        }
        return stringBuffer.toString();
    }

    public String validate() {
        return "";
    }

    public SCPTreeRecord getTree(SCPTreeRecord sCPTreeRecord) {
        if (this.tree == null) {
            SCPTreeRecord sCPTreeRecord2 = new SCPTreeRecord(sCPTreeRecord, "Section", this.getValueForSectionNodeInTree());
            this.addSectionHeaderToTree(sCPTreeRecord2);
            new SCPTreeRecord(sCPTreeRecord2, "Confirmed", Integer.toString(this.confirmed) + " dec (0x" + Integer.toHexString(this.confirmed) + ")");
            new SCPTreeRecord(sCPTreeRecord2, "Date", this.year + "/" + this.month + "/" + this.day);
            new SCPTreeRecord(sCPTreeRecord2, "Time", this.hour + ":" + this.minute + ":" + this.second);
            new SCPTreeRecord(sCPTreeRecord2, "Number of Statements", Integer.toString(this.numberOfStatements) + " dec (0x" + Integer.toHexString(this.numberOfStatements) + ")");
            SCPTreeRecord sCPTreeRecord3 = new SCPTreeRecord(sCPTreeRecord2, "Statements");
            for (int i = 0; i < this.numberOfStatements; ++i) {
                SCPTreeRecord sCPTreeRecord4 = new SCPTreeRecord(sCPTreeRecord3, this.sequenceNumbers[i], this.statements[i] == null ? "" : Section8Or11.makeStringFromByteArrayRemovingAnyNulls(this.statements[i]));
            }
        }
        return this.tree;
    }
}

