/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.validate;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.XMLRepresentationOfStructuredReportObjectFactory;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class DicomSRValidator {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/validate/DicomSRValidator.java,v 1.1 2008/04/16 14:36:37 dclunie Exp $";
    private Transformer transformer;

    public DicomSRValidator() throws TransformerConfigurationException {
        InputStream inputStream = DicomSRValidator.class.getResourceAsStream("/com/pixelmed/validate/DicomSRDescriptionsCompiled.xsl");
        StreamSource streamSource = new StreamSource(inputStream);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setURIResolver(new OurURIResolver());
        this.transformer = transformerFactory.newTransformer(streamSource);
    }

    public String validate(AttributeList attributeList) throws ParserConfigurationException, TransformerException, UnsupportedEncodingException {
        Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(attributeList);
        DOMSource dOMSource = new DOMSource(document);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        this.transformer.transform(dOMSource, streamResult);
        return byteArrayOutputStream.toString("UTF-8");
    }

    public static void main(String[] stringArray) {
        try {
            AttributeList attributeList = new AttributeList();
            attributeList.read(stringArray[0], null, true, true);
            DicomSRValidator dicomSRValidator = new DicomSRValidator();
            System.out.print(dicomSRValidator.validate(attributeList));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private class OurURIResolver
    implements URIResolver {
        private OurURIResolver() {
        }

        public Source resolve(String string, String string2) throws TransformerException {
            InputStream inputStream = DicomSRValidator.class.getResourceAsStream("/com/pixelmed/validate/" + string);
            return new StreamSource(inputStream);
        }
    }
}

