/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.utils.StringUtilities;
import com.pixelmed.web.WebRequest;
import java.util.Map;
import java.util.StringTokenizer;

public class WadoRequest
extends WebRequest {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/WadoRequest.java,v 1.6 2007/06/22 19:59:53 dclunie Exp $";
    private String studyUID;
    private String seriesUID;
    private String objectUID;
    private String[][] contentTypes;
    private String[] charsets;
    private String anonymize;
    private String[] annotations;
    private int rows;
    private int columns;
    private double[] region;
    private double windowCenter;
    private double windowWidth;
    private int frameNumber;
    private int imageQuality;
    private String presentationUID;
    private String presentationSeriesUID;
    private String transferSyntax;

    public String getStudyUID() {
        return this.studyUID;
    }

    public String getSeriesUID() {
        return this.seriesUID;
    }

    public String getObjectUID() {
        return this.objectUID;
    }

    public String[][] getContentType() {
        return this.contentTypes;
    }

    public boolean isContentTypeDicom() {
        return this.contentTypes != null && this.contentTypes.length == 1 && this.contentTypes[0] != null && this.contentTypes[0].length >= 1 && this.contentTypes[0][0] != null && this.contentTypes[0][0].toLowerCase().equals("application/dicom");
    }

    public String[] getCharset() {
        return this.charsets;
    }

    public String getAnonymize() {
        return this.anonymize;
    }

    public String[] getAnnotation() {
        return this.annotations;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public double[] getRegion() {
        return this.region;
    }

    public double getWindowCenter() {
        return this.windowCenter;
    }

    public double getWindowWidth() {
        return this.windowWidth;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public int getImageQuality() {
        return this.imageQuality;
    }

    public String getPresentationUID() {
        return this.presentationUID;
    }

    public String getPresentationSeriesUID() {
        return this.presentationSeriesUID;
    }

    public String getTransferSyntax() {
        return this.transferSyntax;
    }

    public static boolean validateUID(String string) {
        return string != null && string.length() > 0 && string.length() <= 64 && string.matches("[0-9.]*");
    }

    public static String[] getSeparatedValues(String string, String string2) {
        String[] stringArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        if (n > 0) {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
        }
        return stringArray;
    }

    public static String[] getCommaSeparatedValues(String string) {
        return WadoRequest.getSeparatedValues(string, ",");
    }

    public static String[] getSemicolonSeparatedValues(String string) {
        return WadoRequest.getSeparatedValues(string, ";");
    }

    public static String[][] getCommaThenSemicolonSeparatedValues(String string) {
        int n;
        String[][] stringArray = null;
        String[] stringArray2 = WadoRequest.getCommaSeparatedValues(string);
        if (stringArray2 != null && (n = stringArray2.length) > 0) {
            stringArray = new String[n][];
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray2[i];
                stringArray[i] = string2 == null ? null : WadoRequest.getSemicolonSeparatedValues(string2);
            }
        }
        return stringArray;
    }

    public static String toString(double[] dArray) {
        return StringUtilities.toString(dArray);
    }

    public static String toString(String[] stringArray) {
        return StringUtilities.toString(stringArray);
    }

    public static String toString(String[][] stringArray) {
        return StringUtilities.toString(stringArray);
    }

    public static int getSingleIntegerValueFromParameters(Map map, String string) throws Exception {
        String string2 = (String)map.get(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception(string + " must be an integer string \"" + string2 + "\"");
            }
        }
        return -1;
    }

    public static double getSingleDoubleValueFromParameters(Map map, String string) throws Exception {
        String string2 = (String)map.get(string);
        if (string2 != null) {
            try {
                return Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception(string + " must be a decimal string \"" + string2 + "\"");
            }
        }
        return 0.0;
    }

    public WadoRequest(WebRequest webRequest) throws Exception {
        this.scheme = webRequest.getScheme();
        this.userInfo = webRequest.getUserInfo();
        this.host = webRequest.getHost();
        this.port = webRequest.getPort();
        this.path = webRequest.getPath();
        this.requestType = webRequest.getRequestType();
        this.parameters = webRequest.getParameters();
        this.parseWadoParameters();
    }

    public WadoRequest(String string) throws Exception {
        super(string);
        this.parseWadoParameters();
    }

    private void parseWadoParameters() throws Exception {
        String string;
        if (this.requestType == null || !this.requestType.equals("WADO")) {
            throw new Exception("requestType missing or not WADO \"" + this.requestType + "\"");
        }
        this.studyUID = (String)this.parameters.get("studyUID");
        if (!WadoRequest.validateUID(this.studyUID)) {
            throw new Exception("studyUID missing or not valid \"" + this.studyUID + "\"");
        }
        this.seriesUID = (String)this.parameters.get("seriesUID");
        if (!WadoRequest.validateUID(this.seriesUID)) {
            throw new Exception("seriesUID missing or not valid \"" + this.seriesUID + "\"");
        }
        this.objectUID = (String)this.parameters.get("objectUID");
        if (!WadoRequest.validateUID(this.objectUID)) {
            throw new Exception("objectUID missing or not valid \"" + this.objectUID + "\"");
        }
        String string2 = (String)this.parameters.get("contentType");
        if (string2 != null) {
            this.contentTypes = WadoRequest.getCommaThenSemicolonSeparatedValues(string2);
        }
        if ((string = (String)this.parameters.get("charset")) != null) {
            this.charsets = WadoRequest.getCommaSeparatedValues(string);
        }
        this.anonymize = (String)this.parameters.get("anonymize");
        if (this.anonymize != null && !this.anonymize.equals("yes")) {
            throw new Exception("anonymize must be absent or yes \"" + this.anonymize + "\"");
        }
        String string3 = (String)this.parameters.get("annotation");
        if (string3 != null) {
            this.annotations = WadoRequest.getCommaSeparatedValues(string3);
        }
        this.rows = WadoRequest.getSingleIntegerValueFromParameters(this.parameters, "rows");
        this.columns = WadoRequest.getSingleIntegerValueFromParameters(this.parameters, "columns");
        String string4 = (String)this.parameters.get("region");
        if (string4 != null) {
            String[] stringArray = WadoRequest.getCommaSeparatedValues(string4);
            if (stringArray == null || stringArray.length != 4) {
                throw new Exception("region must be four comma delimited decimal strings \"" + string4 + "\"");
            }
            this.region = new double[4];
            for (int i = 0; i < 4; ++i) {
                try {
                    this.region[i] = Double.parseDouble(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception("region value must be a decimal string \"" + stringArray[i] + "\"");
                }
            }
        }
        this.windowCenter = WadoRequest.getSingleDoubleValueFromParameters(this.parameters, "windowCenter");
        this.windowWidth = WadoRequest.getSingleDoubleValueFromParameters(this.parameters, "windowWidth");
        if (this.parameters.get("windowCenter") == null && this.parameters.get("windowWidth") != null) {
            throw new Exception("windowCenter missing but require since windowWidth is present");
        }
        if (this.parameters.get("windowCenter") != null && this.parameters.get("windowWidth") == null) {
            throw new Exception("windowWidth missing but require since windowCenter is present");
        }
        this.frameNumber = WadoRequest.getSingleIntegerValueFromParameters(this.parameters, "frameNumber");
        this.imageQuality = WadoRequest.getSingleIntegerValueFromParameters(this.parameters, "imageQuality");
        if (this.imageQuality != -1 && (this.imageQuality < 1 || this.imageQuality > 100)) {
            throw new Exception("imageQuality must be between 1 and 100 \"" + this.imageQuality + "\"");
        }
        this.presentationUID = (String)this.parameters.get("presentationUID");
        if (this.presentationUID != null && !WadoRequest.validateUID(this.presentationUID)) {
            throw new Exception("presentationUID not valid \"" + this.presentationUID + "\"");
        }
        this.presentationSeriesUID = (String)this.parameters.get("presentationSeriesUID");
        if (this.presentationSeriesUID != null && !WadoRequest.validateUID(this.presentationSeriesUID)) {
            throw new Exception("presentationSeriesUID not valid \"" + this.presentationSeriesUID + "\"");
        }
        if (this.presentationUID != null && this.presentationSeriesUID == null) {
            throw new Exception("presentationSeriesUID missing but require since presentationUID is present");
        }
        if (this.presentationUID == null && this.presentationSeriesUID != null) {
            throw new Exception("presentationUID missing but require since presentationSeriesUID is present");
        }
        this.transferSyntax = (String)this.parameters.get("transferSyntax");
        if (this.transferSyntax != null && !WadoRequest.validateUID(this.transferSyntax)) {
            throw new Exception("transferSyntax not valid \"" + this.transferSyntax + "\"");
        }
        if (!this.isContentTypeDicom() && this.transferSyntax != null) {
            throw new Exception("transferSyntax is present but contentType is not application/dicom (only)");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("scheme = ");
        stringBuffer.append(this.scheme);
        stringBuffer.append("\n");
        stringBuffer.append("userInfo = ");
        stringBuffer.append(this.userInfo);
        stringBuffer.append("\n");
        stringBuffer.append("host = ");
        stringBuffer.append(this.host);
        stringBuffer.append("\n");
        stringBuffer.append("port = ");
        stringBuffer.append(this.port);
        stringBuffer.append("\n");
        stringBuffer.append("path = ");
        stringBuffer.append(this.path);
        stringBuffer.append("\n");
        stringBuffer.append("studyUID = ");
        stringBuffer.append(this.studyUID);
        stringBuffer.append("\n");
        stringBuffer.append("seriesUID = ");
        stringBuffer.append(this.seriesUID);
        stringBuffer.append("\n");
        stringBuffer.append("objectUID = ");
        stringBuffer.append(this.objectUID);
        stringBuffer.append("\n");
        stringBuffer.append("contentTypes = ");
        stringBuffer.append(WadoRequest.toString(this.contentTypes));
        stringBuffer.append("\n");
        stringBuffer.append("charsets = ");
        stringBuffer.append(WadoRequest.toString(this.charsets));
        stringBuffer.append("\n");
        stringBuffer.append("anonymize = ");
        stringBuffer.append(this.anonymize);
        stringBuffer.append("\n");
        stringBuffer.append("annotations = ");
        stringBuffer.append(WadoRequest.toString(this.annotations));
        stringBuffer.append("\n");
        stringBuffer.append("rows = ");
        stringBuffer.append(this.rows);
        stringBuffer.append("\n");
        stringBuffer.append("columns = ");
        stringBuffer.append(this.columns);
        stringBuffer.append("\n");
        stringBuffer.append("region = ");
        stringBuffer.append(WadoRequest.toString(this.region));
        stringBuffer.append("\n");
        stringBuffer.append("windowCenter = ");
        stringBuffer.append(this.windowCenter);
        stringBuffer.append("\n");
        stringBuffer.append("windowWidth = ");
        stringBuffer.append(this.windowWidth);
        stringBuffer.append("\n");
        stringBuffer.append("frameNumber = ");
        stringBuffer.append(this.frameNumber);
        stringBuffer.append("\n");
        stringBuffer.append("imageQuality = ");
        stringBuffer.append(this.imageQuality);
        stringBuffer.append("\n");
        stringBuffer.append("presentationUID = ");
        stringBuffer.append(this.presentationUID);
        stringBuffer.append("\n");
        stringBuffer.append("presentationSeriesUID = ");
        stringBuffer.append(this.presentationSeriesUID);
        stringBuffer.append("\n");
        stringBuffer.append("transferSyntax = ");
        stringBuffer.append(this.transferSyntax);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = "http://www.hospital-stmarco/radiology/wado.php?requestType=WADO&studyUID=1.2.250.1.59.40211.12345678.678910&seriesUID=1.2.250.1.59.40211.789001276.14556172.67789&objectUID=1.2.250.1.59.40211.2678810.87991027.899772.2";
        String string2 = "http://server234/script678.asp?requestType=WADO&studyUID=1.2.250.1.59.40211.12345678.678910&seriesUID=1.2.250.1.59.40211.789001276.14556172.67789&objectUID=1.2.250.1.59.40211.2678810.87991027.899772.2&charset=UTF-8";
        String string3 = "https://aspradio/imageaccess.js?requestType=WADO&studyUID=1.2.250.1.59.40211.12345678.678910&seriesUID=1.2.250.1.59.40211.789001276.14556172.67789&objectUID=1.2.250.1.59.40211.2678810.87991027.899772.2&contentType=image%2Fjp2%3Blevel%3D1%2Cimage%2Fjpeg%3Bq%3D0.5&annotation=patient%2Ctechnique&columns=400&rows=300&region=0.3%2C0.4%2C0.5%2C0.5&windowCenter=-1000&windowWidth=2500";
        String string4 = "http://www.medical-webservice.st/RetrieveDocument?requestType=WADO&studyUID=1.2.250.1.59.40211.12345678.678910&seriesUID=1.2.250.1.59.40211.789001276.14556172.67789&objectUID=1.2.250.1.59.40211.2678810.87991027.899772.2&contentType=application%2Fdicom&anonymize=yes&transferSyntax=1.2.840.10008.1.2.4.50";
        try {
            System.out.println("B1: \"" + string + "\"\n" + new WadoRequest(string).toString());
            System.out.println("B2: \"" + string2 + "\"\n" + new WadoRequest(string2).toString());
            System.out.println("B3: \"" + string3 + "\"\n" + new WadoRequest(string3).toString());
            System.out.println("B4: \"" + string4 + "\"\n" + new WadoRequest(string4).toString());
        }
        catch (Exception exception) {
            System.err.println("B3: threw exception");
            exception.printStackTrace(System.err);
        }
    }
}

