/*
 * Decompiled with CFR 0.152.
 */
package org.globus.replica.rls;

import java.util.Date;

public class RLSAttribute {
    public static final int DATE = 0;
    public static final int DOUBLE = 1;
    public static final int INT = 2;
    public static final int STR = 3;
    public static final int LRC_LFN = 0;
    public static final int LRC_PFN = 1;
    public static final int RLI_LFN = 2;
    public static final int RLI_LRC = 3;
    public static final int OPALL = 0;
    public static final int OPEQ = 1;
    public static final int OPNE = 2;
    public static final int OPGT = 3;
    public static final int OPGE = 4;
    public static final int OPLT = 5;
    public static final int OPLE = 6;
    public static final int OPBTW = 7;
    public static final int OPLIKE = 8;
    public String name;
    private int valtype;
    private int objtype;
    private Date dateval;
    private double doubleval;
    private int intval;
    private String strval;

    public RLSAttribute(String aname, int lobjtype, int lvaltype) {
        this.name = aname;
        this.objtype = lobjtype;
        this.valtype = lvaltype;
    }

    public RLSAttribute(String aname, int lobjtype, Date val) {
        this.name = aname;
        this.objtype = lobjtype;
        this.valtype = 0;
        this.dateval = val;
    }

    public RLSAttribute(String aname, int lobjtype, int lvaltype, int val) {
        this.name = aname;
        this.objtype = lobjtype;
        this.valtype = lvaltype;
        if (this.valtype == 0) {
            this.dateval = new Date((long)val * 1000L);
        } else {
            this.intval = val;
        }
    }

    public RLSAttribute(String aname, int lobjtype, double val) {
        this.name = aname;
        this.objtype = lobjtype;
        this.valtype = 1;
        this.doubleval = val;
    }

    public RLSAttribute(String aname, int lobjtype, String val) {
        this.name = aname;
        this.objtype = lobjtype;
        this.valtype = 3;
        this.strval = val;
    }

    public int GetObjType() {
        return this.objtype;
    }

    public int GetValType() {
        return this.valtype;
    }

    public String GetValTypeName() {
        switch (this.valtype) {
            case 0: {
                return "date";
            }
            case 1: {
                return "double";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "string";
            }
        }
        return null;
    }

    public Date GetDateVal() {
        return this.dateval;
    }

    public int GetDateValSeconds() {
        return (int)(this.dateval.getTime() / 1000L);
    }

    public double GetDoubleVal() {
        return this.doubleval;
    }

    public int GetIntVal() {
        return this.intval;
    }

    public String GetStrVal() {
        return this.strval;
    }

    public String toString() {
        switch (this.valtype) {
            case 0: {
                return this.dateval.toString();
            }
            case 2: {
                return Integer.toString(this.intval);
            }
            case 1: {
                return Double.toString(this.doubleval);
            }
            case 3: {
                return this.strval;
            }
        }
        return null;
    }
}

