/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseDataSet;
import org.dbunit.database.DatabaseTableMetaData;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.IResultSetTable;
import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResultSetTable
extends AbstractTable
implements IResultSetTable {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$database$AbstractResultSetTable == null ? (class$org$dbunit$database$AbstractResultSetTable = AbstractResultSetTable.class$("org.dbunit.database.AbstractResultSetTable")) : class$org$dbunit$database$AbstractResultSetTable));
    protected ITableMetaData _metaData;
    private Statement _statement;
    protected ResultSet _resultSet;
    static /* synthetic */ Class class$org$dbunit$database$AbstractResultSetTable;

    public AbstractResultSetTable(ITableMetaData metaData, ResultSet resultSet) throws SQLException, DataSetException {
        this._metaData = metaData;
        this._resultSet = resultSet;
    }

    public AbstractResultSetTable(String tableName, String selectStatement, IDatabaseConnection connection) throws DataSetException, SQLException {
        Connection jdbcConnection = connection.getConnection();
        this._statement = jdbcConnection.createStatement();
        DatabaseConfig config = connection.getConfig();
        IDataTypeFactory dataTypeFactory = (IDataTypeFactory)config.getProperty("http://www.dbunit.org/properties/datatypeFactory");
        try {
            this._resultSet = this._statement.executeQuery(selectStatement);
            this._metaData = DatabaseTableMetaData.createMetaData(tableName, this._resultSet, dataTypeFactory);
        }
        catch (SQLException e) {
            this._statement.close();
            this._statement = null;
            throw e;
        }
    }

    public AbstractResultSetTable(ITableMetaData metaData, IDatabaseConnection connection) throws DataSetException, SQLException {
        Connection jdbcConnection = connection.getConnection();
        String escapePattern = (String)connection.getConfig().getProperty("http://www.dbunit.org/properties/escapePattern");
        this._statement = jdbcConnection.createStatement();
        try {
            String schema = connection.getSchema();
            String selectStatement = AbstractResultSetTable.getSelectStatement(schema, metaData, escapePattern);
            this._resultSet = this._statement.executeQuery(selectStatement);
            this._metaData = metaData;
        }
        catch (SQLException e) {
            this._statement.close();
            this._statement = null;
            throw e;
        }
    }

    static String getSelectStatement(String schema, ITableMetaData metaData, String escapePattern) throws DataSetException {
        logger.debug("getSelectStatement(schema=" + schema + ", metaData=" + metaData + ", escapePattern=" + escapePattern + ") - start");
        return DatabaseDataSet.getSelectStatement(schema, metaData, escapePattern);
    }

    public ITableMetaData getTableMetaData() {
        logger.debug("getTableMetaData() - start");
        return this._metaData;
    }

    public void close() throws DataSetException {
        logger.debug("close() - start");
        try {
            if (this._resultSet != null) {
                this._resultSet.close();
                this._resultSet = null;
            }
            if (this._statement != null) {
                this._statement.close();
                this._statement = null;
            }
        }
        catch (SQLException e) {
            throw new DataSetException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

