/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dbunit.database.CachedResultSetTableFactory;
import org.dbunit.database.statement.PreparedStatementFactory;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseConfig {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$database$DatabaseConfig == null ? (class$org$dbunit$database$DatabaseConfig = DatabaseConfig.class$("org.dbunit.database.DatabaseConfig")) : class$org$dbunit$database$DatabaseConfig));
    public static final String PROPERTY_STATEMENT_FACTORY = "http://www.dbunit.org/properties/statementFactory";
    public static final String PROPERTY_RESULTSET_TABLE_FACTORY = "http://www.dbunit.org/properties/resultSetTableFactory";
    public static final String PROPERTY_DATATYPE_FACTORY = "http://www.dbunit.org/properties/datatypeFactory";
    public static final String PROPERTY_ESCAPE_PATTERN = "http://www.dbunit.org/properties/escapePattern";
    public static final String PROPERTY_TABLE_TYPE = "http://www.dbunit.org/properties/tableType";
    public static final String PROPERTY_PRIMARY_KEY_FILTER = "http://www.dbunit.org/properties/primaryKeyFilter";
    public static final String FEATURE_QUALIFIED_TABLE_NAMES = "http://www.dbunit.org/features/qualifiedTableNames";
    public static final String FEATURE_BATCHED_STATEMENTS = "http://www.dbunit.org/features/batchedStatements";
    public static final String FEATURE_DATATYPE_WARNING = "http://www.dbunit.org/features/datatypeWarning";
    public static final String FEATURE_SKIP_ORACLE_RECYCLEBIN_TABLES = "http://www.dbunit.org/features/skipOracleRecycleBinTables";
    private static final DefaultDataTypeFactory DEFAULT_DATA_TYPE_FACTORY = new DefaultDataTypeFactory();
    private static final PreparedStatementFactory PREPARED_STATEMENT_FACTORY = new PreparedStatementFactory();
    private static final CachedResultSetTableFactory RESULT_SET_TABLE_FACTORY = new CachedResultSetTableFactory();
    private static final String DEFAULT_ESCAPE_PATTERN = null;
    private static final String[] DEFAULT_TABLE_TYPE = new String[]{"TABLE"};
    private Set _featuresSet = new HashSet();
    private Map _propertyMap = new HashMap();
    static /* synthetic */ Class class$org$dbunit$database$DatabaseConfig;

    public DatabaseConfig() {
        this.setFeature(FEATURE_BATCHED_STATEMENTS, false);
        this.setFeature(FEATURE_QUALIFIED_TABLE_NAMES, false);
        this.setFeature(FEATURE_DATATYPE_WARNING, true);
        this.setProperty(PROPERTY_STATEMENT_FACTORY, PREPARED_STATEMENT_FACTORY);
        this.setProperty(PROPERTY_RESULTSET_TABLE_FACTORY, RESULT_SET_TABLE_FACTORY);
        this.setProperty(PROPERTY_DATATYPE_FACTORY, DEFAULT_DATA_TYPE_FACTORY);
        this.setProperty(PROPERTY_ESCAPE_PATTERN, DEFAULT_ESCAPE_PATTERN);
        this.setProperty(PROPERTY_TABLE_TYPE, DEFAULT_TABLE_TYPE);
    }

    public void setFeature(String name, boolean value) {
        logger.debug("setFeature(name=" + name + ", value=" + value + ") - start");
        if (value) {
            this._featuresSet.add(name);
        } else {
            this._featuresSet.remove(name);
        }
    }

    public boolean getFeature(String name) {
        logger.debug("getFeature(name=" + name + ") - start");
        return this._featuresSet.contains(name);
    }

    public void setProperty(String name, Object value) {
        logger.debug("setProperty(name=" + name + ", value=" + value + ") - start");
        this._propertyMap.put(name, value);
    }

    public Object getProperty(String name) {
        logger.debug("getProperty(name=" + name + ") - start");
        return this._propertyMap.get(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

