/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.dbunit.database.AbstractDatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDataSourceConnection
extends AbstractDatabaseConnection
implements IDatabaseConnection {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$database$DatabaseDataSourceConnection == null ? (class$org$dbunit$database$DatabaseDataSourceConnection = DatabaseDataSourceConnection.class$("org.dbunit.database.DatabaseDataSourceConnection")) : class$org$dbunit$database$DatabaseDataSourceConnection));
    private final String _schema;
    private final DataSource _dataSource;
    private final String _user;
    private final String _password;
    private Connection _connection;
    static /* synthetic */ Class class$org$dbunit$database$DatabaseDataSourceConnection;

    public DatabaseDataSourceConnection(InitialContext context, String jndiName, String schema) throws NamingException, SQLException {
        this((DataSource)context.lookup(jndiName), schema, null, null);
    }

    public DatabaseDataSourceConnection(InitialContext context, String jndiName, String schema, String user, String password) throws NamingException, SQLException {
        this((DataSource)context.lookup(jndiName), schema, user, password);
    }

    public DatabaseDataSourceConnection(InitialContext context, String jndiName) throws NamingException, SQLException {
        this(context, jndiName, null);
    }

    public DatabaseDataSourceConnection(InitialContext context, String jndiName, String user, String password) throws NamingException, SQLException {
        this(context, jndiName, null, user, password);
    }

    public DatabaseDataSourceConnection(DataSource dataSource) throws SQLException {
        this(dataSource, null, null, null);
    }

    public DatabaseDataSourceConnection(DataSource dataSource, String user, String password) throws SQLException {
        this(dataSource, null, user, password);
    }

    public DatabaseDataSourceConnection(DataSource dataSource, String schema) throws SQLException {
        this(dataSource, schema, null, null);
    }

    public DatabaseDataSourceConnection(DataSource dataSource, String schema, String user, String password) throws SQLException {
        this._dataSource = dataSource;
        this._schema = schema;
        this._user = user;
        this._password = password;
    }

    public Connection getConnection() throws SQLException {
        logger.debug("getConnection() - start");
        if (this._connection == null) {
            this._connection = this._user != null ? this._dataSource.getConnection(this._user, this._password) : this._dataSource.getConnection();
        }
        return this._connection;
    }

    public String getSchema() {
        logger.debug("getSchema() - start");
        return this._schema;
    }

    public void close() throws SQLException {
        logger.debug("close() - start");
        if (this._connection != null) {
            this._connection.close();
            this._connection = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

