/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database.statement;

import java.sql.SQLException;
import org.dbunit.database.statement.IPreparedBatchStatement;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomaticPreparedBatchStatement
implements IPreparedBatchStatement {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$database$statement$AutomaticPreparedBatchStatement == null ? (class$org$dbunit$database$statement$AutomaticPreparedBatchStatement = AutomaticPreparedBatchStatement.class$("org.dbunit.database.statement.AutomaticPreparedBatchStatement")) : class$org$dbunit$database$statement$AutomaticPreparedBatchStatement));
    private final IPreparedBatchStatement _statement;
    private int _batchCount = 0;
    private int _threshold;
    private int _result = 0;
    static /* synthetic */ Class class$org$dbunit$database$statement$AutomaticPreparedBatchStatement;

    public AutomaticPreparedBatchStatement(IPreparedBatchStatement statement, int threshold) {
        this._statement = statement;
        this._threshold = threshold;
    }

    public void addValue(Object value, DataType dataType) throws TypeCastException, SQLException {
        logger.debug("addValue(value=" + value + ", dataType=" + dataType + ") - start");
        this._statement.addValue(value, dataType);
    }

    public void addBatch() throws SQLException {
        logger.debug("addBatch() - start");
        this._statement.addBatch();
        ++this._batchCount;
        if (this._batchCount % this._threshold == 0) {
            this._result += this._statement.executeBatch();
        }
    }

    public int executeBatch() throws SQLException {
        logger.debug("executeBatch() - start");
        this._result += this._statement.executeBatch();
        return this._result;
    }

    public void clearBatch() throws SQLException {
        logger.debug("clearBatch() - start");
        this._statement.clearBatch();
        this._batchCount = 0;
    }

    public void close() throws SQLException {
        logger.debug("close() - start");
        this._statement.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

