/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTable
implements ITable {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$AbstractTable == null ? (class$org$dbunit$dataset$AbstractTable = AbstractTable.class$("org.dbunit.dataset.AbstractTable")) : class$org$dbunit$dataset$AbstractTable));
    static /* synthetic */ Class class$org$dbunit$dataset$AbstractTable;

    protected void assertValidRowIndex(int row) throws DataSetException {
        logger.debug("assertValidRowIndex(row=" + row + ") - start");
        this.assertValidRowIndex(row, this.getRowCount());
    }

    protected void assertValidRowIndex(int row, int rowCount) throws DataSetException {
        logger.debug("assertValidRowIndex(row=" + row + ", rowCount=" + rowCount + ") - start");
        if (row < 0) {
            throw new RowOutOfBoundsException(row + " < 0");
        }
        if (row >= rowCount) {
            throw new RowOutOfBoundsException(row + " >= " + rowCount);
        }
    }

    protected void assertValidColumn(String columnName) throws DataSetException {
        logger.debug("assertValidColumn(columnName=" + columnName + ") - start");
        ITableMetaData metaData = this.getTableMetaData();
        if (DataSetUtils.getColumn(columnName, metaData.getColumns()) == null) {
            throw new NoSuchColumnException(metaData.getTableName() + "." + columnName);
        }
    }

    protected int getColumnIndex(String columnName) throws DataSetException {
        logger.debug("getColumnIndex(columnName=" + columnName + ") - start");
        ITableMetaData metaData = this.getTableMetaData();
        Column[] columns = metaData.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (!column.getColumnName().equalsIgnoreCase(columnName)) continue;
            return i;
        }
        throw new NoSuchColumnException(metaData.getTableName() + "." + columnName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

