/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchTableException;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.filter.SequenceTableFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteredDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$FilteredDataSet == null ? (class$org$dbunit$dataset$FilteredDataSet = FilteredDataSet.class$("org.dbunit.dataset.FilteredDataSet")) : class$org$dbunit$dataset$FilteredDataSet));
    private final IDataSet _dataSet;
    private final ITableFilter _filter;
    static /* synthetic */ Class class$org$dbunit$dataset$FilteredDataSet;

    public FilteredDataSet(String[] tableNames, IDataSet dataSet) {
        this._filter = new SequenceTableFilter(tableNames);
        this._dataSet = dataSet;
    }

    public FilteredDataSet(ITableFilter filter, IDataSet dataSet) {
        this._dataSet = dataSet;
        this._filter = filter;
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        logger.debug("createIterator(reversed=" + reversed + ") - start");
        return this._filter.iterator(this._dataSet, reversed);
    }

    public String[] getTableNames() throws DataSetException {
        logger.debug("getTableNames() - start");
        return this._filter.getTableNames(this._dataSet);
    }

    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        logger.debug("getTableMetaData(tableName=" + tableName + ") - start");
        if (!this._filter.accept(tableName)) {
            throw new NoSuchTableException(tableName);
        }
        return this._dataSet.getTableMetaData(tableName);
    }

    public ITable getTable(String tableName) throws DataSetException {
        logger.debug("getTable(tableName=" + tableName + ") - start");
        if (!this._filter.accept(tableName)) {
            throw new NoSuchTableException(tableName);
        }
        return this._dataSet.getTable(tableName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

