/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import org.dbunit.dataset.AbstractTableMetaData;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.filter.IColumnFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteredTableMetaData
extends AbstractTableMetaData {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$FilteredTableMetaData == null ? (class$org$dbunit$dataset$FilteredTableMetaData = FilteredTableMetaData.class$("org.dbunit.dataset.FilteredTableMetaData")) : class$org$dbunit$dataset$FilteredTableMetaData));
    private final String _tableName;
    private final Column[] _columns;
    private final Column[] _primaryKeys;
    static /* synthetic */ Class class$org$dbunit$dataset$FilteredTableMetaData;

    public FilteredTableMetaData(ITableMetaData metaData, IColumnFilter columnFilter) throws DataSetException {
        this._tableName = metaData.getTableName();
        this._columns = FilteredTableMetaData.getFilteredColumns(this._tableName, metaData.getColumns(), columnFilter);
        this._primaryKeys = FilteredTableMetaData.getFilteredColumns(this._tableName, metaData.getPrimaryKeys(), columnFilter);
    }

    public static Column[] getFilteredColumns(String tableName, Column[] columns, IColumnFilter columnFilter) {
        logger.debug("getFilteredColumns(tableName=" + tableName + ", columns=" + columns + ", columnFilter=" + columnFilter + ") - start");
        if (columns == null) {
            return new Column[0];
        }
        ArrayList<Column> columnList = new ArrayList<Column>();
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (!columnFilter.accept(tableName, column)) continue;
            columnList.add(column);
        }
        return columnList.toArray(new Column[0]);
    }

    public String getTableName() {
        logger.debug("getTableName() - start");
        return this._tableName;
    }

    public Column[] getColumns() throws DataSetException {
        logger.debug("getColumns() - start");
        return this._columns;
    }

    public Column[] getPrimaryKeys() throws DataSetException {
        logger.debug("getPrimaryKeys() - start");
        return this._primaryKeys;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

