/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplacementTable
implements ITable {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$ReplacementTable == null ? (class$org$dbunit$dataset$ReplacementTable = ReplacementTable.class$("org.dbunit.dataset.ReplacementTable")) : class$org$dbunit$dataset$ReplacementTable));
    private final ITable _table;
    private final Map _objectMap;
    private final Map _substringMap;
    private String _startDelim;
    private String _endDelim;
    static /* synthetic */ Class class$org$dbunit$dataset$ReplacementTable;

    public ReplacementTable(ITable table) {
        this(table, new HashMap(), new HashMap(), null, null);
    }

    public ReplacementTable(ITable table, Map objectMap, Map substringMap, String startDelimiter, String endDelimiter) {
        this._table = table;
        this._objectMap = objectMap;
        this._substringMap = substringMap;
        this._startDelim = startDelimiter;
        this._endDelim = endDelimiter;
    }

    public void addReplacementObject(Object originalObject, Object replacementObject) {
        logger.debug("addReplacementObject(originalObject=" + originalObject + ", replacementObject=" + replacementObject + ") - start");
        this._objectMap.put(originalObject, replacementObject);
    }

    public void addReplacementSubstring(String originalSubstring, String replacementSubstring) {
        logger.debug("addReplacementSubstring(originalSubstring=" + originalSubstring + ", replacementSubstring=" + replacementSubstring + ") - start");
        if (originalSubstring == null || replacementSubstring == null) {
            throw new NullPointerException();
        }
        this._substringMap.put(originalSubstring, replacementSubstring);
    }

    public void setSubstringDelimiters(String startDelimiter, String endDelimiter) {
        logger.debug("setSubstringDelimiters(startDelimiter=" + startDelimiter + ", endDelimiter=" + endDelimiter + ") - start");
        if (startDelimiter == null || endDelimiter == null) {
            throw new NullPointerException();
        }
        this._startDelim = startDelimiter;
        this._endDelim = endDelimiter;
    }

    private void replaceAll(StringBuffer text, String source, String target) {
        int index = 0;
        while ((index = text.toString().indexOf(source, index)) != -1) {
            text.replace(index, index + source.length(), target);
            index += target.length();
        }
    }

    private String replaceStrings(String value, String lDelim, String rDelim) {
        StringBuffer buffer = new StringBuffer(value);
        Iterator it = this._substringMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String original = (String)entry.getKey();
            String replacement = (String)entry.getValue();
            this.replaceAll(buffer, lDelim + original + rDelim, replacement);
        }
        return buffer == null ? value : buffer.toString();
    }

    private String replaceSubstrings(String value) {
        return this.replaceStrings(value, "", "");
    }

    private String replaceDelimitedSubstrings(String value) {
        return this.replaceStrings(value, this._startDelim, this._endDelim);
    }

    public ITableMetaData getTableMetaData() {
        logger.debug("getTableMetaData() - start");
        return this._table.getTableMetaData();
    }

    public int getRowCount() {
        logger.debug("getRowCount() - start");
        return this._table.getRowCount();
    }

    public Object getValue(int row, String column) throws DataSetException {
        logger.debug("getValue(row=" + row + ", column=" + column + ") - start");
        Object value = this._table.getValue(row, column);
        if (this._objectMap.containsKey(value)) {
            return this._objectMap.get(value);
        }
        if (this._substringMap.size() == 0 || !(value instanceof String)) {
            return value;
        }
        if (this._startDelim != null && this._endDelim != null) {
            return this.replaceDelimitedSubstrings((String)value);
        }
        return this.replaceSubstrings((String)value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

