/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.filter;

import java.util.ArrayList;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.filter.ITableFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableFilter
implements ITableFilter {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$filter$AbstractTableFilter == null ? (class$org$dbunit$dataset$filter$AbstractTableFilter = AbstractTableFilter.class$("org.dbunit.dataset.filter.AbstractTableFilter")) : class$org$dbunit$dataset$filter$AbstractTableFilter));
    static /* synthetic */ Class class$org$dbunit$dataset$filter$AbstractTableFilter;
    static /* synthetic */ Class class$org$dbunit$dataset$filter$AbstractTableFilter$FilterIterator;

    public abstract boolean isValidName(String var1) throws DataSetException;

    public boolean accept(String tableName) throws DataSetException {
        logger.debug("accept(tableName=" + tableName + ") - start");
        return this.isValidName(tableName);
    }

    public String[] getTableNames(IDataSet dataSet) throws DataSetException {
        logger.debug("getTableNames(dataSet=" + dataSet + ") - start");
        String[] tableNames = dataSet.getTableNames();
        ArrayList<String> nameList = new ArrayList<String>();
        for (int i = 0; i < tableNames.length; ++i) {
            String tableName = tableNames[i];
            if (!this.accept(tableName)) continue;
            nameList.add(tableName);
        }
        return nameList.toArray(new String[0]);
    }

    public ITableIterator iterator(IDataSet dataSet, boolean reversed) throws DataSetException {
        logger.debug("iterator(dataSet=" + dataSet + ", reversed=" + reversed + ") - start");
        return new FilterIterator(reversed ? dataSet.reverseIterator() : dataSet.iterator());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FilterIterator
    implements ITableIterator {
        private final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$filter$AbstractTableFilter$FilterIterator == null ? (class$org$dbunit$dataset$filter$AbstractTableFilter$FilterIterator = AbstractTableFilter.class$("org.dbunit.dataset.filter.AbstractTableFilter$FilterIterator")) : class$org$dbunit$dataset$filter$AbstractTableFilter$FilterIterator));
        private final ITableIterator _iterator;

        public FilterIterator(ITableIterator iterator) {
            this._iterator = iterator;
        }

        public boolean next() throws DataSetException {
            this.logger.debug("next() - start");
            while (this._iterator.next()) {
                if (!AbstractTableFilter.this.accept(this._iterator.getTableMetaData().getTableName())) continue;
                return true;
            }
            return false;
        }

        public ITableMetaData getTableMetaData() throws DataSetException {
            this.logger.debug("getTableMetaData() - start");
            return this._iterator.getTableMetaData();
        }

        public ITable getTable() throws DataSetException {
            this.logger.debug("getTable() - start");
            return this._iterator.getTable();
        }
    }
}

