/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.concurrent;

import org.dbunit.util.concurrent.BoundedChannel;
import org.dbunit.util.concurrent.DefaultChannelCapacity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedBuffer
implements BoundedChannel {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$util$concurrent$BoundedBuffer == null ? (class$org$dbunit$util$concurrent$BoundedBuffer = BoundedBuffer.class$("org.dbunit.util.concurrent.BoundedBuffer")) : class$org$dbunit$util$concurrent$BoundedBuffer));
    protected final Object[] array_;
    protected int takePtr_ = 0;
    protected int putPtr_ = 0;
    protected int usedSlots_ = 0;
    protected int emptySlots_;
    protected final Object putMonitor_ = new Object();
    static /* synthetic */ Class class$org$dbunit$util$concurrent$BoundedBuffer;

    public BoundedBuffer(int capacity) throws IllegalArgumentException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.array_ = new Object[capacity];
        this.emptySlots_ = capacity;
    }

    public BoundedBuffer() {
        this(DefaultChannelCapacity.get());
    }

    public synchronized int size() {
        logger.debug("size() - start");
        return this.usedSlots_;
    }

    public int capacity() {
        logger.debug("capacity() - start");
        return this.array_.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incEmptySlots() {
        logger.debug("incEmptySlots() - start");
        Object object = this.putMonitor_;
        synchronized (object) {
            ++this.emptySlots_;
            this.putMonitor_.notify();
        }
    }

    protected synchronized void incUsedSlots() {
        logger.debug("incUsedSlots() - start");
        ++this.usedSlots_;
        this.notify();
    }

    protected final void insert(Object x) {
        logger.debug("insert(x=" + x + ") - start");
        --this.emptySlots_;
        this.array_[this.putPtr_] = x;
        if (++this.putPtr_ >= this.array_.length) {
            this.putPtr_ = 0;
        }
    }

    protected final Object extract() {
        logger.debug("extract() - start");
        --this.usedSlots_;
        Object old = this.array_[this.takePtr_];
        this.array_[this.takePtr_] = null;
        if (++this.takePtr_ >= this.array_.length) {
            this.takePtr_ = 0;
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        logger.debug("peek() - start");
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            if (this.usedSlots_ > 0) {
                return this.array_[this.takePtr_];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object x) throws InterruptedException {
        logger.debug("put(x=" + x + ") - start");
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.putMonitor_;
        synchronized (object) {
            while (this.emptySlots_ <= 0) {
                try {
                    this.putMonitor_.wait();
                }
                catch (InterruptedException ex) {
                    this.putMonitor_.notify();
                    throw ex;
                }
            }
            this.insert(x);
        }
        this.incUsedSlots();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object x, long msecs) throws InterruptedException {
        logger.debug("offer(x=" + x + ", msecs=" + msecs + ") - start");
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.putMonitor_;
        synchronized (object) {
            long start = msecs <= 0L ? 0L : System.currentTimeMillis();
            long waitTime = msecs;
            while (this.emptySlots_ <= 0) {
                if (waitTime <= 0L) {
                    return false;
                }
                try {
                    this.putMonitor_.wait(waitTime);
                }
                catch (InterruptedException ex) {
                    this.putMonitor_.notify();
                    throw ex;
                }
                waitTime = msecs - (System.currentTimeMillis() - start);
            }
            this.insert(x);
        }
        this.incUsedSlots();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() throws InterruptedException {
        logger.debug("take() - start");
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object old = null;
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            while (this.usedSlots_ <= 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
            old = this.extract();
        }
        this.incEmptySlots();
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll(long msecs) throws InterruptedException {
        logger.debug("poll(msecs=" + msecs + ") - start");
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object old = null;
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            long start = msecs <= 0L ? 0L : System.currentTimeMillis();
            long waitTime = msecs;
            while (this.usedSlots_ <= 0) {
                if (waitTime <= 0L) {
                    return null;
                }
                try {
                    this.wait(waitTime);
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
                waitTime = msecs - (System.currentTimeMillis() - start);
            }
            old = this.extract();
        }
        this.incEmptySlots();
        return old;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

