/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.concurrent;

import org.dbunit.util.concurrent.SynchronizedVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizedInt
extends SynchronizedVariable
implements Comparable,
Cloneable {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$util$concurrent$SynchronizedInt == null ? (class$org$dbunit$util$concurrent$SynchronizedInt = SynchronizedInt.class$("org.dbunit.util.concurrent.SynchronizedInt")) : class$org$dbunit$util$concurrent$SynchronizedInt));
    protected int value_;
    static /* synthetic */ Class class$org$dbunit$util$concurrent$SynchronizedInt;

    public SynchronizedInt(int initialValue) {
        this.value_ = initialValue;
    }

    public SynchronizedInt(int initialValue, Object lock) {
        super(lock);
        this.value_ = initialValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int get() {
        logger.debug("get() - start");
        Object object = this.lock_;
        synchronized (object) {
            return this.value_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set(int newValue) {
        logger.debug("set(newValue=" + newValue + ") - start");
        Object object = this.lock_;
        synchronized (object) {
            int old = this.value_;
            this.value_ = newValue;
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit(int assumedValue, int newValue) {
        logger.debug("commit(assumedValue=" + assumedValue + ", newValue=" + newValue + ") - start");
        Object object = this.lock_;
        synchronized (object) {
            boolean success;
            boolean bl = success = assumedValue == this.value_;
            if (success) {
                this.value_ = newValue;
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int swap(SynchronizedInt other) {
        logger.debug("swap(other=" + other + ") - start");
        if (other == this) {
            return this.get();
        }
        SynchronizedInt fst = this;
        SynchronizedInt snd = other;
        if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
            fst = other;
            snd = this;
        }
        Object object = fst.lock_;
        synchronized (object) {
            Object object2 = snd.lock_;
            synchronized (object2) {
                fst.set(snd.set(fst.get()));
                return this.get();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int increment() {
        logger.debug("increment() - start");
        Object object = this.lock_;
        synchronized (object) {
            return ++this.value_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decrement() {
        logger.debug("decrement() - start");
        Object object = this.lock_;
        synchronized (object) {
            return --this.value_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(int amount) {
        logger.debug("add(amount=" + amount + ") - start");
        Object object = this.lock_;
        synchronized (object) {
            return this.value_ += amount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int subtract(int amount) {
        logger.debug("subtract(amount=" + amount + ") - start");
        Object object = this.lock_;
        synchronized (object) {
            return this.value_ -= amount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int multiply(int factor) {
        logger.debug("multiply(factor=" + factor + ") - start");
        Object object = this.lock_;
        synchronized (object) {
            return this.value_ *= factor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int divide(int factor) {
        logger.debug("divide(factor=" + factor + ") - start");
        Object object = this.lock_;
        synchronized (object) {
            return this.value_ /= factor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int negate() {
        logger.debug("negate() - start");
        Object object = this.lock_;
        synchronized (object) {
            this.value_ = -this.value_;
            return this.value_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int complement() {
        logger.debug("complement() - start");
        Object object = this.lock_;
        synchronized (object) {
            this.value_ ^= 0xFFFFFFFF;
            return this.value_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int and(int b) {
        logger.debug("and(b=" + b + ") - start");
        Object object = this.lock_;
        synchronized (object) {
            this.value_ &= b;
            return this.value_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int or(int b) {
        logger.debug("or(b=" + b + ") - start");
        Object object = this.lock_;
        synchronized (object) {
            this.value_ |= b;
            return this.value_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int xor(int b) {
        logger.debug("xor(b=" + b + ") - start");
        Object object = this.lock_;
        synchronized (object) {
            this.value_ ^= b;
            return this.value_;
        }
    }

    public int compareTo(int other) {
        logger.debug("compareTo(other=" + other + ") - start");
        int val = this.get();
        return val < other ? -1 : (val == other ? 0 : 1);
    }

    public int compareTo(SynchronizedInt other) {
        logger.debug("compareTo(other=" + other + ") - start");
        return this.compareTo(other.get());
    }

    public int compareTo(Object other) {
        logger.debug("compareTo(other=" + other + ") - start");
        return this.compareTo((SynchronizedInt)other);
    }

    public boolean equals(Object other) {
        logger.debug("equals(other=" + other + ") - start");
        if (other != null && other instanceof SynchronizedInt) {
            return this.get() == ((SynchronizedInt)other).get();
        }
        return false;
    }

    public int hashCode() {
        logger.debug("hashCode() - start");
        return this.get();
    }

    public String toString() {
        logger.debug("toString() - start");
        return String.valueOf(this.get());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

