/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.File;
import java.io.FilenameFilter;
import java.security.cert.X509CRL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.CoGProperties;
import org.globus.gsi.CertUtil;
import org.globus.util.TimestampEntry;

public class CertificateRevocationLists {
    private static Log logger = LogFactory.getLog((class$org$globus$gsi$CertificateRevocationLists == null ? (class$org$globus$gsi$CertificateRevocationLists = CertificateRevocationLists.class$("org.globus.gsi.CertificateRevocationLists")) : class$org$globus$gsi$CertificateRevocationLists).getName());
    public static final CrlFilter crlFileFilter = new CrlFilter();
    private static String prevCaCertLocations = null;
    private static String defaultCrlLocations = null;
    private static CertificateRevocationLists defaultCrl = null;
    private Map crlFileMap;
    private Map crlIssuerDNMap;
    static /* synthetic */ Class class$org$globus$gsi$CertificateRevocationLists;

    private CertificateRevocationLists() {
    }

    public X509CRL[] getCrls() {
        if (this.crlIssuerDNMap == null) {
            return null;
        }
        Collection crls = this.crlIssuerDNMap.values();
        X509CRL[] retCrls = new X509CRL[crls.size()];
        Iterator iterator = crls.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            retCrls[i] = (X509CRL)iterator.next();
            ++i;
        }
        return retCrls;
    }

    public X509CRL getCrl(String issuerName) {
        if (this.crlIssuerDNMap == null) {
            return null;
        }
        return (X509CRL)this.crlIssuerDNMap.get(issuerName);
    }

    public static FilenameFilter getCrlFilter() {
        return crlFileFilter;
    }

    public void refresh() {
        this.reload(null);
    }

    public synchronized void reload(String locations) {
        if (locations == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(locations, ",");
        File crlFile = null;
        HashMap newCrlFileMap = new HashMap();
        HashMap newCrlIssuerDNMap = new HashMap();
        while (tokens.hasMoreTokens()) {
            crlFile = new File(tokens.nextToken().toString().trim());
            if (!crlFile.canRead()) {
                logger.debug("Cannot read: " + crlFile.getAbsolutePath());
                continue;
            }
            if (crlFile.isDirectory()) {
                String[] crlFiles = crlFile.list(CertificateRevocationLists.getCrlFilter());
                if (crlFiles == null) {
                    logger.debug("Cannot load CRLs from " + crlFile.getAbsolutePath() + " directory.");
                    continue;
                }
                logger.debug("Loading CRLs from " + crlFile.getAbsolutePath() + " directory.");
                for (int i = 0; i < crlFiles.length; ++i) {
                    String crlFilename = crlFile.getPath() + File.separatorChar + crlFiles[i];
                    File crlFilenameFile = new File(crlFilename);
                    if (crlFilenameFile.canRead()) {
                        this.loadCrl(crlFilename, crlFilenameFile.lastModified(), newCrlFileMap, newCrlIssuerDNMap);
                        continue;
                    }
                    logger.debug("Cannot read: " + crlFilenameFile.getAbsolutePath());
                }
                continue;
            }
            this.loadCrl(crlFile.getAbsolutePath(), crlFile.lastModified(), newCrlFileMap, newCrlIssuerDNMap);
        }
        this.crlFileMap = newCrlFileMap;
        this.crlIssuerDNMap = newCrlIssuerDNMap;
    }

    private void loadCrl(String crlPath, long latestLastModified, Map newCrlFileMap, Map newCrlIssuerDNMap) {
        X509CRL crl = null;
        if (this.crlFileMap == null) {
            this.crlFileMap = new HashMap();
        }
        TimestampEntry crlEntry = (TimestampEntry)this.crlFileMap.get(crlPath);
        try {
            if (crlEntry == null) {
                logger.debug("Loading " + crlPath + " CRL.");
                crl = CertUtil.loadCrl(crlPath);
                crlEntry = new TimestampEntry();
                crlEntry.setValue(crl);
                crlEntry.setLastModified(latestLastModified);
                crlEntry.setDescription(crl.getIssuerDN().getName());
            } else if (latestLastModified > crlEntry.getLastModified()) {
                logger.debug("Reloading " + crlPath + " CRL.");
                crl = CertUtil.loadCrl(crlPath);
                crlEntry.setValue(crl);
                crlEntry.setLastModified(latestLastModified);
                crlEntry.setDescription(crl.getIssuerDN().getName());
            } else {
                logger.debug("CRL " + crlPath + " is up-to-date.");
                crl = (X509CRL)crlEntry.getValue();
            }
            newCrlFileMap.put(crlPath, crlEntry);
            newCrlIssuerDNMap.put(crlEntry.getDescription(), crl);
        }
        catch (Exception e) {
            logger.error("CRL " + crlPath + " failed to load.", e);
        }
    }

    public static CertificateRevocationLists getCertificateRevocationLists(String locations) {
        CertificateRevocationLists crl = new CertificateRevocationLists();
        crl.reload(locations);
        return crl;
    }

    public static synchronized CertificateRevocationLists getDefaultCertificateRevocationLists() {
        return CertificateRevocationLists.getDefault();
    }

    public static void setDefaultCertificateRevocationList(CertificateRevocationLists crl) {
        defaultCrl = crl;
    }

    public static synchronized CertificateRevocationLists getDefault() {
        if (defaultCrl == null) {
            defaultCrl = new DefaultCertificateRevocationLists();
        }
        defaultCrl.refresh();
        return defaultCrl;
    }

    public String toString() {
        if (this.crlIssuerDNMap == null) {
            return "crl list is empty";
        }
        return this.crlIssuerDNMap.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DefaultCertificateRevocationLists
    extends CertificateRevocationLists {
        private DefaultCertificateRevocationLists() {
        }

        public void refresh() {
            this.reload(DefaultCertificateRevocationLists.getDefaultCRLLocations());
        }

        private static synchronized String getDefaultCRLLocations() {
            String caCertLocations = CoGProperties.getDefault().getCaCertLocations();
            if (prevCaCertLocations == null || !prevCaCertLocations.equals(caCertLocations)) {
                if (caCertLocations == null) {
                    logger.debug("No CA cert locations specified");
                    prevCaCertLocations = null;
                    defaultCrlLocations = null;
                } else {
                    StringTokenizer tokens = new StringTokenizer(caCertLocations, ",");
                    File crlFile = null;
                    LinkedList<String> crlDirs = new LinkedList<String>();
                    while (tokens.hasMoreTokens()) {
                        String crlFileName = tokens.nextToken().toString().trim();
                        crlFile = new File(crlFileName);
                        if (!crlFile.isDirectory()) {
                            if (!crlFile.isFile()) continue;
                            crlFileName = crlFile.getParent();
                        }
                        if (crlFileName == null || crlDirs.contains(crlFileName)) continue;
                        crlDirs.add(crlFileName);
                    }
                    ListIterator iterator = crlDirs.listIterator(0);
                    String locations = null;
                    while (iterator.hasNext()) {
                        if (locations == null) {
                            locations = (String)iterator.next();
                            continue;
                        }
                        locations = locations + "," + (String)iterator.next();
                    }
                    prevCaCertLocations = caCertLocations;
                    defaultCrlLocations = locations;
                }
            }
            return defaultCrlLocations;
        }
    }

    public static class CrlFilter
    implements FilenameFilter {
        public boolean accept(File dir, String file) {
            int length = file.length();
            return length > 3 && file.charAt(length - 3) == '.' && file.charAt(length - 2) == 'r' && file.charAt(length - 1) >= '0' && file.charAt(length - 1) <= '9';
        }
    }
}

