/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TokenInputStream
extends InputStream {
    private static Log logger = LogFactory.getLog((class$org$globus$gsi$gssapi$TokenInputStream == null ? (class$org$globus$gsi$gssapi$TokenInputStream = TokenInputStream.class$("org.globus.gsi.gssapi.TokenInputStream")) : class$org$globus$gsi$gssapi$TokenInputStream).getName());
    private LinkedList tokens = new LinkedList();
    private byte[] buff;
    private int index = 0;
    private boolean closed = false;
    static /* synthetic */ Class class$org$globus$gsi$gssapi$TokenInputStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putToken(byte[] buf, int off, int len) {
        if (buf == null || len <= 0) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("put token: " + len);
        }
        byte[] localBuf = buf;
        if (off != 0) {
            localBuf = new byte[len];
            System.arraycopy(buf, off, localBuf, 0, len);
        }
        TokenInputStream tokenInputStream = this;
        synchronized (tokenInputStream) {
            if (this.buff == null || this.buff != null && this.buff.length == this.index) {
                this.buff = localBuf;
                this.index = 0;
            } else {
                this.tokens.add(localBuf);
            }
            this.notify();
        }
    }

    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    public int read(byte[] data, int off, int len) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("read byte array: " + len);
        }
        if (!this.checkData()) {
            return -1;
        }
        int size = Math.min(len, this.buff.length - this.index);
        System.arraycopy(this.buff, this.index, data, off, size);
        this.index += size;
        return size;
    }

    public int read() throws IOException {
        logger.debug("read byte");
        if (!this.checkData()) {
            return -1;
        }
        return this.buff[this.index++] & 0xFF;
    }

    protected synchronized boolean checkData() {
        try {
            while (!this.hasData()) {
                this.wait();
                if (!this.closed) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected boolean hasData() {
        if (this.buff == null) {
            return false;
        }
        if (this.buff.length == this.index) {
            if (this.tokens.isEmpty()) {
                return false;
            }
            this.buff = (byte[])this.tokens.removeFirst();
            this.index = 0;
            return true;
        }
        return true;
    }

    public int available() throws IOException {
        if (!this.hasData()) {
            return 0;
        }
        return this.buff.length - this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        logger.debug("close() called");
        TokenInputStream tokenInputStream = this;
        synchronized (tokenInputStream) {
            this.closed = true;
            this.notify();
        }
    }

    public String toString() {
        return this.tokens.toString() + " " + this.index + " " + this.buff.length;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

