/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import java.util.Arrays;
import java.util.Comparator;
import junit.framework.Assert;
import org.dbunit.DatabaseUnitException;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.UnknownDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Assertion {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$Assertion == null ? (class$org$dbunit$Assertion = Assertion.class$("org.dbunit.Assertion")) : class$org$dbunit$Assertion));
    private static final ColumnComparator COLUMN_COMPARATOR = new ColumnComparator();
    static /* synthetic */ Class class$org$dbunit$Assertion;
    static /* synthetic */ Class class$org$dbunit$Assertion$ColumnComparator;

    private Assertion() {
    }

    public static void assertEquals(IDataSet expectedDataSet, IDataSet actualDataSet) throws DatabaseUnitException {
        int i;
        logger.debug("assertEquals(expectedDataSet={}, actualDataSet={}) - start", (Object)expectedDataSet, (Object)actualDataSet);
        if (expectedDataSet == actualDataSet) {
            return;
        }
        String[] expectedNames = Assertion.getSortedUpperTableNames(expectedDataSet);
        String[] actualNames = Assertion.getSortedUpperTableNames(actualDataSet);
        Assert.assertEquals((String)"table count", (int)expectedNames.length, (int)actualNames.length);
        for (i = 0; i < expectedNames.length; ++i) {
            if (actualNames[i].equals(expectedNames[i])) continue;
            Assert.fail((String)("expected tables " + Arrays.asList(expectedNames) + " but was " + Arrays.asList(actualNames)));
        }
        for (i = 0; i < expectedNames.length; ++i) {
            String name = expectedNames[i];
            Assertion.assertEquals(expectedDataSet.getTable(name), actualDataSet.getTable(name));
        }
    }

    public static void assertEquals(ITable expectedTable, ITable actualTable) throws DatabaseUnitException {
        int i;
        logger.debug("assertEquals(expectedTable={}, actualTable={}) - start", (Object)expectedTable, (Object)actualTable);
        if (expectedTable == actualTable) {
            return;
        }
        ITableMetaData expectedMetaData = expectedTable.getTableMetaData();
        ITableMetaData actualMetaData = actualTable.getTableMetaData();
        String expectedTableName = expectedMetaData.getTableName();
        Column[] expectedColumns = Assertion.getSortedColumns(expectedMetaData);
        Column[] actualColumns = Assertion.getSortedColumns(actualMetaData);
        Assert.assertEquals((String)("column count (table=" + expectedTableName + ")"), (int)expectedColumns.length, (int)actualColumns.length);
        for (i = 0; i < expectedColumns.length; ++i) {
            String actualName;
            String expectedName = expectedColumns[i].getColumnName();
            if (expectedName.equalsIgnoreCase(actualName = actualColumns[i].getColumnName())) continue;
            Assert.fail((String)("expected columns " + Assertion.getColumnNamesAsString(expectedColumns) + " but was " + Assertion.getColumnNamesAsString(actualColumns) + " (table=" + expectedTableName + ")"));
        }
        Assert.assertEquals((String)("row count (table=" + expectedTableName + ")"), (int)expectedTable.getRowCount(), (int)actualTable.getRowCount());
        for (i = 0; i < expectedTable.getRowCount(); ++i) {
            for (int j = 0; j < expectedColumns.length; ++j) {
                Column expectedColumn = expectedColumns[j];
                Column actualColumn = actualColumns[j];
                String columnName = expectedColumn.getColumnName();
                Object expectedValue = expectedTable.getValue(i, columnName);
                Object actualValue = actualTable.getValue(i, columnName);
                DataType dataType = Assertion.getComparisonDataType(expectedTableName, expectedColumn, actualColumn);
                if (dataType.compare(expectedValue, actualValue) == 0) continue;
                Assert.fail((String)("value (table=" + expectedTableName + ", " + "row=" + i + ", col=" + columnName + "): expected:<" + expectedValue + "> but was:<" + actualValue + ">"));
            }
        }
    }

    static DataType getComparisonDataType(String tableName, Column expectedColumn, Column actualColumn) {
        logger.debug("getComparisonDataType(tableName={}, expectedColumn={}, actualColumn={}) - start", new Object[]{tableName, expectedColumn, actualColumn});
        DataType expectedDataType = expectedColumn.getDataType();
        DataType actualDataType = actualColumn.getDataType();
        if (!expectedDataType.getClass().isInstance(actualDataType)) {
            if (expectedDataType instanceof UnknownDataType) {
                return actualDataType;
            }
            if (actualDataType instanceof UnknownDataType) {
                return expectedDataType;
            }
            Assert.fail((String)("Incompatible data types: " + expectedDataType + ", " + actualDataType + " (table=" + tableName + ", col=" + expectedColumn.getColumnName() + ")"));
        }
        return expectedDataType;
    }

    private static Column[] getSortedColumns(ITableMetaData metaData) throws DataSetException {
        logger.debug("getSortedColumns(metaData={}) - start", (Object)metaData);
        Column[] columns = metaData.getColumns();
        Column[] sortColumns = new Column[columns.length];
        System.arraycopy(columns, 0, sortColumns, 0, columns.length);
        Arrays.sort(sortColumns, COLUMN_COMPARATOR);
        return sortColumns;
    }

    private static String getColumnNamesAsString(Column[] columns) {
        logger.debug("getColumnNamesAsString(columns={}) - start", (Object[])columns);
        String[] names = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            names[i] = column.getColumnName();
        }
        return Arrays.asList(names).toString();
    }

    private static String[] getSortedUpperTableNames(IDataSet dataSet) throws DataSetException {
        logger.debug("getSortedUpperTableNames(dataSet={}) - start", (Object)dataSet);
        Object[] names = dataSet.getTableNames();
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((String)names[i]).toUpperCase();
        }
        Arrays.sort(names);
        return names;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ColumnComparator
    implements Comparator {
        private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$Assertion$ColumnComparator == null ? (class$org$dbunit$Assertion$ColumnComparator = Assertion.class$("org.dbunit.Assertion$ColumnComparator")) : class$org$dbunit$Assertion$ColumnComparator));

        private ColumnComparator() {
        }

        public int compare(Object o1, Object o2) {
            logger.debug("compare(o1={}, o2={}) - start", o1, o2);
            Column column1 = (Column)o1;
            Column column2 = (Column)o2;
            String columnName1 = column1.getColumnName();
            String columnName2 = column2.getColumnName();
            return columnName1.compareToIgnoreCase(columnName2);
        }
    }
}

