/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.AbstractStep;
import org.dbunit.ant.Query;
import org.dbunit.ant.QuerySet;
import org.dbunit.ant.Table;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.csv.CsvDataSetWriter;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.dbunit.dataset.xml.FlatXmlWriter;
import org.dbunit.dataset.xml.XmlDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Export
extends AbstractStep {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$ant$Export == null ? (class$org$dbunit$ant$Export = Export.class$("org.dbunit.ant.Export")) : class$org$dbunit$ant$Export));
    private File _dest;
    private String _format = "flat";
    private String _doctype = null;
    private List _tables = new ArrayList();
    static /* synthetic */ Class class$org$dbunit$ant$Export;

    private String getAbsolutePath(File filename) {
        logger.debug("getAbsolutePath(filename=" + filename + ") - start");
        return filename != null ? filename.getAbsolutePath() : "null";
    }

    public File getDest() {
        logger.debug("getDest() - start");
        return this._dest;
    }

    public String getFormat() {
        logger.debug("getFormat() - start");
        return this._format;
    }

    public List getTables() {
        logger.debug("getTables() - start");
        return this._tables;
    }

    public void setDest(File dest) {
        logger.debug("setDest(dest=" + dest + ") - start");
        this._dest = dest;
    }

    public void setFormat(String format) {
        logger.debug("setFormat(format=" + format + ") - start");
        if (!(format.equalsIgnoreCase("flat") || format.equalsIgnoreCase("xml") || format.equalsIgnoreCase("dtd") || format.equalsIgnoreCase("csv"))) {
            throw new IllegalArgumentException("Type must be one of: 'flat'(default), 'xml', or 'dtd' but was: " + format);
        }
        this._format = format;
    }

    public void addTable(Table table) {
        logger.debug("addTable(table=" + table + ") - start");
        this._tables.add(table);
    }

    public void addQuery(Query query) {
        logger.debug("addQuery(query=" + query + ") - start");
        this._tables.add(query);
    }

    public void addQuerySet(QuerySet querySet) {
        logger.debug("addQuerySet(querySet=" + querySet + ") - start");
        this._tables.add(querySet);
    }

    public String getDoctype() {
        logger.debug("getDoctype() - start");
        return this._doctype;
    }

    public void setDoctype(String doctype) {
        logger.debug("setDoctype(doctype=" + doctype + ") - start");
        this._doctype = doctype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IDatabaseConnection connection) throws DatabaseUnitException {
        block12: {
            logger.debug("execute(connection=" + connection + ") - start");
            try {
                if (this._dest == null) {
                    throw new DatabaseUnitException("'_dest' is a required attribute of the <export> step.");
                }
                IDataSet dataset = this.getDatabaseDataSet(connection, this._tables, false);
                this.log("dataset tables: " + Arrays.asList(dataset.getTableNames()), 3);
                if (this._format.equals("csv")) {
                    CsvDataSetWriter.write(dataset, this._dest);
                    break block12;
                }
                FileOutputStream out = new FileOutputStream(this._dest);
                try {
                    if (this._format.equalsIgnoreCase("flat")) {
                        FlatXmlWriter writer = new FlatXmlWriter(out);
                        writer.setDocType(this._doctype);
                        writer.write(dataset);
                    } else if (this._format.equalsIgnoreCase("xml")) {
                        XmlDataSet.write(dataset, out);
                    } else if (this._format.equalsIgnoreCase("dtd")) {
                        FlatDtdDataSet.write(dataset, out);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                throw new DatabaseUnitException(e);
            }
        }
    }

    public String getLogMessage() {
        logger.debug("getLogMessage() - start");
        return "Executing export: \n      in format: " + this._format + " to datafile: " + this.getAbsolutePath(this._dest);
    }

    public String toString() {
        logger.debug("toString() - start");
        StringBuffer result = new StringBuffer();
        result.append("Export: ");
        result.append(" dest=" + this.getAbsolutePath(this._dest));
        result.append(", format= " + this._format);
        result.append(", doctype= " + this._doctype);
        result.append(", tables= " + this._tables);
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

