/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.QueryTableIterator;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$database$QueryDataSet == null ? (class$org$dbunit$database$QueryDataSet = QueryDataSet.class$("org.dbunit.database.QueryDataSet")) : class$org$dbunit$database$QueryDataSet));
    private final IDatabaseConnection _connection;
    private final List _tableEntries = new ArrayList();
    static /* synthetic */ Class class$org$dbunit$database$QueryDataSet;
    static /* synthetic */ Class class$org$dbunit$database$QueryDataSet$TableEntry;

    public QueryDataSet(IDatabaseConnection connection) throws SQLException {
        this._connection = connection;
    }

    public void addTable(String tableName, String query) {
        logger.debug("addTable(tableName=" + tableName + ", query=" + query + ") - start");
        this._tableEntries.add(new TableEntry(tableName, query));
    }

    public void addTable(String tableName) {
        logger.debug("addTable(tableName=" + tableName + ") - start");
        this._tableEntries.add(new TableEntry(tableName, null));
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        logger.debug("createIterator(reversed=" + reversed + ") - start");
        ArrayList tableEntries = new ArrayList(this._tableEntries);
        if (reversed) {
            Collections.reverse(tableEntries);
        }
        return new QueryTableIterator(tableEntries, this._connection);
    }

    public String[] getTableNames() throws DataSetException {
        logger.debug("getTableNames() - start");
        ArrayList<String> names = new ArrayList<String>();
        Iterator it = this._tableEntries.iterator();
        while (it.hasNext()) {
            TableEntry entry = (TableEntry)it.next();
            names.add(entry.getTableName());
        }
        return names.toArray(new String[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class TableEntry {
        private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$database$QueryDataSet$TableEntry == null ? (class$org$dbunit$database$QueryDataSet$TableEntry = QueryDataSet.class$("org.dbunit.database.QueryDataSet$TableEntry")) : class$org$dbunit$database$QueryDataSet$TableEntry));
        private final String _tableName;
        private final String _query;

        public TableEntry(String tableName, String query) {
            this._tableName = tableName;
            this._query = query;
        }

        public String getTableName() {
            logger.debug("getTableName() - start");
            return this._tableName;
        }

        public String getQuery() {
            logger.debug("getQuery() - start");
            return this._query;
        }
    }
}

