/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.HashMap;
import java.util.Map;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.ReplacementTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplacementDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$ReplacementDataSet == null ? (class$org$dbunit$dataset$ReplacementDataSet = ReplacementDataSet.class$("org.dbunit.dataset.ReplacementDataSet")) : class$org$dbunit$dataset$ReplacementDataSet));
    private final IDataSet _dataSet;
    private final Map _objectMap;
    private final Map _substringMap;
    private String _startDelim;
    private String _endDelim;
    static /* synthetic */ Class class$org$dbunit$dataset$ReplacementDataSet;
    static /* synthetic */ Class class$org$dbunit$dataset$ReplacementDataSet$ReplacementIterator;

    public ReplacementDataSet(IDataSet dataSet) {
        this._dataSet = dataSet;
        this._objectMap = new HashMap();
        this._substringMap = new HashMap();
    }

    public ReplacementDataSet(IDataSet dataSet, Map objectMap, Map substringMap) {
        this._dataSet = dataSet;
        this._objectMap = objectMap == null ? new HashMap() : objectMap;
        this._substringMap = substringMap == null ? new HashMap() : substringMap;
    }

    public void addReplacementObject(Object originalObject, Object replacementObject) {
        logger.debug("addReplacementObject(originalObject=" + originalObject + ", replacementObject=" + replacementObject + ") - start");
        this._objectMap.put(originalObject, replacementObject);
    }

    public void addReplacementSubstring(String originalSubstring, String replacementSubstring) {
        logger.debug("addReplacementSubstring(originalSubstring=" + originalSubstring + ", replacementSubstring=" + replacementSubstring + ") - start");
        if (originalSubstring == null || replacementSubstring == null) {
            throw new NullPointerException();
        }
        this._substringMap.put(originalSubstring, replacementSubstring);
    }

    public void setSubstringDelimiters(String startDelimiter, String endDelimiter) {
        logger.debug("setSubstringDelimiters(startDelimiter=" + startDelimiter + ", endDelimiter=" + endDelimiter + ") - start");
        if (startDelimiter == null || endDelimiter == null) {
            throw new NullPointerException();
        }
        this._startDelim = startDelimiter;
        this._endDelim = endDelimiter;
    }

    private ReplacementTable createReplacementTable(ITable table) {
        logger.debug("createReplacementTable(table=" + table + ") - start");
        return new ReplacementTable(table, this._objectMap, this._substringMap, this._startDelim, this._endDelim);
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        logger.debug("createIterator(reversed=" + reversed + ") - start");
        return new ReplacementIterator(reversed ? this._dataSet.reverseIterator() : this._dataSet.iterator());
    }

    public String[] getTableNames() throws DataSetException {
        logger.debug("getTableNames() - start");
        return this._dataSet.getTableNames();
    }

    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        logger.debug("getTableMetaData(tableName=" + tableName + ") - start");
        return this._dataSet.getTableMetaData(tableName);
    }

    public ITable getTable(String tableName) throws DataSetException {
        logger.debug("getTable(tableName=" + tableName + ") - start");
        return this.createReplacementTable(this._dataSet.getTable(tableName));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ReplacementIterator
    implements ITableIterator {
        private final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$ReplacementDataSet$ReplacementIterator == null ? (class$org$dbunit$dataset$ReplacementDataSet$ReplacementIterator = ReplacementDataSet.class$("org.dbunit.dataset.ReplacementDataSet$ReplacementIterator")) : class$org$dbunit$dataset$ReplacementDataSet$ReplacementIterator));
        private final ITableIterator _iterator;

        public ReplacementIterator(ITableIterator iterator) {
            this._iterator = iterator;
        }

        public boolean next() throws DataSetException {
            this.logger.debug("next() - start");
            return this._iterator.next();
        }

        public ITableMetaData getTableMetaData() throws DataSetException {
            this.logger.debug("getTableMetaData() - start");
            return this._iterator.getTableMetaData();
        }

        public ITable getTable() throws DataSetException {
            this.logger.debug("getTable() - start");
            return ReplacementDataSet.this.createReplacementTable(this._iterator.getTable());
        }
    }
}

