/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.oracle;

import org.dbunit.dataset.datatype.BinaryStreamDataType;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.ext.oracle.OracleBlobDataType;
import org.dbunit.ext.oracle.OracleClobDataType;
import org.dbunit.ext.oracle.OracleNClobDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDataTypeFactory
extends DefaultDataTypeFactory {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$ext$oracle$OracleDataTypeFactory == null ? (class$org$dbunit$ext$oracle$OracleDataTypeFactory = OracleDataTypeFactory.class$("org.dbunit.ext.oracle.OracleDataTypeFactory")) : class$org$dbunit$ext$oracle$OracleDataTypeFactory));
    public static final DataType ORACLE_BLOB = new OracleBlobDataType();
    public static final DataType ORACLE_CLOB = new OracleClobDataType();
    public static final DataType ORACLE_NCLOB = new OracleNClobDataType();
    public static final DataType LONG_RAW = new BinaryStreamDataType("LONG RAW", -4);
    static /* synthetic */ Class class$org$dbunit$ext$oracle$OracleDataTypeFactory;

    public DataType createDataType(int sqlType, String sqlTypeName) throws DataTypeException {
        logger.debug("createDataType(sqlType=" + sqlType + ", sqlTypeName=" + sqlTypeName + ") - start");
        if (sqlType == 91) {
            return DataType.TIMESTAMP;
        }
        if (sqlTypeName.startsWith("TIMESTAMP")) {
            return DataType.TIMESTAMP;
        }
        if ("BLOB".equals(sqlTypeName)) {
            return ORACLE_BLOB;
        }
        if ("CLOB".equals(sqlTypeName)) {
            return ORACLE_CLOB;
        }
        if ("NCLOB".equals(sqlTypeName)) {
            return ORACLE_NCLOB;
        }
        if ("NVARCHAR2".equals(sqlTypeName)) {
            return DataType.VARCHAR;
        }
        if (sqlTypeName.startsWith("NCHAR")) {
            return DataType.CHAR;
        }
        if ("FLOAT".equals(sqlTypeName)) {
            return DataType.FLOAT;
        }
        if (LONG_RAW.toString().equals(sqlTypeName)) {
            return LONG_RAW;
        }
        return super.createDataType(sqlType, sqlTypeName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

