/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.sql.SQLException;
import java.util.BitSet;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.statement.IPreparedBatchStatement;
import org.dbunit.database.statement.IStatementFactory;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.dbunit.dataset.datatype.TypeCastException;
import org.dbunit.operation.AbstractOperation;
import org.dbunit.operation.OperationData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBatchOperation
extends AbstractOperation {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$operation$AbstractBatchOperation == null ? (class$org$dbunit$operation$AbstractBatchOperation = AbstractBatchOperation.class$("org.dbunit.operation.AbstractBatchOperation")) : class$org$dbunit$operation$AbstractBatchOperation));
    private static final BitSet EMPTY_BITSET = new BitSet();
    protected boolean _reverseRowOrder = false;
    static /* synthetic */ Class class$org$dbunit$operation$AbstractBatchOperation;

    static boolean isEmpty(ITable table) throws DataSetException {
        logger.debug("isEmpty(table=" + table + ") - start");
        Column[] columns = table.getTableMetaData().getColumns();
        if (columns.length == 0) {
            return true;
        }
        try {
            table.getValue(0, columns[0].getColumnName());
            return false;
        }
        catch (RowOutOfBoundsException e) {
            return true;
        }
    }

    protected ITableIterator iterator(IDataSet dataSet) throws DatabaseUnitException {
        logger.debug("iterator(dataSet) - start");
        return dataSet.iterator();
    }

    BitSet getIgnoreMapping(ITable table, int row) throws DataSetException {
        logger.debug("getIgnoreMapping(table=" + table + ", row=" + row + ") - start");
        return EMPTY_BITSET;
    }

    boolean equalsIgnoreMapping(BitSet ignoreMapping, ITable table, int row) throws DataSetException {
        logger.debug("equalsIgnoreMapping(ignoreMapping=" + ignoreMapping + ", table=" + table + ", row=" + row + ") - start");
        return true;
    }

    abstract OperationData getOperationData(ITableMetaData var1, BitSet var2, IDatabaseConnection var3) throws DataSetException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IDatabaseConnection connection, IDataSet dataSet) throws DatabaseUnitException, SQLException {
        logger.debug("execute(connection=" + connection + ", dataSet) - start");
        DatabaseConfig databaseConfig = connection.getConfig();
        IStatementFactory factory = (IStatementFactory)databaseConfig.getProperty("http://www.dbunit.org/properties/statementFactory");
        ITableIterator iterator = this.iterator(dataSet);
        while (iterator.next()) {
            ITable table = iterator.getTable();
            if (AbstractBatchOperation.isEmpty(table)) continue;
            ITableMetaData metaData = AbstractBatchOperation.getOperationMetaData(connection, table.getTableMetaData());
            BitSet ignoreMapping = null;
            OperationData operationData = null;
            IPreparedBatchStatement statement = null;
            try {
                int start = this._reverseRowOrder ? table.getRowCount() - 1 : 0;
                int increment = this._reverseRowOrder ? -1 : 1;
                try {
                    int i = start;
                    while (true) {
                        int row = i;
                        if (ignoreMapping == null || !this.equalsIgnoreMapping(ignoreMapping, table, row)) {
                            if (statement != null) {
                                statement.executeBatch();
                                statement.clearBatch();
                                statement.close();
                            }
                            ignoreMapping = this.getIgnoreMapping(table, row);
                            operationData = this.getOperationData(metaData, ignoreMapping, connection);
                            statement = factory.createPreparedBatchStatement(operationData.getSql(), connection);
                        }
                        Column[] columns = operationData.getColumns();
                        for (int j = 0; j < columns.length; ++j) {
                            if (ignoreMapping.get(j)) continue;
                            Column column = columns[j];
                            try {
                                statement.addValue(table.getValue(row, column.getColumnName()), column.getDataType());
                                continue;
                            }
                            catch (TypeCastException e) {
                                throw new TypeCastException("Error casting value for table '" + table.getTableMetaData().getTableName() + "' and column '" + column.getColumnName() + "'", e);
                            }
                        }
                        statement.addBatch();
                        i += increment;
                    }
                }
                catch (RowOutOfBoundsException e) {
                    statement.executeBatch();
                    statement.clearBatch();
                    if (statement == null) continue;
                    statement.close();
                }
            }
            catch (Throwable throwable) {
                if (statement != null) {
                    statement.close();
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

