/*
 * Decompiled with CFR 0.152.
 */
package imagelib;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import imagelib.io.ImageData;
import imagelib.io.ImageReader;
import imagelib.io.dicom.DICOMReader;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class DICOM2JPEGConverter {
    protected ImageReader reader = new DICOMReader();

    public BufferedImage prepareBufferedImage(ImageData imgData) {
        int[] rawData = imgData.getRawData();
        return this.createGrayScaleImage(imgData, rawData);
    }

    public BufferedImage createGrayScaleImage(ImageData imgData, int[] rawData) {
        imgData.scale4GrayScale();
        ComponentColorModel ccm = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
        ComponentSampleModel csm = new ComponentSampleModel(0, imgData.getWidth(), imgData.getHeight(), 1, imgData.getWidth(), new int[1]);
        DataBufferInt dataBuffer = new DataBufferInt(imgData.getRawData(), imgData.getWidth());
        WritableRaster wr = Raster.createWritableRaster(csm, dataBuffer, null);
        return new BufferedImage(ccm, wr, true, null);
    }

    public void saveAsJpeg(String filename, BufferedImage bi) throws IOException {
        ImageIO.write((RenderedImage)bi, "png", new File(filename));
    }

    public void convert(String inFile, String outFile) throws IOException {
        boolean ok = this.reader.canRead(inFile);
        if (!ok) {
            System.err.println("Cannot read DICOM File (May not a DICOM File?):" + inFile);
            return;
        }
        ImageData imgData = this.reader.load(inFile);
        BufferedImage bufImage = this.prepareBufferedImage(imgData);
        this.saveAsJpeg(outFile, bufImage);
    }

    public void convertNoCheck(String inFile, String outFile) throws IOException {
        ImageData imgData = this.reader.load(inFile);
        BufferedImage bufImage = this.prepareBufferedImage(imgData);
        this.saveAsJpeg(outFile, bufImage);
    }

    public void saveAsJpeg2(String filename, BufferedImage bi) throws IOException {
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(filename));
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            encoder.encode(bi);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void usage() {
        System.err.println("Usage:java imagelib.DICOM2JPEGConverter <inFile> <outFile>");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            DICOM2JPEGConverter.usage();
        }
        DICOM2JPEGConverter converter = new DICOM2JPEGConverter();
        try {
            converter.convert(args[0], args[1]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

