/*
 * Decompiled with CFR 0.152.
 */
package imagelib.io;

import imagelib.io.ImageSeries;
import imagelib.io.ImageSeriesInfo;
import imagelib.io.ImageSeriesReader;
import imagelib.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class AFNISeriesReader
extends ImageSeriesReader {
    @Override
    public boolean canRead(ImageSeriesInfo isInfo) {
        File location = new File(isInfo.getLocation());
        if (location.isDirectory()) {
            return false;
        }
        return isInfo.getLocation().endsWith(".BRIK") || isInfo.getLocation().endsWith(".HEAD");
    }

    @Override
    public ImageSeries load(ImageSeriesInfo isInfo) throws IOException {
        String brikFile = null;
        String headFile = null;
        String base = isInfo.location.substring(0, isInfo.location.lastIndexOf(46));
        if (isInfo.location.endsWith(".BRIK")) {
            brikFile = isInfo.location;
            headFile = String.valueOf(base) + ".HEAD";
        } else {
            headFile = isInfo.location;
            brikFile = String.valueOf(base) + ".BRIK";
        }
        Map<String, Object> headerParams = this.loadAFNIHeaderParams(headFile);
        int[] dims = (int[])headerParams.get("DATASET_DIMENSIONS");
        int[] orientation = (int[])headerParams.get("ORIENT_SPECIFIC");
        if (orientation[0] != 3 && orientation[0] != 2 || orientation[1] != 5 && orientation[1] != 4) {
            throw new IOException("Only sagittal AFNI BRIKs are supported for the time being!");
        }
        int noVoxels = dims[0] * dims[1] * dims[2];
        int noSlices = dims[2];
        int rows = dims[0];
        int cols = dims[1];
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        int[] data = new int[noVoxels];
        boolean swapBytes = false;
        String s = (String)headerParams.get("BYTEORDER_STRING");
        if (s != null && s.equals("LSB_FIRST")) {
            swapBytes = true;
        }
        FilterInputStream in = null;
        try {
            ImageSeries is;
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(brikFile), 4096));
            int i = 0;
            while (i < noVoxels) {
                data[i] = this.toUShort(((DataInputStream)in).readShort());
                if (swapBytes) {
                    data[i] = Utils.swapFirst2Bytes(data[i]);
                }
                if (data[i] > max) {
                    max = data[i];
                }
                if (data[i] < min) {
                    min = data[i];
                }
                ++i;
            }
            System.out.println("loaded AFNI BRIK.");
            System.out.println("min=" + min + ", max=" + max);
            ImageSeries imageSeries = is = new ImageSeries("", data, noSlices, rows, cols);
            return imageSeries;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected Map<String, Object> loadAFNIHeaderParams(String filename) throws IOException {
        HashMap<String, Object> headerParams = new HashMap<String, Object>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(filename), 4096);
            String line = null;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                String[] tokens = this.getTokens(line, " \t");
                if (tokens[0].equals("name") && tokens.length >= 3 && tokens[2].equals("DATASET_DIMENSIONS")) {
                    line = this.getValidLine(in);
                    line = this.getValidLine(in);
                    tokens = this.getTokens(line, " \t");
                    headerParams.put("DATASET_DIMENSIONS", this.toIntArray(tokens));
                    continue;
                }
                if (tokens[0].equals("name") && tokens.length >= 3 && tokens[2].equals("ORIENT_SPECIFIC")) {
                    line = this.getValidLine(in);
                    line = this.getValidLine(in);
                    tokens = this.getTokens(line, " \t");
                    headerParams.put("ORIENT_SPECIFIC", this.toIntArray(tokens));
                    continue;
                }
                if (!tokens[0].equals("name") || tokens.length < 3 || !tokens[2].equals("BYTEORDER_STRING")) continue;
                line = this.getValidLine(in);
                line = this.getValidLine(in).trim();
                String s = line.substring(1, line.length() - 1);
                headerParams.put("BYTEORDER_STRING", s);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return headerParams;
    }

    private int[] toIntArray(String[] toks) {
        int[] arr = new int[toks.length];
        int i = 0;
        while (i < toks.length) {
            arr[i] = Integer.parseInt(toks[i]);
            ++i;
        }
        return arr;
    }

    private String getValidLine(BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            return line;
        }
        return null;
    }

    private int toUShort(short value) {
        int v = value;
        if (v < 0) {
            v += 65536;
        }
        return v;
    }

    private String[] getTokens(String line, String delims) {
        StringTokenizer stok = new StringTokenizer(line, delims);
        String[] tokens = new String[stok.countTokens()];
        int i = 0;
        while (stok.hasMoreTokens()) {
            tokens[i++] = stok.nextToken();
        }
        return tokens;
    }
}

