/*
 * Decompiled with CFR 0.152.
 */
package imagelib.io;

import imagelib.io.ImageData;
import imagelib.io.ImageReader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;

public class RawImageReader
extends ImageReader {
    public boolean canRead(String filename) {
        File f = new File(filename);
        if (!f.exists() || !f.isFile()) {
            return false;
        }
        long fileLength = f.length();
        if (fileLength == 65536L) {
            this.pixelSize = 1;
        } else if (fileLength == 131072L) {
            this.pixelSize = 2;
        } else {
            return false;
        }
        return true;
    }

    private int toUShort(short value) {
        int v = value;
        if (v < 0) {
            v += 65536;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageData load(String inFile) throws IOException {
        System.out.println("loading file " + inFile);
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(inFile), 4096));
            int[] rawData = new int[65536];
            ImageData imgData = new ImageData(rawData, 256, 256);
            imgData.setPixelSize(this.pixelSize);
            imgData.setMaxPixelValue(Integer.MIN_VALUE);
            imgData.setMinPixelValue(Integer.MAX_VALUE);
            for (int i = 0; i < 65536; ++i) {
                rawData[i] = ((DataInputStream)in).readUnsignedShort();
                if (rawData[i] < imgData.getMinPixelValue()) {
                    imgData.setMinPixelValue(rawData[i]);
                }
                if (rawData[i] <= imgData.getMaxPixelValue()) continue;
                imgData.setMaxPixelValue(rawData[i]);
            }
            System.out.println("min pixel value=" + imgData.getMinPixelValue() + ", max pixel value=" + imgData.getMaxPixelValue());
            ImageData imageData = imgData;
            return imageData;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception x) {}
            }
        }
    }
}

