/*
 * Decompiled with CFR 0.152.
 */
package imagelib.io.dicom;

public class DICOMDataElement {
    protected String name;
    protected String value;
    protected int tag;
    protected int action;
    protected boolean implicitVR = false;
    public static final int NONE = 0;
    public static final int REMOVE = 1;
    public static final int ADD = 2;
    public static final int UPDATE = 3;

    public DICOMDataElement(String name, String value) {
        this.name = name;
        this.value = value;
        this.action = 3;
    }

    public DICOMDataElement() {
        this.action = 0;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int getAction() {
        return this.action;
    }

    public int getTag() {
        return this.tag;
    }

    public boolean isImplicitVR() {
        return this.implicitVR;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public void setImplicitVR(boolean implicit) {
        this.implicitVR = implicit;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public void setAction(String actionStr) {
        if (actionStr.equalsIgnoreCase("add")) {
            this.action = 2;
        } else if (actionStr.equalsIgnoreCase("remove")) {
            this.action = 1;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("DICOMDataElement::[").append("name=").append(this.name);
        buf.append(", value=").append(this.value).append(']');
        return buf.toString();
    }
}

