/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.PreorderNodeIterator;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.VariableTable;

public class NodeTransformer {
    protected ObjArray loops;
    protected ObjArray loopEnds;
    protected boolean inFunction;
    protected IRFactory irFactory;

    public NodeTransformer(IRFactory irFactory) {
        this.irFactory = irFactory;
    }

    public NodeTransformer newInstance() {
        return new NodeTransformer(this.irFactory);
    }

    public Node transform(Node tree, Node enclosing) {
        this.loops = new ObjArray();
        this.loopEnds = new ObjArray();
        this.inFunction = tree.getType() == 110;
        VariableTable vars = this.getVariableTable(tree);
        if (this.inFunction) {
            String name;
            FunctionNode fn = (FunctionNode)tree;
            if (fn.getFunctionType() == 2 && (name = fn.getFunctionName()) != null && name.length() != 0 && !vars.hasVariable(name)) {
                vars.addLocal(name);
                Node block = tree.getLastChild();
                Node setFn = new Node(57, new Node(73, Node.newString(name), new Node(109, 87)));
                block.addChildrenToFront(setFn);
            }
            fn.markVariableTableReady();
        }
        boolean hasFinally = false;
        PreorderNodeIterator iter = new PreorderNodeIterator();
        iter.start(tree);
        while (!iter.done()) {
            Node node = iter.getCurrent();
            int type = node.getType();
            block0 : switch (type) {
                case 110: {
                    if (node == tree) {
                        Node stmts = node.getLastChild();
                        Node lastStmt = stmts.getLastChild();
                        if (lastStmt != null && lastStmt.getType() == 5) break;
                        stmts.addChildToBack(new Node(5));
                        break;
                    }
                    FunctionNode fnNode = (FunctionNode)node.getProp(5);
                    if (this.inFunction) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                        fnNode.setCheckThis(true);
                    }
                    NodeTransformer inner = this.newInstance();
                    fnNode = (FunctionNode)inner.transform(fnNode, tree);
                    node.putProp(5, fnNode);
                    ObjArray fns = (ObjArray)tree.getProp(5);
                    if (fns == null) {
                        fns = new ObjArray();
                        tree.putProp(5, fns);
                    }
                    fns.add(fnNode);
                    break;
                }
                case 136: {
                    Node child = node.getFirstChild();
                    node.removeChild(child);
                    String id = child.getString();
                    int i = this.loops.size() - 1;
                    while (i >= 0) {
                        String otherId;
                        Node n = (Node)this.loops.get(i);
                        if (n.getType() == 136 && id.equals(otherId = (String)n.getProp(17))) {
                            Object[] messageArgs = new Object[]{id};
                            this.reportError("msg.dup.label", messageArgs, node, tree);
                            break block0;
                        }
                        --i;
                    }
                    node.putProp(17, id);
                    Node breakTarget = new Node(137);
                    Node parent = iter.getCurrentParent();
                    Node next = node.getNext();
                    while (next != null && (next.getType() == 136 || next.getType() == 137)) {
                        next = next.getNext();
                    }
                    if (next == null) break;
                    parent.addChildAfter(breakTarget, next);
                    node.putProp(2, breakTarget);
                    if (next.getType() == 138) {
                        node.putProp(3, next.getProp(3));
                    }
                    this.loops.push(node);
                    this.loopEnds.push(breakTarget);
                    break;
                }
                case 115: {
                    Node breakTarget = new Node(137);
                    Node parent = iter.getCurrentParent();
                    parent.addChildAfter(breakTarget, node);
                    Node sib = node;
                    Node child = node.getFirstChild().next;
                    while (child != null) {
                        Node next = child.next;
                        node.removeChild(child);
                        parent.addChildAfter(child, sib);
                        sib = child;
                        child = next;
                    }
                    node.putProp(2, breakTarget);
                    this.loops.push(node);
                    this.loopEnds.push(breakTarget);
                    node.putProp(12, new ObjArray());
                    break;
                }
                case 116: 
                case 117: {
                    Node sw = (Node)this.loops.peek();
                    if (type == 116) {
                        ObjArray cases = (ObjArray)sw.getProp(12);
                        cases.add(node);
                        break;
                    }
                    sw.putProp(13, node);
                    break;
                }
                case 144: {
                    int localCount = tree.getIntProp(19, 0);
                    tree.putIntProp(19, localCount + 1);
                    break;
                }
                case 138: {
                    this.loops.push(node);
                    this.loopEnds.push(node.getProp(2));
                    break;
                }
                case 124: {
                    if (this.inFunction) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                    }
                    this.loops.push(node);
                    Node leave = node.getNext();
                    if (leave.getType() != 4) {
                        throw new RuntimeException("Unexpected tree");
                    }
                    this.loopEnds.push(leave);
                    break;
                }
                case 75: {
                    Node finallytarget = (Node)node.getProp(18);
                    if (finallytarget != null) {
                        hasFinally = true;
                        this.loops.push(node);
                        this.loopEnds.push(finallytarget);
                    }
                    int localCount = tree.getIntProp(19, 0);
                    tree.putIntProp(19, localCount + 1);
                    break;
                }
                case 4: 
                case 137: {
                    if (this.loopEnds.isEmpty() || this.loopEnds.peek() != node) break;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 5: {
                    if (!hasFinally) break;
                    int i = this.loops.size() - 1;
                    while (i >= 0) {
                        Node n = (Node)this.loops.get(i);
                        int elemtype = n.getType();
                        if (elemtype == 75) {
                            Node jsrnode = new Node(143);
                            Object jsrtarget = n.getProp(18);
                            jsrnode.putProp(1, jsrtarget);
                            iter.addBeforeCurrent(jsrnode);
                        } else if (elemtype == 124) {
                            Node leave = new Node(4);
                            iter.addBeforeCurrent(leave);
                        }
                        --i;
                    }
                    break;
                }
                case 121: 
                case 122: {
                    Node target;
                    Node loop = null;
                    boolean labelled = node.hasChildren();
                    String id = null;
                    if (labelled) {
                        Node child = node.getFirstChild();
                        id = child.getString();
                        node.removeChild(child);
                    }
                    int i = this.loops.size() - 1;
                    while (i >= 0) {
                        Node n = (Node)this.loops.get(i);
                        int elemtype = n.getType();
                        if (elemtype == 124) {
                            Node leave = new Node(4);
                            iter.addBeforeCurrent(leave);
                        } else if (elemtype == 75) {
                            Node jsrFinally = new Node(143);
                            Object jsrTarget = n.getProp(18);
                            jsrFinally.putProp(1, jsrTarget);
                            iter.addBeforeCurrent(jsrFinally);
                        } else {
                            if (!labelled && (elemtype == 138 || elemtype == 115 && type == 121)) {
                                loop = n;
                                break;
                            }
                            if (labelled && elemtype == 136 && id.equals((String)n.getProp(17))) {
                                loop = n;
                                break;
                            }
                        }
                        --i;
                    }
                    int propType = type == 121 ? 2 : 3;
                    Node node2 = target = loop == null ? null : (Node)loop.getProp(propType);
                    if (loop == null || target == null) {
                        String messageId;
                        Object[] messageArgs = null;
                        if (!labelled) {
                            messageId = type == 122 ? "msg.continue.outside" : "msg.bad.break";
                        } else if (loop != null) {
                            messageId = "msg.continue.nonloop";
                        } else {
                            messageArgs = new Object[]{id};
                            messageId = "msg.undef.label";
                        }
                        this.reportError(messageId, messageArgs, node, tree);
                        node.setType(128);
                        break;
                    }
                    node.setType(6);
                    node.putProp(1, target);
                    break;
                }
                case 43: {
                    if (this.isSpecialCallName(tree, node)) {
                        node.putProp(25, Boolean.TRUE);
                    }
                    this.visitCall(node, tree);
                    break;
                }
                case 30: {
                    if (this.isSpecialCallName(tree, node)) {
                        node.putProp(25, Boolean.TRUE);
                    }
                    this.visitNew(node, tree);
                    break;
                }
                case 108: {
                    Node right = node.getLastChild();
                    right.setType(46);
                    break;
                }
                case 140: {
                    node.setType(this.inFunction ? 57 : 2);
                    break;
                }
                case 56: {
                    Node left = node.getFirstChild();
                    Node right = node.getLastChild();
                    String string = left.getString();
                    String flags = left != right ? right.getString() : null;
                    int index = ((ScriptOrFnNode)tree).addRegexp(string, flags);
                    Node n = new Node(56);
                    iter.replaceCurrent(n);
                    n.putIntProp(11, index);
                    break;
                }
                case 123: {
                    Node result = new Node(133);
                    Node cursor = node.getFirstChild();
                    while (cursor != null) {
                        Node n = cursor;
                        cursor = cursor.getNext();
                        if (!n.hasChildren()) continue;
                        Node init = n.getFirstChild();
                        n.removeChild(init);
                        Node asn = (Node)this.irFactory.createAssignment(128, n, init, null, false);
                        Node pop = new Node(57, asn, node.getLineno());
                        result.addChildToBack(pop);
                    }
                    iter.replaceCurrent(result);
                    break;
                }
                case 10: 
                case 31: {
                    Node bind;
                    if (!this.inFunction || this.inWithStatement() || (bind = node.getFirstChild()) == null || bind.getType() != 61) break;
                    String name = bind.getString();
                    Context cx = Context.getCurrentContext();
                    if (cx != null && cx.isActivationNeeded(name)) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                    }
                    if (!vars.hasVariable(name)) break;
                    if (type == 10) {
                        node.setType(73);
                        bind.setType(46);
                        break;
                    }
                    Node n = new Node(109, 51);
                    iter.replaceCurrent(n);
                    break;
                }
                case 39: {
                    if (!this.inFunction) break;
                    Node n = node.getFirstChild().getNext();
                    String name = n == null ? "" : n.getString();
                    Context cx = Context.getCurrentContext();
                    if ((cx == null || !cx.isActivationNeeded(name)) && (!name.equals("length") || cx.getLanguageVersion() != 120)) break;
                    ((FunctionNode)tree).setRequiresActivation(true);
                    break;
                }
                case 44: {
                    if (!this.inFunction || this.inWithStatement()) break;
                    String name = node.getString();
                    Context cx = Context.getCurrentContext();
                    if (cx != null && cx.isActivationNeeded(name)) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                    }
                    if (!vars.hasVariable(name)) break;
                    node.setType(72);
                    break;
                }
            }
            iter.next();
        }
        return tree;
    }

    protected void visitNew(Node node, Node tree) {
    }

    protected void visitCall(Node node, Node tree) {
        Node left = node.getFirstChild();
        int argCount = 0;
        Node arg = left.getNext();
        while (arg != null) {
            arg = arg.getNext();
            ++argCount;
        }
        boolean addGetThis = false;
        if (left.getType() == 44) {
            VariableTable vars = this.getVariableTable(tree);
            String name = left.getString();
            if (this.inFunction && vars.hasVariable(name) && !this.inWithStatement()) {
                left.setType(72);
            } else {
                node.removeChild(left);
                left.setType(71);
                Node str = left.cloneNode();
                str.setType(46);
                Node getProp = new Node(39, left, str);
                node.addChildToFront(getProp);
                left = getProp;
                boolean bl = addGetThis = this.inWithStatement() || !this.inFunction;
            }
        }
        if (left.getType() != 39 && left.getType() != 41) {
            node.removeChild(left);
            Node tmp = this.irFactory.createNewTemp(left);
            Node use = this.irFactory.createUseTemp(tmp);
            use.putProp(6, tmp);
            Node parent = new Node(141, use);
            node.addChildToFront(parent);
            node.addChildToFront(tmp);
            return;
        }
        Node leftLeft = left.getFirstChild();
        left.removeChild(leftLeft);
        Node tmp = this.irFactory.createNewTemp(leftLeft);
        left.addChildToFront(tmp);
        Node use = this.irFactory.createUseTemp(tmp);
        use.putProp(6, tmp);
        if (addGetThis) {
            use = new Node(68, use);
        }
        node.addChildAfter(use, left);
    }

    protected boolean inWithStatement() {
        int i = this.loops.size() - 1;
        while (i >= 0) {
            Node n = (Node)this.loops.get(i);
            if (n.getType() == 124) {
                return true;
            }
            --i;
        }
        return false;
    }

    private boolean isSpecialCallName(Node tree, Node node) {
        Node left = node.getFirstChild();
        boolean isSpecial = false;
        if (left.getType() == 44) {
            String name = left.getString();
            isSpecial = name.equals("eval") || name.equals("With");
        } else if (left.getType() == 39) {
            String name = left.getLastChild().getString();
            isSpecial = name.equals("exec");
        }
        if (isSpecial) {
            if (this.inFunction) {
                ((FunctionNode)tree).setRequiresActivation(true);
            }
            return true;
        }
        return false;
    }

    protected VariableTable getVariableTable(Node tree) {
        return ((ScriptOrFnNode)tree).getVariableTable();
    }

    private void reportError(String messageId, Object[] messageArgs, Node stmt, Node tree) {
        int lineno = stmt.getLineno();
        String sourceName = ((ScriptOrFnNode)tree).getSourceName();
        this.irFactory.ts.reportSyntaxError(true, messageId, messageArgs, sourceName, lineno, null, 0);
    }
}

