/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Node;

public final class PreorderNodeIterator {
    private Node[] stack;
    private int stackTop;
    private Node current;
    private Node cachedPrev;

    public Node getCurrent() {
        return this.current;
    }

    public Node getCurrentParent() {
        return this.stack[this.stackTop - 1];
    }

    public void start(Node tree) {
        this.current = tree;
        this.cachedPrev = null;
        while (this.stackTop != 0) {
            --this.stackTop;
            this.stack[this.stackTop] = null;
        }
    }

    public boolean done() {
        return this.current == null;
    }

    public void next() {
        Node first = this.current.getFirstChild();
        if (first != null) {
            this.stackPush(this.current);
            this.cachedPrev = null;
            this.current = first;
        } else {
            this.nextSkipSubtree();
        }
    }

    public void nextSkipSubtree() {
        while (true) {
            this.cachedPrev = this.current;
            this.current = this.current.next;
            if (this.current != null) break;
            if (this.stackTop == 0) {
                this.cachedPrev = null;
                break;
            }
            --this.stackTop;
            this.current = this.stack[this.stackTop];
            this.stack[this.stackTop] = null;
        }
    }

    public void replaceCurrent(Node newNode) {
        Node parent = this.stack[this.stackTop - 1];
        if (this.cachedPrev != null && this.cachedPrev.next == this.current) {
            parent.replaceChildAfter(this.cachedPrev, newNode);
        } else {
            parent.replaceChild(this.current, newNode);
        }
        this.current = newNode;
    }

    public void addBeforeCurrent(Node newNode) {
        Node parent = this.stack[this.stackTop - 1];
        if (this.cachedPrev != null && this.cachedPrev.next == this.current) {
            parent.addChildAfter(newNode, this.cachedPrev);
        } else {
            parent.addChildBefore(newNode, this.current);
        }
        this.cachedPrev = newNode;
    }

    private void stackPush(Node n) {
        int N = this.stackTop;
        if (N == 0) {
            this.stack = new Node[16];
        } else if (N == this.stack.length) {
            Node[] tmp = new Node[N * 2];
            System.arraycopy(this.stack, 0, tmp, 0, N);
            this.stack = tmp;
        }
        this.stack[N] = n;
        this.stackTop = N + 1;
    }
}

