/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.optimizer.OptFunctionNode;

class OptTransformer
extends NodeTransformer {
    private Hashtable theFnClassNameList;

    OptTransformer(IRFactory irFactory, Hashtable theFnClassNameList) {
        super(irFactory);
        this.theFnClassNameList = theFnClassNameList;
    }

    public NodeTransformer newInstance() {
        Hashtable listCopy = (Hashtable)this.theFnClassNameList.clone();
        return new OptTransformer(this.irFactory, listCopy);
    }

    public Node transform(Node tree, Node enclosing) {
        this.collectContainedFunctions(tree.getFirstChild());
        return super.transform(tree, enclosing);
    }

    private int detectDirectCall(Node node, Node tree) {
        Context cx = Context.getCurrentContext();
        int optLevel = cx.getOptimizationLevel();
        Node left = node.getFirstChild();
        int argCount = 0;
        Node arg = left.getNext();
        while (arg != null) {
            arg = arg.getNext();
            ++argCount;
        }
        if (tree.getType() == 110 && optLevel > 0) {
            if (left.getType() == 44) {
                this.markDirectCall(tree, node, argCount, left.getString());
            } else if (left.getType() == 39) {
                Node name = left.getFirstChild().getNext();
                this.markDirectCall(tree, node, argCount, name.getString());
            }
        }
        return argCount;
    }

    protected void visitNew(Node node, Node tree) {
        this.detectDirectCall(node, tree);
        super.visitNew(node, tree);
    }

    protected void visitCall(Node node, Node tree) {
        int argCount = this.detectDirectCall(node, tree);
        if (this.inFunction && argCount == 0) {
            ((OptFunctionNode)tree).setContainsCalls(argCount);
        }
        super.visitCall(node, tree);
    }

    private void markDirectCall(Node containingTree, Node callNode, int argCount, String targetName) {
        OptFunctionNode theFunction = (OptFunctionNode)this.theFnClassNameList.get(targetName);
        if (theFunction != null) {
            int N = theFunction.getParameterCount();
            if (N > 32) {
                return;
            }
            if (argCount == N) {
                callNode.putProp(24, theFunction);
                ((OptFunctionNode)containingTree).addDirectCallTarget(theFunction);
                theFunction.setIsTargetOfDirectCall();
            }
        }
    }

    void collectContainedFunctions(Node node) {
        Node tNode = node;
        while (tNode != null) {
            FunctionNode fnNode;
            if (tNode.getType() == 110 && (fnNode = (FunctionNode)tNode.getProp(5)).getFunctionName().length() != 0) {
                String name = fnNode.getFunctionName();
                Object oldFn = this.theFnClassNameList.get(name);
                if (oldFn == fnNode) {
                    return;
                }
                this.theFnClassNameList.put(name, fnNode);
            }
            tNode = tNode.getNext();
        }
    }
}

