/*
 * Decompiled with CFR 0.152.
 */
package imagelib.io;

import imagelib.io.ImageHeader;

public class ImageData {
    protected int width;
    protected int height;
    protected int pixelSize;
    protected int maxPixelValue = Integer.MIN_VALUE;
    protected int minPixelValue = Integer.MAX_VALUE;
    protected ImageHeader header;
    protected int[] rawData;

    public ImageData(int[] rawData, int width, int height) {
        this.rawData = rawData;
        this.width = width;
        this.height = height;
    }

    public void setWidth(int newWidth) {
        this.width = newWidth;
    }

    public void setHeight(int newHeight) {
        this.height = newHeight;
    }

    public void setMaxPixelValue(int newMaxPixelValue) {
        this.maxPixelValue = newMaxPixelValue;
    }

    public void setMinPixelValue(int newMinPixelValue) {
        this.minPixelValue = newMinPixelValue;
    }

    public void setPixelSize(int newPixelSize) {
        this.pixelSize = newPixelSize;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaxPixelValue() {
        return this.maxPixelValue;
    }

    public int getMinPixelValue() {
        return this.minPixelValue;
    }

    public int getPixelSize() {
        return this.pixelSize;
    }

    public int[] getRawData() {
        return this.rawData;
    }

    public void scale4GrayScale() {
        if (this.getMaxPixelValue() > 255) {
            double scaleFactor = 257.00392156862745;
            int i = 0;
            while (i < this.rawData.length) {
                this.rawData[i] = (int)((double)this.rawData[i] / scaleFactor);
                ++i;
            }
        }
    }

    public byte[] toByte() {
        byte[] data = new byte[this.rawData.length];
        int i = 0;
        while (i < this.rawData.length) {
            data[i] = (byte)this.rawData[i];
            ++i;
        }
        return data;
    }

    public short[] toShort() {
        short s;
        short s2;
        short[] data = new short[this.rawData.length];
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.rawData.length) {
            data[i] = (short)this.rawData[i];
            if (data[i] > s2) {
                s2 = data[i];
            }
            if (data[i] < s) {
                s = data[i];
            }
            ++i;
        }
        System.out.println("min:" + s + "  max:" + s2);
        return data;
    }
}

