/*
 * Decompiled with CFR 0.152.
 */
package imagelib.io;

import imagelib.io.SegmentedImageData;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;

public class SegmentedImageReader {
    public boolean canRead(String filename) {
        File f = new File(filename);
        if (!f.exists() || !f.isFile()) {
            return false;
        }
        return filename.toLowerCase().endsWith(".seg");
    }

    public SegmentedImageData load(String inFile) throws IOException {
        System.out.println("loading file " + inFile);
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(inFile), 4096));
            int noClass = ((DataInputStream)in).readInt();
            int width = ((DataInputStream)in).readInt();
            int height = ((DataInputStream)in).readInt();
            float[][] rawData = new float[height * width][noClass];
            SegmentedImageData imgData = new SegmentedImageData(noClass, width, height, rawData);
            int i = 0;
            while (i < rawData.length) {
                int j = 0;
                while (j < noClass) {
                    rawData[i][j] = ((DataInputStream)in).readFloat();
                    ++j;
                }
                ++i;
            }
            SegmentedImageData segmentedImageData = imgData;
            return segmentedImageData;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

