/*
 * Decompiled with CFR 0.152.
 */
package imagelib.io.dicom;

import imagelib.io.dicom.DICOMDataElement;
import imagelib.io.dicom.DICOMDictionary;
import imagelib.io.dicom.Util;
import imagelib.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DICOMDecoder {
    private static final int PIXEL_REPRESENTATION = 2621699;
    private static final int TRANSFER_SYNTAX_UID = 131088;
    private static final int SLICE_SPACING = 0x180088;
    private static final int SAMPLES_PER_PIXEL = 0x280002;
    private static final int PHOTOMETRIC_INTERPRETATION = 2621444;
    private static final int PLANAR_CONFIGURATION = 2621446;
    private static final int NUMBER_OF_FRAMES = 0x280008;
    private static final int ROWS = 2621456;
    private static final int COLUMNS = 2621457;
    private static final int PIXEL_SPACING = 2621488;
    private static final int BITS_ALLOCATED = 2621696;
    private static final int WINDOW_CENTER = 2625616;
    private static final int WINDOW_WIDTH = 2625617;
    private static final int RED_PALETTE = 2626049;
    private static final int GREEN_PALETTE = 2626050;
    private static final int BLUE_PALETTE = 2626051;
    private static final int PIXEL_DATA = 2145386512;
    private static final int AE = 16709;
    private static final int AS = 16723;
    private static final int AT = 16724;
    private static final int CS = 17235;
    private static final int DA = 17473;
    private static final int DS = 17491;
    private static final int DT = 17492;
    private static final int FD = 17988;
    private static final int FL = 17996;
    private static final int IS = 18771;
    private static final int LO = 19535;
    private static final int LT = 19540;
    private static final int PN = 20558;
    private static final int SH = 21320;
    private static final int SL = 21324;
    private static final int SS = 21331;
    private static final int ST = 21332;
    private static final int TM = 21581;
    private static final int UI = 21833;
    private static final int UL = 21836;
    private static final int US = 21843;
    private static final int UT = 21844;
    private static final int OB = 20290;
    private static final int OW = 20311;
    private static final int SQ = 21329;
    private static final int UN = 21838;
    private static final int QQ = 16191;
    private static Properties dictionary;
    private String directory;
    private String fileName;
    private static final int ID_OFFSET = 128;
    private static final String DICM = "DICM";
    private int location = 0;
    private boolean littleEndian = true;
    private int elementLength;
    private int vr;
    private static final int IMPLICIT_VR = 11565;
    private byte[] vrLetters = new byte[2];
    private int previousGroup;
    private StringBuffer dicomInfo = new StringBuffer(1000);
    private boolean dicmFound;
    private boolean oddLocations;
    private boolean bigEndianTransferSyntax = false;
    private double windowCenter;
    private double windowWidth;
    private BufferedInputStream in = null;
    private boolean transferAllFields = true;
    private DataElementHelper deHelper;
    static final boolean DEBUG = false;
    static final boolean ADD_DICOM_FileMeta_Information = false;
    public static int bytes_Read;
    public static final char[] hexDigits;
    static char[] buf8;
    char[] buf10;

    static {
        bytes_Read = 0;
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        buf8 = new char[8];
    }

    public DICOMDecoder(String fileName) {
        this.fileName = fileName;
        if (dictionary == null) {
            dictionary = DICOMDictionary.getDictionary();
        }
    }

    public static String getMagicString(InputStream in, int length) throws IOException {
        byte[] buf = new byte[length];
        int pos = 0;
        while (pos < length) {
            int count = in.read(buf, pos, length - pos);
            pos += count;
        }
        return new String(buf);
    }

    String getString(int length) throws IOException {
        byte[] buf = new byte[length];
        int pos = 0;
        while (pos < length) {
            int count = this.in.read(buf, pos, length - pos);
            pos += count;
        }
        this.location += length;
        return new String(buf);
    }

    int getByte() throws IOException {
        int b = this.in.read();
        if (b == -1) {
            throw new IOException("unexpected EOF");
        }
        ++this.location;
        return b;
    }

    int getShort() throws IOException {
        return this.getShort(null);
    }

    int getShort(int[] buf) throws IOException {
        int b0 = this.getByte();
        int b1 = this.getByte();
        bytes_Read += 2;
        if (buf != null) {
            buf[0] = b0;
            buf[1] = b1;
        }
        if (this.littleEndian) {
            return (b1 << 8) + b0;
        }
        return (b0 << 8) + b1;
    }

    protected long getUInt() throws IOException {
        return this.getUInt(null);
    }

    protected long getUInt(int[] buf) throws IOException {
        int b0 = this.getByte();
        int b1 = this.getByte();
        int b2 = this.getByte();
        int b3 = this.getByte();
        bytes_Read += 4;
        if (buf != null) {
            buf[0] = b0;
            buf[1] = b1;
            buf[2] = b2;
            buf[3] = b3;
        }
        if (this.littleEndian) {
            return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
        }
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }

    final int getInt(int[] buf) throws IOException {
        int b0 = this.getByte();
        int b1 = this.getByte();
        int b2 = this.getByte();
        int b3 = this.getByte();
        bytes_Read += 4;
        if (buf != null) {
            buf[0] = b0;
            buf[1] = b1;
            buf[2] = b2;
            buf[3] = b3;
        }
        if (this.littleEndian) {
            return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
        }
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }

    final int getInt() throws IOException {
        return this.getInt(null);
    }

    byte[] getLut(int length) throws IOException {
        if ((length & 1) != 0) {
            String dummy = this.getString(length);
            return null;
        }
        byte[] lut = new byte[length /= 2];
        int i = 0;
        while (i < length) {
            lut[i] = (byte)(this.getShort() >>> 8);
            ++i;
        }
        return lut;
    }

    int getLength() throws IOException {
        return this.getLength(null);
    }

    int getLength(RawData rawData) throws IOException {
        int b0 = this.getByte();
        int b1 = this.getByte();
        int b2 = this.getByte();
        int b3 = this.getByte();
        bytes_Read += 4;
        if (rawData != null) {
            rawData.buf[0] = b0;
            rawData.buf[1] = b1;
            rawData.buf[2] = b2;
            rawData.buf[3] = b3;
            rawData.used = 4;
        }
        this.vr = (b0 << 8) + b1;
        if (rawData != null) {
            rawData.vr = this.vr;
        }
        int len = -1;
        switch (this.vr) {
            case 20290: 
            case 20311: 
            case 21329: 
            case 21838: {
                if (b2 == 0 || b3 == 0) {
                    if (rawData != null) {
                        int[] buf = new int[4];
                        len = this.getInt(buf);
                        int i = 0;
                        while (i < buf.length) {
                            rawData.buf[rawData.used++] = buf[i];
                            ++i;
                        }
                        rawData.explicit = true;
                        rawData.length = len;
                        return len;
                    }
                    return this.getInt();
                }
                this.vr = 11565;
                len = this.littleEndian ? (b3 << 24) + (b2 << 16) + (b1 << 8) + b0 : (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
                if (rawData != null) {
                    rawData.vr = 11565;
                    rawData.explicit = false;
                    rawData.length = len;
                }
                return len;
            }
            case 16191: 
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 17988: 
            case 17996: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21324: 
            case 21331: 
            case 21332: 
            case 21581: 
            case 21833: 
            case 21836: 
            case 21843: 
            case 21844: {
                len = this.littleEndian ? (b3 << 8) + b2 : (b2 << 8) + b3;
                if (rawData != null) {
                    rawData.explicit = true;
                    rawData.length = len;
                }
                return len;
            }
        }
        this.vr = 11565;
        len = this.littleEndian ? (b3 << 24) + (b2 << 16) + (b1 << 8) + b0 : (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
        if (rawData != null) {
            rawData.vr = 11565;
            rawData.explicit = false;
            rawData.length = len;
        }
        return len;
    }

    protected static int writeLength(int length, BufferedOutputStream out, int vr, boolean littleEndian, boolean implicitVR) throws IOException {
        return 4;
    }

    int getNextTag() throws IOException {
        return this.getNextTag(null);
    }

    int getNextTag(RawData rawData) throws IOException {
        int groupWord = -1;
        if (rawData != null) {
            int[] sbuf = new int[2];
            groupWord = this.getShort(sbuf);
            System.arraycopy(sbuf, 0, rawData.buf, 0, sbuf.length);
            rawData.used = sbuf.length;
        } else {
            groupWord = this.getShort();
        }
        if (groupWord == 2048 && this.bigEndianTransferSyntax) {
            this.littleEndian = false;
            groupWord = 8;
        }
        int elementWord = -1;
        if (rawData != null) {
            int[] sbuf = new int[2];
            elementWord = this.getShort(sbuf);
            System.arraycopy(sbuf, 0, rawData.buf, 2, sbuf.length);
            rawData.used += sbuf.length;
        } else {
            elementWord = this.getShort();
        }
        int tag = groupWord << 16 | elementWord;
        if (rawData != null) {
            RawData rd = new RawData(8);
            this.elementLength = this.getLength(rd);
            int[] sbuf = rd.getUsedPart();
            System.arraycopy(sbuf, 0, rawData.buf, rawData.used, sbuf.length);
            rawData.used += rd.used;
        } else {
            this.elementLength = this.getLength();
        }
        if (this.elementLength == 13 && !this.oddLocations) {
            this.elementLength = 10;
        }
        if (this.elementLength == -1) {
            this.elementLength = 0;
        }
        if (rawData != null) {
            rawData.tag = tag;
        }
        return tag;
    }

    void addInfo(int tag, String value, DICOMDataElement dde) throws IOException {
        String info = this.getHeaderInfo(tag, value, dde);
        if (info != null) {
            int group = tag >>> 16;
            if (group != this.previousGroup) {
                this.dicomInfo.append("\n");
            }
            this.previousGroup = group;
            this.dicomInfo.append(String.valueOf(this.tag2hex(tag)) + info + "\n");
        }
    }

    void addInfo(int tag, int value, DICOMDataElement dde) throws IOException {
        this.addInfo(tag, Integer.toString(value), dde);
    }

    String getHeaderInfo(int tag, String value, DICOMDataElement dde) throws IOException {
        String key = this.i2hex(tag);
        String id = (String)dictionary.get(key);
        if (id != null) {
            if (this.vr == 11565 && id != null) {
                this.vr = (id.charAt(0) << 8) + id.charAt(1);
            }
            id = id.substring(2);
        }
        if (value != null) {
            return String.valueOf(id) + ": " + value;
        }
        switch (this.vr) {
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21332: 
            case 21581: 
            case 21833: {
                value = this.getString(this.elementLength);
                break;
            }
            case 21843: {
                if (this.elementLength == 2) {
                    value = Integer.toString(this.getShort());
                    break;
                }
                value = "";
                int n = this.elementLength / 2;
                int i = 0;
                while (i < n) {
                    value = String.valueOf(value) + Integer.toString(this.getShort()) + " ";
                    ++i;
                }
                break;
            }
            default: {
                long skipCount = this.elementLength;
                while (skipCount > 0L) {
                    skipCount -= this.in.skip(skipCount);
                }
                this.location += this.elementLength;
                value = "";
            }
        }
        if (id == null) {
            return "(key:" + key + ")";
        }
        dde.setName(id);
        dde.setValue(value);
        return String.valueOf(id) + ": " + value;
    }

    String i2hex(int i) {
        int pos = 7;
        while (pos >= 0) {
            DICOMDecoder.buf8[pos] = hexDigits[i & 0xF];
            i >>>= 4;
            --pos;
        }
        return new String(buf8);
    }

    String tag2hex(int tag) {
        if (this.buf10 == null) {
            this.buf10 = new char[11];
            this.buf10[4] = 44;
            this.buf10[9] = 32;
        }
        int pos = 8;
        while (pos >= 0) {
            this.buf10[pos] = hexDigits[tag & 0xF];
            tag >>>= 4;
            if (--pos != 4) continue;
            --pos;
        }
        return new String(this.buf10);
    }

    double s2d(String s) {
        Double d;
        try {
            d = new Double(s);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    boolean dicmFound() {
        return this.dicmFound;
    }

    /*
     * Loose catch block
     */
    public static boolean isDICOMFile(String file) {
        BufferedInputStream bin;
        block5: {
            bin = null;
            try {
                bin = new BufferedInputStream(new FileInputStream(file));
                long skipCount = 128L;
                while (skipCount > 0L) {
                    skipCount -= bin.skip(skipCount);
                }
                if (!DICOMDecoder.getMagicString(bin, 4).equals(DICM)) break block5;
            }
            catch (IOException ex) {
                Utils.close(bin);
                return false;
                catch (Throwable throwable) {
                    Utils.close(bin);
                    throw throwable;
                }
            }
            Utils.close(bin);
            return true;
        }
        Utils.close(bin);
        return false;
    }

    public long getImageDataStartPos(String dcmFile, Map<String, DICOMDataElement> ddeMap) throws IOException {
        try {
            this.in = new BufferedInputStream(new FileInputStream(dcmFile));
            long skipCount = 128L;
            this.location = 0;
            while (skipCount > 0L) {
                skipCount -= this.in.skip(skipCount);
            }
            this.location += 128;
            if (!this.getString(4).equals(DICM)) {
                this.in.close();
                this.in = new BufferedInputStream(new FileInputStream(this.fileName));
                this.location = 0;
            }
            DICOMDataElement dde = null;
            boolean finished = false;
            while (!finished) {
                int tag = this.getNextTag();
                dde = new DICOMDataElement();
                if ((this.location & 1) != 0) {
                    this.oddLocations = true;
                }
                String tagInfo = this.getHeaderInfo(tag, null, dde);
                ddeMap.put(dde.getName(), dde);
                if (tag != 2145386512) continue;
                finished = true;
                long l = this.location;
                return l;
            }
        }
        finally {
            Utils.close(this.in);
        }
        return -1L;
    }

    private int getIntDDEValue(Map<String, DICOMDataElement> ddeMap, String name) {
        DICOMDataElement dde = ddeMap.get(name);
        return Integer.parseInt(dde.getValue());
    }

    public List<DICOMDataElement> extractHeader() throws IOException {
        LinkedList<DICOMDataElement> ddeList = new LinkedList<DICOMDataElement>();
        long skipCount = 0L;
        try {
            this.in = new BufferedInputStream(new FileInputStream(this.fileName));
            skipCount = 128L;
            while (skipCount > 0L) {
                skipCount -= this.in.skip(skipCount);
            }
            this.location += 128;
            if (!this.getString(4).equals(DICM)) {
                this.in.close();
                this.in = new BufferedInputStream(new FileInputStream(this.fileName));
                this.location = 0;
            }
            DICOMDataElement dde = null;
            boolean finished = false;
            while (!finished) {
                int tag = this.getNextTag();
                dde = new DICOMDataElement();
                ddeList.add(dde);
                if ((this.location & 1) != 0) {
                    this.oddLocations = true;
                }
                String tagInfo = this.getHeaderInfo(tag, null, dde);
                if (tag != 2145386512) continue;
                finished = true;
            }
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Exception exception) {}
            }
        }
        return ddeList;
    }

    protected void addDICOMFileMetaInformation(BufferedOutputStream out) throws IOException {
        byte[] buf = new byte[128];
        int i = 0;
        while (i < buf.length) {
            buf[i] = 0;
            ++i;
        }
        out.write(buf);
        String prefix = DICM;
        buf = prefix.getBytes("US-ASCII");
        out.write(buf);
    }

    public void updateHeader(List<DICOMDataElement> dataElements, String newFileName) throws IOException {
        long skipCount = 0L;
        this.in = new BufferedInputStream(new FileInputStream(this.fileName));
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(newFileName));
            skipCount = 128L;
            byte[] buf = new byte[128];
            int offset = 0;
            while (skipCount > 0L) {
                int readBytes;
                offset = readBytes = this.in.read(buf, offset, (int)skipCount);
                skipCount -= (long)readBytes;
            }
            this.location += 128;
            if (!this.getString(4).equals(DICM)) {
                this.in.close();
                this.in = new BufferedInputStream(new FileInputStream(this.fileName));
                this.location = 0;
                buf = null;
            }
            if (buf != null) {
                out.write(buf);
                out.write(DICM.getBytes());
            }
            this.deHelper = new DataElementHelper(dataElements);
            Map<String, DICOMDataElement> ddeMap = this.deHelper.getDDEMap();
            boolean finished = false;
            RawData rawData = new RawData(12);
            while (!finished) {
                int tag = this.getNextTag(rawData);
                if ((this.location & 1) != 0) {
                    this.oddLocations = true;
                }
                String tagInfo = this.getHeaderInfo(tag, null, (BufferedOutputStream)out, ddeMap, rawData);
                Util.dumpOffsets("TAG", this.location);
                if (tag != 2145386512) continue;
                finished = true;
            }
            buf = new byte[4096];
            int readBytes = -1;
            while ((readBytes = this.in.read(buf, 0, buf.length)) >= 0) {
                Util.writeBytes(buf, (BufferedOutputStream)out);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected boolean isTagToBeRemoved(DICOMDataElement dde) {
        boolean b;
        boolean bl = b = dde != null && dde.getAction() == 1;
        if (!this.transferAllFields) {
            boolean bl2 = b = dde == null;
        }
        if (b) {
            System.out.println("To be removed:" + dde.toString());
        }
        return b;
    }

    protected String getHeaderInfo(int tag, String value, BufferedOutputStream out, Map<String, DICOMDataElement> ddeMap, RawData rawData) throws IOException {
        String key = this.i2hex(tag);
        String id = (String)dictionary.get(key);
        DICOMDataElement dde = ddeMap.get(key);
        if (id != null) {
            if (this.vr == 11565 && id != null) {
                this.vr = (id.charAt(0) << 8) + id.charAt(1);
            }
            id = id.substring(2);
        }
        if (value != null) {
            return String.valueOf(id) + ": " + value;
        }
        DICOMDataElement ddeToInsert = this.deHelper.getDataElementToInsert(tag);
        if (ddeToInsert != null) {
            this.deHelper.write(ddeToInsert, this.littleEndian, out);
            Util.dumpOffsets("After write", this.location);
        }
        switch (this.vr) {
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21332: 
            case 21581: 
            case 21833: {
                if (!this.isTagToBeRemoved(dde)) {
                    Util.writeBytes(rawData.buf, 4, out);
                }
                Util.dumpOffsets("1", this.location);
                value = this.getString(this.elementLength);
                if (dde != null && !this.isTagToBeRemoved(dde)) {
                    int len = dde.getValue().length();
                    String valueStr = dde.getValue();
                    if (len % 2 != 0) {
                        valueStr = String.valueOf(valueStr) + " ";
                        ++len;
                    }
                    Util.writeVRAndLength(rawData.vr, len, rawData.explicit, this.littleEndian, out);
                    Util.writeString(valueStr, out);
                    Util.dumpOffsets("2", this.location);
                    break;
                }
                if (dde != null) break;
                Util.writeVRAndLength(rawData.vr, this.elementLength, rawData.explicit, this.littleEndian, out);
                Util.writeString(value, out);
                break;
            }
            case 21843: {
                if (this.elementLength == 2) {
                    if (dde == null) {
                        Util.writeBytes(rawData.buf, 4, out);
                        Util.writeVRAndLength(rawData.vr, this.elementLength, rawData.explicit, this.littleEndian, out);
                    }
                    value = Integer.toString(this.getShort());
                    if (dde != null && !this.isTagToBeRemoved(dde)) {
                        System.out.println("dde=" + dde);
                        Util.writeShort(Integer.parseInt(dde.getValue()), out, this.littleEndian);
                        break;
                    }
                    if (dde != null) break;
                    Util.writeShort(Integer.parseInt(value), out, this.littleEndian);
                    break;
                }
                value = "";
                int n = this.elementLength / 2;
                int i = 0;
                while (i < n) {
                    value = String.valueOf(value) + Integer.toString(this.getShort()) + " ";
                    ++i;
                }
                break;
            }
            case 21836: {
                if (this.elementLength == 4) {
                    if (!this.isTagToBeRemoved(dde)) {
                        Util.writeBytes(rawData.buf, 4, out);
                        Util.writeVRAndLength(rawData.vr, this.elementLength, rawData.explicit, this.littleEndian, out);
                    }
                    value = Long.toString(this.getUInt());
                    if (dde != null && !this.isTagToBeRemoved(dde)) {
                        Util.writeUInt(Long.parseLong(dde.getValue()), out, this.littleEndian);
                        break;
                    }
                    if (dde != null) break;
                    Util.writeUInt(Long.parseLong(value), out, this.littleEndian);
                    break;
                }
                throw new UnsupportedOperationException("element length must be 4 for UL!");
            }
            default: {
                int[] ibuf = rawData.getUsedPart();
                int i = 0;
                while (i < ibuf.length) {
                    Util.writeByte(ibuf[i], out);
                    ++i;
                }
                int skipCount = this.elementLength;
                byte[] buf = new byte[skipCount];
                int offset = 0;
                while (skipCount > 0) {
                    int readBytes;
                    offset = readBytes = this.in.read(buf, offset, skipCount);
                    skipCount -= readBytes;
                }
                out.write(buf);
                Util.bytesWritten += buf.length;
                this.location += this.elementLength;
                value = "";
            }
        }
        if (id == null) {
            return "(key:" + key + ")";
        }
        return String.valueOf(id) + ": " + value;
    }

    public static void main(String[] args) {
        String filename = "/home/bozyurt/dev/java/upload/conf/22943124.dcm";
        try {
            DICOMDecoder dd = new DICOMDecoder(filename);
            dd.extractHeader();
            LinkedList<DICOMDataElement> dataElements = new LinkedList<DICOMDataElement>();
            dataElements.add(new DICOMDataElement("Slice Thickness", "1.5000000"));
            dataElements.add(new DICOMDataElement("Window Width", "0"));
            dd.updateHeader(dataElements, "/home/bozyurt/dev/java/upload/conf/test.dcm");
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static class DataElementHelper {
        List<DICOMDataElement> dataElements;
        Map<String, DICOMDataElement> ddeMap;
        DICOMDataElement currentDDE = null;
        Iterator<DICOMDataElement> iterator = null;
        Map<String, String> vrMap = null;

        public DataElementHelper(List<DICOMDataElement> dataElements) {
            this.dataElements = dataElements;
            Properties idictionary = DICOMDictionary.getInvertedDictionary();
            this.ddeMap = new HashMap<String, DICOMDataElement>();
            for (DICOMDataElement dde : dataElements) {
                String key = (String)idictionary.get(dde.getName());
                if (key == null) continue;
                this.ddeMap.put(key, dde);
            }
            if (!dataElements.isEmpty()) {
                DICOMDataElement dde;
                this.iterator = dataElements.iterator();
                dde = null;
                while (this.iterator.hasNext()) {
                    dde = this.iterator.next();
                    if (dde.getAction() != 2) continue;
                    this.currentDDE = dde;
                    break;
                }
            }
        }

        public Map<String, DICOMDataElement> getDDEMap() {
            return this.ddeMap;
        }

        public DICOMDataElement getDataElementToInsert(int tag) {
            if (this.currentDDE == null) {
                return null;
            }
            System.out.println(">> " + Util.int2Hex(this.currentDDE.getTag()));
            if (Util.tagCompare(this.currentDDE.getTag(), tag) > 0) {
                DICOMDataElement dde = this.currentDDE;
                this.currentDDE = null;
                DICOMDataElement d = null;
                while (this.iterator.hasNext()) {
                    d = this.iterator.next();
                    if (d.getAction() != 2) continue;
                    this.currentDDE = d;
                    break;
                }
                return dde;
            }
            return null;
        }

        public void write(DICOMDataElement dde, boolean littleEndian, BufferedOutputStream out) throws IOException {
            String vrStr;
            System.out.println(">> WRITING new tag " + dde.getName());
            if (this.vrMap == null) {
                this.vrMap = DICOMDictionary.getNameToVRMap();
            }
            if ((vrStr = this.vrMap.get(dde.getName())) == null) {
                throw new RuntimeException("vr cannot be null!");
            }
            int vr = (vrStr.charAt(0) << 8) + vrStr.charAt(1);
            int length = -1;
            switch (vr) {
                case 21324: 
                case 21836: {
                    length = 4;
                    break;
                }
                case 21331: 
                case 21843: {
                    length = 2;
                    break;
                }
                case 17235: 
                case 17473: 
                case 17491: 
                case 18771: 
                case 19535: 
                case 19540: 
                case 20558: 
                case 21320: 
                case 21833: {
                    length = dde.getValue().length();
                    if (length % 2 == 0) break;
                    dde.setValue(String.valueOf(dde.getValue()) + " ");
                    ++length;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported value representation!");
                }
            }
            Util.writeDICOMTag(dde.getTag(), out);
            Util.writeVRAndLength(dde.isImplicitVR() ? 11565 : vr, length, dde.isImplicitVR(), littleEndian, out);
            Util.writeDICOMHeaderValue(out, dde.getValue(), vr, length, littleEndian);
        }
    }

    class RawData {
        int[] buf;
        int used;
        int tag;
        int length;
        int vr;
        boolean explicit;

        public RawData() {
            this(-1);
        }

        public RawData(int size) {
            if (size > 0) {
                this.buf = new int[size];
            }
        }

        int[] getUsedPart() {
            if (this.used < this.buf.length) {
                int[] b = new int[this.used];
                System.arraycopy(this.buf, 0, b, 0, this.used);
                return b;
            }
            return this.buf;
        }
    }
}

