/*
 * Decompiled with CFR 0.152.
 */
package imagelib.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class Utils {
    private Utils() {
    }

    public static String getHomeDir() {
        return System.getProperty("user.home");
    }

    public static File[] getDirContents(String dirPath) {
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            return null;
        }
        return dir.listFiles();
    }

    public static Properties loadProperties(String propsFilename) {
        Properties props = null;
        InputStream is = Utils.class.getResourceAsStream("/" + propsFilename);
        props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException iox) {
            iox.printStackTrace();
            return null;
        }
        return props;
    }

    public static void storeProperties(String propsFilename, Properties props) throws IOException {
        URL url = Utils.class.getResource("/" + propsFilename);
        String path = url.getPath();
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(path));
            props.store(out, null);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String[] getPropList(String property, Properties props) {
        String value;
        LinkedList<String> list = new LinkedList<String>();
        int idx = 0;
        while ((value = props.getProperty(String.valueOf(property) + "." + idx++)) != null) {
            list.add(value);
        }
        if (!list.isEmpty()) {
            String[] slist = new String[list.size()];
            idx = 0;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                slist[idx++] = (String)it.next();
            }
            return slist;
        }
        return null;
    }

    public static int swapFirst2Bytes(int num) {
        int x = num & 0xFF;
        x <<= 8;
        return x += (num & 0xFF00) >> 8;
    }

    public static String getBasename(String filename) {
        File f = new File(filename);
        String name = f.getName();
        int idx = name.lastIndexOf(46);
        if (idx != -1) {
            name = name.substring(0, idx);
        }
        return name;
    }

    public static void serialize(Object o, String filename) throws IOException {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(filename), 4096));
            out.writeObject(o);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Object deserialize(String filename) throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        try {
            Object o;
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(filename), 4096));
            Object object = o = in.readObject();
            return object;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(">> " + Utils.swapFirst2Bytes(65535));
    }
}

