/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.oracle;

import clinical.server.utils.OracleUtils;
import clinical.server.vo.Analysisresult;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.sql.CLOB;

public class AnalysisresultDAO
implements clinical.server.dao.AnalysisresultDAO {
    @Override
    public void insert(Connection con, Analysisresult bean) throws Exception {
        Statement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO NC_ANALYSISRESULT ");
            buf.append(" (UNIQUEID,TABLEID,SEGMENTID,COMPONENTID,EXPERIMENTID,SUBJECTID,EXECUTEDTRANSFORMID,ANALYSISID,ANALYSISNAME,DESCRIPTION,OWNER,MODTIME,MODUSER,ONTOLOGYSOURCE,CONCEPTID,ISBAD,GROUPNAME,GROUPLONGNAME,GROUPONTOLOGYSOURCE,GROUPCONCEPTID) ");
            buf.append("VALUES ");
            buf.append('(');
            int i = 0;
            while (i < 20) {
                buf.append('?');
                if (i < 19) {
                    buf.append(',');
                }
                ++i;
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, bean.getUniqueid(), 2);
            ps.setObject(2, bean.getTableid(), 2);
            ps.setObject(3, bean.getSegmentid(), 2);
            ps.setObject(4, bean.getComponentid(), 2);
            ps.setObject(5, bean.getExperimentid(), 2);
            ps.setObject(6, bean.getSubjectid(), 12);
            ps.setObject(7, bean.getExecutedtransformid(), 2);
            ps.setObject(8, bean.getAnalysisid(), 2);
            ps.setObject(9, bean.getAnalysisname(), 12);
            ps.setObject(10, OracleUtils.getCLOB(con, bean.getDescription()), 2005);
            ps.setObject(11, bean.getOwner(), 2);
            ps.setTimestamp(12, bean.getModtime() == null ? null : new Timestamp(bean.getModtime().getTime()));
            ps.setObject(13, bean.getModuser(), 2);
            ps.setObject(14, bean.getOntologysource(), 12);
            ps.setObject(15, bean.getConceptid(), 12);
            ps.setObject(16, this.boolean2Number(bean.getIsbad()), 2);
            ps.setObject(17, bean.getGroupname(), 12);
            ps.setObject(18, bean.getGrouplongname(), 12);
            ps.setObject(19, bean.getGroupontologysource(), 12);
            ps.setObject(20, bean.getGroupconceptid(), 12);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String prepareColList(Analysisresult bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("UNIQUEID");
        buf.append(',');
        buf.append("TABLEID");
        buf.append(',');
        buf.append("SEGMENTID");
        buf.append(',');
        buf.append("COMPONENTID");
        buf.append(',');
        buf.append("EXPERIMENTID");
        buf.append(',');
        buf.append("SUBJECTID");
        buf.append(',');
        buf.append("EXECUTEDTRANSFORMID");
        buf.append(',');
        buf.append("ANALYSISID");
        buf.append(',');
        buf.append("ANALYSISNAME");
        buf.append(',');
        buf.append("DESCRIPTION");
        buf.append(',');
        buf.append("OWNER");
        buf.append(',');
        buf.append("MODTIME");
        buf.append(',');
        buf.append("MODUSER");
        buf.append(',');
        buf.append("ONTOLOGYSOURCE");
        buf.append(',');
        buf.append("CONCEPTID");
        buf.append(',');
        buf.append("ISBAD");
        buf.append(',');
        buf.append("GROUPNAME");
        buf.append(',');
        buf.append("GROUPLONGNAME");
        buf.append(',');
        buf.append("GROUPONTOLOGYSOURCE");
        buf.append(',');
        buf.append("GROUPCONCEPTID");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(Analysisresult bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getUniqueid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("UNIQUEID=?");
            qi.values.add(bean.getUniqueid());
            valueSet = true;
        }
        if (bean.getTableid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TABLEID=?");
            qi.values.add(bean.getTableid());
            valueSet = true;
        }
        if (bean.getSegmentid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("SEGMENTID=?");
            qi.values.add(bean.getSegmentid());
            valueSet = true;
        }
        if (bean.getComponentid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("COMPONENTID=?");
            qi.values.add(bean.getComponentid());
            valueSet = true;
        }
        if (bean.getExperimentid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("EXPERIMENTID=?");
            qi.values.add(bean.getExperimentid());
            valueSet = true;
        }
        if (bean.getSubjectid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("SUBJECTID=?");
            qi.values.add(bean.getSubjectid());
            valueSet = true;
        }
        if (bean.getExecutedtransformid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("EXECUTEDTRANSFORMID=?");
            qi.values.add(bean.getExecutedtransformid());
            valueSet = true;
        }
        if (bean.getAnalysisid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("ANALYSISID=?");
            qi.values.add(bean.getAnalysisid());
            valueSet = true;
        }
        if (bean.getAnalysisname() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("ANALYSISNAME=?");
            qi.values.add(bean.getAnalysisname());
            valueSet = true;
        }
        if (bean.getDescription() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DESCRIPTION=?");
            qi.values.add(bean.getDescription());
            valueSet = true;
        }
        if (bean.getOwner() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("OWNER=?");
            qi.values.add(bean.getOwner());
            valueSet = true;
        }
        if (bean.getModtime() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODTIME=?");
            qi.values.add(new Timestamp(bean.getModtime().getTime()));
            valueSet = true;
        }
        if (bean.getModuser() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODUSER=?");
            qi.values.add(bean.getModuser());
            valueSet = true;
        }
        if (bean.getOntologysource() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("ONTOLOGYSOURCE=?");
            qi.values.add(bean.getOntologysource());
            valueSet = true;
        }
        if (bean.getConceptid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("CONCEPTID=?");
            qi.values.add(bean.getConceptid());
            valueSet = true;
        }
        if (bean.getIsbad() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("ISBAD=?");
            qi.values.add(this.boolean2Number(bean.getIsbad()));
            valueSet = true;
        }
        if (bean.getGroupname() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("GROUPNAME=?");
            qi.values.add(bean.getGroupname());
            valueSet = true;
        }
        if (bean.getGrouplongname() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("GROUPLONGNAME=?");
            qi.values.add(bean.getGrouplongname());
            valueSet = true;
        }
        if (bean.getGroupontologysource() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("GROUPONTOLOGYSOURCE=?");
            qi.values.add(bean.getGroupontologysource());
            valueSet = true;
        }
        if (bean.getGroupconceptid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("GROUPCONCEPTID=?");
            qi.values.add(bean.getGroupconceptid());
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(Analysisresult bean, Analysisresult criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE NC_ANALYSISRESULT SET ");
        if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("UNIQUEID=? ");
            uqi.setValues.add(bean.getUniqueid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
            valueSet = true;
        }
        if (bean.getTableid() != null || bean.isNull("tableid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TABLEID=? ");
            uqi.setValues.add(bean.getTableid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("tableid"), uqi);
            valueSet = true;
        }
        if (bean.getSegmentid() != null || bean.isNull("segmentid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("SEGMENTID=? ");
            uqi.setValues.add(bean.getSegmentid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("segmentid"), uqi);
            valueSet = true;
        }
        if (bean.getComponentid() != null || bean.isNull("componentid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("COMPONENTID=? ");
            uqi.setValues.add(bean.getComponentid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("componentid"), uqi);
            valueSet = true;
        }
        if (bean.getExperimentid() != null || bean.isNull("experimentid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("EXPERIMENTID=? ");
            uqi.setValues.add(bean.getExperimentid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("experimentid"), uqi);
            valueSet = true;
        }
        if (bean.getSubjectid() != null || bean.isNull("subjectid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("SUBJECTID=? ");
            uqi.setValues.add(bean.getSubjectid());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("subjectid"), uqi);
            valueSet = true;
        }
        if (bean.getExecutedtransformid() != null || bean.isNull("executedtransformid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("EXECUTEDTRANSFORMID=? ");
            uqi.setValues.add(bean.getExecutedtransformid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("executedtransformid"), uqi);
            valueSet = true;
        }
        if (bean.getAnalysisid() != null || bean.isNull("analysisid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("ANALYSISID=? ");
            uqi.setValues.add(bean.getAnalysisid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("analysisid"), uqi);
            valueSet = true;
        }
        if (bean.getAnalysisname() != null || bean.isNull("analysisname")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("ANALYSISNAME=? ");
            uqi.setValues.add(bean.getAnalysisname());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("analysisname"), uqi);
            valueSet = true;
        }
        if (bean.getDescription() != null || bean.isNull("description")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DESCRIPTION=? ");
            uqi.setValues.add(bean.getDescription());
            uqi.sqlTypes.add(new Integer(2005));
            this.prepareNullSetListValue(bean.isNull("description"), uqi);
            valueSet = true;
        }
        if (bean.getOwner() != null || bean.isNull("owner")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("OWNER=? ");
            uqi.setValues.add(bean.getOwner());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("owner"), uqi);
            valueSet = true;
        }
        if (bean.getModtime() != null || bean.isNull("modtime")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODTIME=? ");
            uqi.setValues.add(new Timestamp(bean.getModtime().getTime()));
            uqi.sqlTypes.add(new Integer(91));
            this.prepareNullSetListValue(bean.isNull("modtime"), uqi);
            valueSet = true;
        }
        if (bean.getModuser() != null || bean.isNull("moduser")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODUSER=? ");
            uqi.setValues.add(bean.getModuser());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("moduser"), uqi);
            valueSet = true;
        }
        if (bean.getOntologysource() != null || bean.isNull("ontologysource")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("ONTOLOGYSOURCE=? ");
            uqi.setValues.add(bean.getOntologysource());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("ontologysource"), uqi);
            valueSet = true;
        }
        if (bean.getConceptid() != null || bean.isNull("conceptid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("CONCEPTID=? ");
            uqi.setValues.add(bean.getConceptid());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("conceptid"), uqi);
            valueSet = true;
        }
        if (bean.getIsbad() != null || bean.isNull("isbad")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("ISBAD=? ");
            uqi.setValues.add(this.boolean2Number(bean.getIsbad()));
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("isbad"), uqi);
            valueSet = true;
        }
        if (bean.getGroupname() != null || bean.isNull("groupname")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("GROUPNAME=? ");
            uqi.setValues.add(bean.getGroupname());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("groupname"), uqi);
            valueSet = true;
        }
        if (bean.getGrouplongname() != null || bean.isNull("grouplongname")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("GROUPLONGNAME=? ");
            uqi.setValues.add(bean.getGrouplongname());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("grouplongname"), uqi);
            valueSet = true;
        }
        if (bean.getGroupontologysource() != null || bean.isNull("groupontologysource")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("GROUPONTOLOGYSOURCE=? ");
            uqi.setValues.add(bean.getGroupontologysource());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("groupontologysource"), uqi);
            valueSet = true;
        }
        if (bean.getGroupconceptid() != null || bean.isNull("groupconceptid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("GROUPCONCEPTID=? ");
            uqi.setValues.add(bean.getGroupconceptid());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("groupconceptid"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = String.valueOf(uqi.query) + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    protected Boolean convert2Boolean(Object columnValue) {
        if (columnValue == null) {
            return null;
        }
        return ((BigDecimal)columnValue).intValue() > 0 ? new Boolean(true) : new Boolean(false);
    }

    protected BigDecimal boolean2Number(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? new BigDecimal("1") : new BigDecimal("0");
    }

    protected String boolean2YN(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? "Y" : "N";
    }

    public Analysisresult createObject(ResultSet rs) throws SQLException {
        Analysisresult obj = new Analysisresult();
        obj.setUniqueid((BigDecimal)rs.getObject(1));
        obj.setTableid((BigDecimal)rs.getObject(2));
        obj.setSegmentid((BigDecimal)rs.getObject(3));
        obj.setComponentid((BigDecimal)rs.getObject(4));
        obj.setExperimentid((BigDecimal)rs.getObject(5));
        obj.setSubjectid((String)rs.getObject(6));
        obj.setExecutedtransformid((BigDecimal)rs.getObject(7));
        obj.setAnalysisid((BigDecimal)rs.getObject(8));
        obj.setAnalysisname((String)rs.getObject(9));
        obj.setDescription(OracleUtils.readCLOB((CLOB)rs.getObject(10)));
        obj.setOwner((BigDecimal)rs.getObject(11));
        if (rs.getTimestamp(12) != null) {
            obj.setModtime(new Date(rs.getTimestamp(12).getTime()));
        }
        obj.setModuser((BigDecimal)rs.getObject(13));
        obj.setOntologysource((String)rs.getObject(14));
        obj.setConceptid((String)rs.getObject(15));
        obj.setIsbad(this.convert2Boolean(rs.getObject(16)));
        obj.setGroupname((String)rs.getObject(17));
        obj.setGrouplongname((String)rs.getObject(18));
        obj.setGroupontologysource((String)rs.getObject(19));
        obj.setGroupconceptid((String)rs.getObject(20));
        return obj;
    }

    @Override
    public List<Analysisresult> find(Connection con, Analysisresult criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<Analysisresult> results = new LinkedList<Analysisresult>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM NC_ANALYSISRESULT ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Analysisresult item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    @Override
    public void update(Connection con, Analysisresult bean, Analysisresult criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    @Override
    public void delete(Connection con, Analysisresult criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM NC_ANALYSISRESULT ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }
}

