/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.oracle;

import clinical.server.vo.ConfRole;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ConfRoleDAO
implements clinical.server.dao.ConfRoleDAO {
    @Override
    public void insert(Connection con, ConfRole bean) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO nc_conf_role VALUES ");
            buf.append('(');
            int i = 0;
            while (i < 6) {
                buf.append('?');
                if (i < 5) {
                    buf.append(',');
                }
                ++i;
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, (Object)bean.getRoleId(), 2);
            ps.setObject(2, (Object)bean.getRole(), 12);
            ps.setObject(3, (Object)bean.getDescr(), 12);
            ps.setObject(4, (Object)bean.getOwner(), 2);
            ps.setObject(5, bean.getModTime() == null ? null : new Timestamp(bean.getModTime().getTime()));
            ps.setObject(6, (Object)bean.getModUser(), 2);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    protected String prepareColList(ConfRole bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("role_id");
        buf.append(',');
        buf.append("role");
        buf.append(',');
        buf.append("descr");
        buf.append(',');
        buf.append("owner");
        buf.append(',');
        buf.append("mod_time");
        buf.append(',');
        buf.append("mod_user");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(ConfRole bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getRoleId() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("role_id=?");
            qi.values.add(bean.getRoleId());
            valueSet = true;
        }
        if (bean.getRole() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("role=?");
            qi.values.add(bean.getRole());
            valueSet = true;
        }
        if (bean.getDescr() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("descr=?");
            qi.values.add(bean.getDescr());
            valueSet = true;
        }
        if (bean.getOwner() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("owner=?");
            qi.values.add(bean.getOwner());
            valueSet = true;
        }
        if (bean.getModTime() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("mod_time=?");
            qi.values.add(new Date(bean.getModTime().getTime()));
            valueSet = true;
        }
        if (bean.getModUser() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("mod_user=?");
            qi.values.add(bean.getModUser());
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(ConfRole bean, ConfRole criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE nc_conf_role SET ");
        if (bean.getRoleId() != null || bean.isNull("roleId")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("role_id=? ");
            uqi.setValues.add(bean.getRoleId());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("roleId"), uqi);
            valueSet = true;
        }
        if (bean.getRole() != null || bean.isNull("role")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("role=? ");
            uqi.setValues.add(bean.getRole());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("role"), uqi);
            valueSet = true;
        }
        if (bean.getDescr() != null || bean.isNull("descr")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("descr=? ");
            uqi.setValues.add(bean.getDescr());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("descr"), uqi);
            valueSet = true;
        }
        if (bean.getOwner() != null || bean.isNull("owner")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("owner=? ");
            uqi.setValues.add(bean.getOwner());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("owner"), uqi);
            valueSet = true;
        }
        if (bean.getModTime() != null || bean.isNull("modTime")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("mod_time=? ");
            uqi.setValues.add(new Timestamp(bean.getModTime().getTime()));
            uqi.sqlTypes.add(new Integer(93));
            this.prepareNullSetListValue(bean.isNull("modTime"), uqi);
            valueSet = true;
        }
        if (bean.getModUser() != null || bean.isNull("modUser")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("mod_user=? ");
            uqi.setValues.add(bean.getModUser());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("modUser"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = String.valueOf(uqi.query) + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    public ConfRole createObject(ResultSet rs) throws SQLException {
        ConfRole obj = new ConfRole();
        obj.setRoleId(rs.getObject(1) != null ? new BigDecimal(rs.getObject(1).toString()) : null);
        obj.setRole((String)rs.getObject(2));
        obj.setDescr((String)rs.getObject(3));
        obj.setOwner(rs.getObject(4) != null ? new BigDecimal(rs.getObject(4).toString()) : null);
        obj.setModTime(rs.getObject(5) != null ? new java.util.Date(((Timestamp)rs.getObject(5)).getTime()) : null);
        obj.setModUser(rs.getObject(6) != null ? new BigDecimal(rs.getObject(6).toString()) : null);
        return obj;
    }

    @Override
    public List<ConfRole> find(Connection con, ConfRole criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<ConfRole> results = new LinkedList<ConfRole>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM nc_conf_role ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ConfRole item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    @Override
    public void update(Connection con, ConfRole bean, ConfRole criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    @Override
    public void delete(Connection con, ConfRole criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM nc_conf_role ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }
}

