/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.oracle;

import clinical.server.utils.OracleUtils;
import clinical.server.vo.Measurementunit;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.sql.CLOB;

public class MeasurementunitDAO
implements clinical.server.dao.MeasurementunitDAO {
    @Override
    public void insert(Connection con, Measurementunit bean) throws Exception {
        Statement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO NC_MEASUREMENTUNIT ");
            buf.append(" (MEASUREMENTSYSTEM,UNIT,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,MEASUREMENTTYPE,CONVERSIONSYSTEM,CONVERSIONUNIT,CONVERSIONINFO,DESCRIPTION) ");
            buf.append("VALUES ");
            buf.append('(');
            int i = 0;
            while (i < 12) {
                buf.append('?');
                if (i < 11) {
                    buf.append(',');
                }
                ++i;
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, bean.getMeasurementsystem(), 12);
            ps.setObject(2, bean.getUnit(), 12);
            ps.setObject(3, bean.getUniqueid(), 2);
            ps.setObject(4, bean.getTableid(), 2);
            ps.setObject(5, bean.getOwner(), 2);
            ps.setTimestamp(6, bean.getModtime() == null ? null : new Timestamp(bean.getModtime().getTime()));
            ps.setObject(7, bean.getModuser(), 2);
            ps.setObject(8, bean.getMeasurementtype(), 12);
            ps.setObject(9, bean.getConversionsystem(), 12);
            ps.setObject(10, bean.getConversionunit(), 12);
            ps.setObject(11, bean.getConversioninfo(), 12);
            ps.setObject(12, OracleUtils.getCLOB(con, bean.getDescription()), 2005);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String prepareColList(Measurementunit bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("MEASUREMENTSYSTEM");
        buf.append(',');
        buf.append("UNIT");
        buf.append(',');
        buf.append("UNIQUEID");
        buf.append(',');
        buf.append("TABLEID");
        buf.append(',');
        buf.append("OWNER");
        buf.append(',');
        buf.append("MODTIME");
        buf.append(',');
        buf.append("MODUSER");
        buf.append(',');
        buf.append("MEASUREMENTTYPE");
        buf.append(',');
        buf.append("CONVERSIONSYSTEM");
        buf.append(',');
        buf.append("CONVERSIONUNIT");
        buf.append(',');
        buf.append("CONVERSIONINFO");
        buf.append(',');
        buf.append("DESCRIPTION");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(Measurementunit bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getMeasurementsystem() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MEASUREMENTSYSTEM=?");
            qi.values.add(bean.getMeasurementsystem());
            valueSet = true;
        }
        if (bean.getUnit() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("UNIT=?");
            qi.values.add(bean.getUnit());
            valueSet = true;
        }
        if (bean.getUniqueid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("UNIQUEID=?");
            qi.values.add(bean.getUniqueid());
            valueSet = true;
        }
        if (bean.getTableid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TABLEID=?");
            qi.values.add(bean.getTableid());
            valueSet = true;
        }
        if (bean.getOwner() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("OWNER=?");
            qi.values.add(bean.getOwner());
            valueSet = true;
        }
        if (bean.getModtime() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODTIME=?");
            qi.values.add(new Timestamp(bean.getModtime().getTime()));
            valueSet = true;
        }
        if (bean.getModuser() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODUSER=?");
            qi.values.add(bean.getModuser());
            valueSet = true;
        }
        if (bean.getMeasurementtype() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MEASUREMENTTYPE=?");
            qi.values.add(bean.getMeasurementtype());
            valueSet = true;
        }
        if (bean.getConversionsystem() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("CONVERSIONSYSTEM=?");
            qi.values.add(bean.getConversionsystem());
            valueSet = true;
        }
        if (bean.getConversionunit() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("CONVERSIONUNIT=?");
            qi.values.add(bean.getConversionunit());
            valueSet = true;
        }
        if (bean.getConversioninfo() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("CONVERSIONINFO=?");
            qi.values.add(bean.getConversioninfo());
            valueSet = true;
        }
        if (bean.getDescription() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DESCRIPTION=?");
            qi.values.add(bean.getDescription());
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(Measurementunit bean, Measurementunit criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE NC_MEASUREMENTUNIT SET ");
        if (bean.getMeasurementsystem() != null || bean.isNull("measurementsystem")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MEASUREMENTSYSTEM=? ");
            uqi.setValues.add(bean.getMeasurementsystem());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("measurementsystem"), uqi);
            valueSet = true;
        }
        if (bean.getUnit() != null || bean.isNull("unit")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("UNIT=? ");
            uqi.setValues.add(bean.getUnit());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("unit"), uqi);
            valueSet = true;
        }
        if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("UNIQUEID=? ");
            uqi.setValues.add(bean.getUniqueid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
            valueSet = true;
        }
        if (bean.getTableid() != null || bean.isNull("tableid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TABLEID=? ");
            uqi.setValues.add(bean.getTableid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("tableid"), uqi);
            valueSet = true;
        }
        if (bean.getOwner() != null || bean.isNull("owner")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("OWNER=? ");
            uqi.setValues.add(bean.getOwner());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("owner"), uqi);
            valueSet = true;
        }
        if (bean.getModtime() != null || bean.isNull("modtime")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODTIME=? ");
            uqi.setValues.add(new Timestamp(bean.getModtime().getTime()));
            uqi.sqlTypes.add(new Integer(91));
            this.prepareNullSetListValue(bean.isNull("modtime"), uqi);
            valueSet = true;
        }
        if (bean.getModuser() != null || bean.isNull("moduser")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODUSER=? ");
            uqi.setValues.add(bean.getModuser());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("moduser"), uqi);
            valueSet = true;
        }
        if (bean.getMeasurementtype() != null || bean.isNull("measurementtype")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MEASUREMENTTYPE=? ");
            uqi.setValues.add(bean.getMeasurementtype());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("measurementtype"), uqi);
            valueSet = true;
        }
        if (bean.getConversionsystem() != null || bean.isNull("conversionsystem")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("CONVERSIONSYSTEM=? ");
            uqi.setValues.add(bean.getConversionsystem());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("conversionsystem"), uqi);
            valueSet = true;
        }
        if (bean.getConversionunit() != null || bean.isNull("conversionunit")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("CONVERSIONUNIT=? ");
            uqi.setValues.add(bean.getConversionunit());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("conversionunit"), uqi);
            valueSet = true;
        }
        if (bean.getConversioninfo() != null || bean.isNull("conversioninfo")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("CONVERSIONINFO=? ");
            uqi.setValues.add(bean.getConversioninfo());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("conversioninfo"), uqi);
            valueSet = true;
        }
        if (bean.getDescription() != null || bean.isNull("description")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DESCRIPTION=? ");
            uqi.setValues.add(bean.getDescription());
            uqi.sqlTypes.add(new Integer(2005));
            this.prepareNullSetListValue(bean.isNull("description"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = String.valueOf(uqi.query) + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    public Measurementunit createObject(ResultSet rs) throws SQLException {
        Measurementunit obj = new Measurementunit();
        obj.setMeasurementsystem((String)rs.getObject(1));
        obj.setUnit((String)rs.getObject(2));
        obj.setUniqueid((BigDecimal)rs.getObject(3));
        obj.setTableid((BigDecimal)rs.getObject(4));
        obj.setOwner((BigDecimal)rs.getObject(5));
        if (rs.getTimestamp(6) != null) {
            obj.setModtime(new Date(rs.getTimestamp(6).getTime()));
        }
        obj.setModuser((BigDecimal)rs.getObject(7));
        obj.setMeasurementtype((String)rs.getObject(8));
        obj.setConversionsystem((String)rs.getObject(9));
        obj.setConversionunit((String)rs.getObject(10));
        obj.setConversioninfo((String)rs.getObject(11));
        obj.setDescription(OracleUtils.readCLOB((CLOB)rs.getObject(12)));
        return obj;
    }

    @Override
    public List<Measurementunit> find(Connection con, Measurementunit criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<Measurementunit> results = new LinkedList<Measurementunit>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM NC_MEASUREMENTUNIT ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Measurementunit item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    @Override
    public void update(Connection con, Measurementunit bean, Measurementunit criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    @Override
    public void delete(Connection con, Measurementunit criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM NC_MEASUREMENTUNIT ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }
}

