/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.oracle;

import clinical.server.vo.Researchdata;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ResearchdataDAO
implements clinical.server.dao.ResearchdataDAO {
    @Override
    public void insert(Connection con, Researchdata bean) throws Exception {
        Statement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO NC_RESEARCHDATA ");
            buf.append(" (UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,EXTENSIONNAME,DATAURI,ISRAW,DATAONTOLOGY,DATACLASS,ISBAD) ");
            buf.append("VALUES ");
            buf.append('(');
            int i = 0;
            while (i < 11) {
                buf.append('?');
                if (i < 10) {
                    buf.append(',');
                }
                ++i;
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, bean.getUniqueid(), 2);
            ps.setObject(2, bean.getTableid(), 2);
            ps.setObject(3, bean.getOwner(), 2);
            ps.setTimestamp(4, bean.getModtime() == null ? null : new Timestamp(bean.getModtime().getTime()));
            ps.setObject(5, bean.getModuser(), 2);
            ps.setObject(6, bean.getExtensionname(), 12);
            ps.setObject(7, bean.getDatauri(), 12);
            ps.setObject(8, this.boolean2Number(bean.getIsraw()), 2);
            ps.setObject(9, bean.getDataontology(), 12);
            ps.setObject(10, bean.getDataclass(), 12);
            ps.setObject(11, this.boolean2Number(bean.getIsbad()), 2);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String prepareColList(Researchdata bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("UNIQUEID");
        buf.append(',');
        buf.append("TABLEID");
        buf.append(',');
        buf.append("OWNER");
        buf.append(',');
        buf.append("MODTIME");
        buf.append(',');
        buf.append("MODUSER");
        buf.append(',');
        buf.append("EXTENSIONNAME");
        buf.append(',');
        buf.append("DATAURI");
        buf.append(',');
        buf.append("ISRAW");
        buf.append(',');
        buf.append("DATAONTOLOGY");
        buf.append(',');
        buf.append("DATACLASS");
        buf.append(',');
        buf.append("ISBAD");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(Researchdata bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getUniqueid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("UNIQUEID=?");
            qi.values.add(bean.getUniqueid());
            valueSet = true;
        }
        if (bean.getTableid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TABLEID=?");
            qi.values.add(bean.getTableid());
            valueSet = true;
        }
        if (bean.getOwner() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("OWNER=?");
            qi.values.add(bean.getOwner());
            valueSet = true;
        }
        if (bean.getModtime() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODTIME=?");
            qi.values.add(new Timestamp(bean.getModtime().getTime()));
            valueSet = true;
        }
        if (bean.getModuser() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODUSER=?");
            qi.values.add(bean.getModuser());
            valueSet = true;
        }
        if (bean.getExtensionname() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("EXTENSIONNAME=?");
            qi.values.add(bean.getExtensionname());
            valueSet = true;
        }
        if (bean.getDatauri() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DATAURI=?");
            qi.values.add(bean.getDatauri());
            valueSet = true;
        }
        if (bean.getIsraw() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("ISRAW=?");
            qi.values.add(this.boolean2Number(bean.getIsraw()));
            valueSet = true;
        }
        if (bean.getDataontology() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DATAONTOLOGY=?");
            qi.values.add(bean.getDataontology());
            valueSet = true;
        }
        if (bean.getDataclass() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DATACLASS=?");
            qi.values.add(bean.getDataclass());
            valueSet = true;
        }
        if (bean.getIsbad() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("ISBAD=?");
            qi.values.add(this.boolean2Number(bean.getIsbad()));
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(Researchdata bean, Researchdata criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE NC_RESEARCHDATA SET ");
        if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("UNIQUEID=? ");
            uqi.setValues.add(bean.getUniqueid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
            valueSet = true;
        }
        if (bean.getTableid() != null || bean.isNull("tableid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TABLEID=? ");
            uqi.setValues.add(bean.getTableid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("tableid"), uqi);
            valueSet = true;
        }
        if (bean.getOwner() != null || bean.isNull("owner")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("OWNER=? ");
            uqi.setValues.add(bean.getOwner());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("owner"), uqi);
            valueSet = true;
        }
        if (bean.getModtime() != null || bean.isNull("modtime")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODTIME=? ");
            uqi.setValues.add(new Timestamp(bean.getModtime().getTime()));
            uqi.sqlTypes.add(new Integer(91));
            this.prepareNullSetListValue(bean.isNull("modtime"), uqi);
            valueSet = true;
        }
        if (bean.getModuser() != null || bean.isNull("moduser")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODUSER=? ");
            uqi.setValues.add(bean.getModuser());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("moduser"), uqi);
            valueSet = true;
        }
        if (bean.getExtensionname() != null || bean.isNull("extensionname")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("EXTENSIONNAME=? ");
            uqi.setValues.add(bean.getExtensionname());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("extensionname"), uqi);
            valueSet = true;
        }
        if (bean.getDatauri() != null || bean.isNull("datauri")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DATAURI=? ");
            uqi.setValues.add(bean.getDatauri());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("datauri"), uqi);
            valueSet = true;
        }
        if (bean.getIsraw() != null || bean.isNull("israw")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("ISRAW=? ");
            uqi.setValues.add(this.boolean2Number(bean.getIsraw()));
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("israw"), uqi);
            valueSet = true;
        }
        if (bean.getDataontology() != null || bean.isNull("dataontology")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DATAONTOLOGY=? ");
            uqi.setValues.add(bean.getDataontology());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("dataontology"), uqi);
            valueSet = true;
        }
        if (bean.getDataclass() != null || bean.isNull("dataclass")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DATACLASS=? ");
            uqi.setValues.add(bean.getDataclass());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("dataclass"), uqi);
            valueSet = true;
        }
        if (bean.getIsbad() != null || bean.isNull("isbad")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("ISBAD=? ");
            uqi.setValues.add(this.boolean2Number(bean.getIsbad()));
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("isbad"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = String.valueOf(uqi.query) + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    protected Boolean convert2Boolean(Object columnValue) {
        if (columnValue == null) {
            return null;
        }
        return ((BigDecimal)columnValue).intValue() > 0 ? new Boolean(true) : new Boolean(false);
    }

    protected BigDecimal boolean2Number(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? new BigDecimal("1") : new BigDecimal("0");
    }

    protected String boolean2YN(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? "Y" : "N";
    }

    public Researchdata createObject(ResultSet rs) throws SQLException {
        Researchdata obj = new Researchdata();
        obj.setUniqueid((BigDecimal)rs.getObject(1));
        obj.setTableid((BigDecimal)rs.getObject(2));
        obj.setOwner((BigDecimal)rs.getObject(3));
        if (rs.getTimestamp(4) != null) {
            obj.setModtime(new Date(rs.getTimestamp(4).getTime()));
        }
        obj.setModuser((BigDecimal)rs.getObject(5));
        obj.setExtensionname((String)rs.getObject(6));
        obj.setDatauri((String)rs.getObject(7));
        obj.setIsraw(this.convert2Boolean(rs.getObject(8)));
        obj.setDataontology((String)rs.getObject(9));
        obj.setDataclass((String)rs.getObject(10));
        obj.setIsbad(this.convert2Boolean(rs.getObject(11)));
        return obj;
    }

    @Override
    public List<Researchdata> find(Connection con, Researchdata criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<Researchdata> results = new LinkedList<Researchdata>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM NC_RESEARCHDATA ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Researchdata item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    @Override
    public void update(Connection con, Researchdata bean, Researchdata criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    @Override
    public void delete(Connection con, Researchdata criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM NC_RESEARCHDATA ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }
}

