/*
 * Decompiled with CFR 0.152.
 */
package clinical.tools.install;

import org.jdom.Content;
import org.jdom.Element;

public class DatabaseInfo {
    String dbID;
    String hostName;
    String dbType = "oracle";
    String SID = "orcl1";
    int port = 1521;
    boolean defaultDB = false;
    String siteId;
    String siteName;

    public String getDBURL() {
        StringBuffer buf = new StringBuffer(128);
        if (this.dbType.equalsIgnoreCase("oracle")) {
            buf.append("jdbc:").append(this.dbType).append(":thin:@").append(this.hostName).append(":");
            buf.append(this.port).append(":").append(this.SID);
        } else if (this.dbType.equalsIgnoreCase("postgres")) {
            buf.append("jdbc:postgresql://").append(this.hostName);
            buf.append(":").append(this.port);
            buf.append("/").append(this.SID);
        } else {
            throw new RuntimeException("Not a supported DB type:" + this.dbType);
        }
        return buf.toString();
    }

    public void toXML(Element parent) {
        Element e = new Element("database");
        parent.addContent((Content)e);
        e.setAttribute("id", this.dbID);
        e.setAttribute("default", this.defaultDB ? "true" : "false");
        e.setAttribute("siteId", this.siteId);
        e.setAttribute("siteName", this.siteName);
        Element ue = new Element("db-url");
        String dbURL = null;
        dbURL = this.dbType.equalsIgnoreCase("oracle") ? "jdbc:" + this.dbType + ":thin:@" + this.hostName + ":" + this.port + ":" + this.SID : "jdbc:postgresql://" + this.hostName + ":" + this.port + "/" + this.SID;
        ue.addContent(dbURL);
        e.addContent((Content)ue);
        Element dbTypeElem = new Element("db-type");
        dbTypeElem.addContent(this.dbType.toLowerCase());
        e.addContent((Content)dbTypeElem);
    }
}

