/*
 * Decompiled with CFR 0.152.
 */
package clinical.web;

import clinical.web.IAppConfigService;
import clinical.web.ISQLDialect;
import clinical.web.ISequenceHelper;
import clinical.web.common.IDBCache;
import clinical.web.common.IDBPoolService;
import clinical.web.common.ISecurityService;
import clinical.web.common.query.OracleSQLDialect;
import clinical.web.common.query.PostgresSQLDialect;
import clinical.web.exception.BaseException;
import clinical.web.services.AppConfigService;
import clinical.web.services.DBCache;
import clinical.web.services.DBPoolService;
import clinical.web.services.OracleSequenceHelper;
import clinical.web.services.PostgresSequenceHelper;
import clinical.web.services.SecurityService;
import clinical.web.services.SimpleSecurityService;

public class MinimalServiceFactory {
    private static boolean mimimalOpMode = false;

    public static ISecurityService getSecurityService() throws BaseException {
        if (MinimalServiceFactory.isMimimalOpMode()) {
            return SimpleSecurityService.getInstance();
        }
        return SecurityService.getInstance();
    }

    public static ISequenceHelper getSequenceHelper(String dbID) throws BaseException {
        SimpleSecurityService isec = SimpleSecurityService.getInstance();
        String dbType = isec.getDBType(dbID);
        if (dbType.equals("oracle")) {
            return OracleSequenceHelper.getInstance(dbID, dbType);
        }
        if (dbType.equals("postgres")) {
            return PostgresSequenceHelper.getInstance(dbID, dbType);
        }
        throw new BaseException("Not a supported database type:" + dbType);
    }

    public static ISQLDialect getSQLDialect(String dbID) throws BaseException {
        SimpleSecurityService isec = SimpleSecurityService.getInstance();
        String dbType = isec.getDBType(dbID);
        if (dbType.equals("oracle")) {
            return new OracleSQLDialect();
        }
        if (dbType.equals("postgres")) {
            return new PostgresSQLDialect();
        }
        throw new BaseException("Not a supported database type:" + dbType);
    }

    public static IDBPoolService getPoolService(String dbID) {
        return DBPoolService.getInstance(dbID);
    }

    public static IAppConfigService getAppConfigService() throws BaseException {
        return AppConfigService.getInstance();
    }

    public static IDBCache getDBCache(String dbID) throws BaseException {
        return DBCache.getInstance(dbID);
    }

    public static synchronized boolean isMimimalOpMode() {
        return mimimalOpMode;
    }

    public static synchronized void setMimimalOpMode(boolean mimimalOpMode) {
        MinimalServiceFactory.mimimalOpMode = mimimalOpMode;
    }
}

