/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.common.security;

import clinical.web.common.security.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DBConfig {
    protected String id;
    protected String dbURL;
    protected boolean forceSchemaOwnerCheck = false;
    protected String dbType;
    protected Map<String, User> userMap;
    protected Map<String, User> dbUserMap;
    protected boolean defaultDB;
    protected String siteID;
    protected String siteName;
    protected String siteURL;
    public static final String ORACLE = "oracle";
    public static final String POSTGRES = "postgres";

    public DBConfig(String id, String siteName, String siteID) {
        this.id = id;
        this.siteName = siteName;
        this.siteID = siteID;
        this.userMap = Collections.synchronizedMap(new LinkedHashMap(17));
        this.dbUserMap = Collections.synchronizedMap(new LinkedHashMap(17));
    }

    public User findDBUser(String userName) {
        return this.dbUserMap.get(userName);
    }

    public User findUser(String userName) {
        return this.userMap.get(userName);
    }

    public void removeUser(User webUser) {
        this.userMap.remove(webUser.getName());
    }

    public void removeDBUser(User dbUser) {
        this.dbUserMap.remove(dbUser.getName());
    }

    public void setDbURL(String newDbURL) {
        this.dbURL = newDbURL;
    }

    public void setDefaultDB(boolean newDefaultDB) {
        this.defaultDB = newDefaultDB;
    }

    public void setDbType(String newDbType) {
        this.dbType = newDbType;
    }

    public void setForceSchemaOwnerCheck(boolean newForceSchemaOwnerCheck) {
        this.forceSchemaOwnerCheck = newForceSchemaOwnerCheck;
    }

    public String getId() {
        return this.id;
    }

    public String getDbURL() {
        return this.dbURL;
    }

    public boolean isDefaultDB() {
        return this.defaultDB;
    }

    public String getDbType() {
        return this.dbType;
    }

    public boolean getForceSchemaOwnerCheck() {
        return this.forceSchemaOwnerCheck;
    }

    public void addUser(User user) {
        this.userMap.put(user.getName(), user);
    }

    public void addDbUser(User dbUser) {
        this.dbUserMap.put(dbUser.getName(), dbUser);
    }

    public User getDBUser(String dbUserName) {
        return this.dbUserMap.get(dbUserName);
    }

    public synchronized User removeDBUser(String dbUserName) {
        User dbUser = this.dbUserMap.remove(dbUserName);
        if (dbUser != null) {
            List<User> webUsers = this.getWebUsersForDBUser(dbUser);
            for (User webUser : webUsers) {
                this.userMap.remove(webUser.getName());
            }
        }
        return dbUser;
    }

    public User getUser(String userName) {
        return this.userMap.get(userName);
    }

    public User removeUser(String userName) {
        return this.userMap.remove(userName);
    }

    public Map<String, User> getUserMap() {
        return this.userMap;
    }

    public Map<String, User> getDBUserMap() {
        return this.dbUserMap;
    }

    public List<User> listWebUsers() {
        return new ArrayList<User>(this.userMap.values());
    }

    public List<User> listDBUsers() {
        return new ArrayList<User>(this.dbUserMap.values());
    }

    public Map<String, User> getDbUserMap() {
        return this.dbUserMap;
    }

    public List<User> getDbUsers() {
        return new ArrayList<User>(this.dbUserMap.values());
    }

    public List<User> getWebUsers() {
        return new ArrayList<User>(this.userMap.values());
    }

    public List<User> getWebUsersForDBUser(User dbUser) {
        ArrayList<User> webUsers = new ArrayList<User>(5);
        for (User user : this.userMap.values()) {
            User dbu = user.getDbUser();
            if (!dbu.getName().equals(dbUser.getName())) continue;
            webUsers.add(user);
        }
        return webUsers;
    }

    public String getSiteID() {
        return this.siteID;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("DBConfig::[");
        buf.append("id=").append(this.id);
        buf.append(",dbType=").append(this.dbType);
        buf.append(",siteID=").append(this.siteID);
        buf.append(",siteName=").append(this.siteName);
        buf.append(']');
        return buf.toString();
    }

    public String getSiteURL() {
        return this.siteURL;
    }

    public void setSiteURL(String siteURL) {
        this.siteURL = siteURL;
    }
}

