/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.services;

import clinical.cache.DBChangeNotifySupport;
import clinical.server.dao.ConfDatabaseDAO;
import clinical.server.dao.ConfDbuserDAO;
import clinical.server.dao.ConfPrivilegeDAO;
import clinical.server.dao.ConfRoleDAO;
import clinical.server.dao.ConfRolePrivsDAO;
import clinical.server.dao.ConfWebuserDAO;
import clinical.server.dao.ConfWebuserPrivDAO;
import clinical.server.dao.ConfWebuserProjPrivDAO;
import clinical.server.dao.SiteDAO;
import clinical.server.vo.ConfDatabase;
import clinical.server.vo.ConfDbuser;
import clinical.server.vo.ConfPrivilege;
import clinical.server.vo.ConfRole;
import clinical.server.vo.ConfRolePrivs;
import clinical.server.vo.ConfWebuser;
import clinical.server.vo.ConfWebuserPriv;
import clinical.server.vo.ConfWebuserProjPriv;
import clinical.server.vo.Databaseuser;
import clinical.server.vo.Experiment;
import clinical.server.vo.Site;
import clinical.utils.Assertion;
import clinical.utils.GenUtils;
import clinical.web.DAOFactory;
import clinical.web.DBUtils;
import clinical.web.IAppConfigService;
import clinical.web.ISQLDialect;
import clinical.web.ISequenceHelper;
import clinical.web.MinimalServiceFactory;
import clinical.web.ServiceFactory;
import clinical.web.common.IAuthenticationService;
import clinical.web.common.IAuthorizationService;
import clinical.web.common.IDBCache;
import clinical.web.common.IDBPoolService;
import clinical.web.common.ISecurityAdminService;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.common.query.TSQLProcessor;
import clinical.web.common.security.DBConfig;
import clinical.web.common.security.Privilege;
import clinical.web.common.security.ProjectPrivilege;
import clinical.web.common.security.User;
import clinical.web.exception.AuthenticationException;
import clinical.web.exception.BaseException;
import clinical.web.exception.UnknownUserException;
import clinical.web.services.DBPoolService;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.myproxy.MyProxy;
import org.ietf.jgss.GSSCredential;

public class SecurityService
implements IAuthenticationService,
IAuthorizationService,
ISecurityService,
ISecurityAdminService {
    public static final String USEGSI = "usegsi";
    private Map<String, Privilege> privilegesMap = new HashMap<String, Privilege>(23);
    private Map<String, DBConfig> dbConfigMap = Collections.synchronizedMap(new HashMap(7));
    private Map<String, Map<String, String>> masterTableMap = new HashMap<String, Map<String, String>>();
    private DBConfig currentDBConfig;
    private static final String PUBLIC_USER = "public";
    private static final String DEFAULT_USER = "admin";
    private static final String GUEST_USER = "guest";
    private String dbID;
    private IDBPoolService poolService;
    private String dbType;
    private Log log = LogFactory.getLog((String)"security");
    private static SecurityService instance = null;
    private static final boolean USE_TABLE_MD_CACHE = false;

    private SecurityService(IDBPoolService poolService, String dbID, String dbType) throws BaseException {
        this.poolService = poolService;
        this.dbID = dbID;
        this.dbType = dbType;
    }

    public static synchronized SecurityService getInstance(IDBPoolService poolService, String dbID, String dbType) throws BaseException {
        if (instance == null) {
            instance = new SecurityService(poolService, dbID, dbType);
        }
        return instance;
    }

    public static synchronized SecurityService getInstance() throws BaseException {
        if (instance == null) {
            throw new BaseException("Service is not initialized!");
        }
        return instance;
    }

    public synchronized void startup() throws BaseException {
        Connection con = null;
        try {
            try {
                con = this.poolService.getConnection(DEFAULT_USER);
                this.retrieveUserDBAdminData(con);
            }
            catch (Exception e) {
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException(e);
            }
        }
        finally {
            this.poolService.releaseConnection(DEFAULT_USER, con);
        }
    }

    @Override
    public UserInfo authenticate(String user, String pwd, String dbID) throws AuthenticationException {
        System.out.println("authenticating user " + user + " for dbID:" + dbID);
        System.out.println("pwd:" + pwd);
        DBConfig dbConfig = this.dbConfigMap.get(dbID);
        if (dbConfig == null) {
            throw new AuthenticationException("Unknown dbID:" + dbID);
        }
        System.out.println(">>" + dbConfig.toString());
        User u = dbConfig.getUser(user);
        if (u == null) {
            throw new UnknownUserException("User '" + user + "' is not recognized!");
        }
        try {
            String digest = GenUtils.getMD5Digest(pwd);
            if (!u.getPwd().equals(digest)) {
                throw new AuthenticationException("Incorrect Password!");
            }
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
            throw new AuthenticationException("Incorrect Password!");
        }
        GSSCredential credential = null;
        if (u.isUseGSI()) {
            System.out.println("using Myproxy authentication for web user:" + u.getName());
            try {
                IAppConfigService configService = ServiceFactory.getAppConfigService();
                User clearUser = new User(user, pwd, u.isUseGSI());
                credential = this.getCredential(configService, clearUser);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new AuthenticationException("Problem in getting user certificate!");
            }
            if (credential == null) {
                throw new AuthenticationException("Cannot get certificate for user:" + u.getName());
            }
        }
        if (u.isUseGSI()) {
            return new UserInfo(user, null, u.getAvailableTables(), credential);
        }
        return new UserInfo(user, null, u.getAvailableTables());
    }

    protected GSSCredential getCredential(IAppConfigService configService, User u) throws Exception {
        String myproxyHost = configService.getParamValue("globus.myproxy.server.primary");
        int port = GenUtils.toInt(configService.getParamValue("globus.myproxy.server.port"), 7512);
        MyProxy proxy = new MyProxy(myproxyHost, port);
        GSSCredential credential = proxy.get(u.getName(), u.getPwd(), 0);
        return credential;
    }

    @Override
    public UserInfo authenticateAnonymous(String email, String dbID) throws AuthenticationException {
        DBConfig dbConfig = this.dbConfigMap.get(dbID);
        if (dbConfig == null) {
            throw new AuthenticationException("Unknown dbID:" + dbID);
        }
        if (email.indexOf("@") == -1) {
            throw new AuthenticationException("Not a valid email address");
        }
        User u = dbConfig.getUser(PUBLIC_USER);
        if (u == null) {
            throw new UnknownUserException("errors.notrecognized", PUBLIC_USER);
        }
        return new UserInfo(PUBLIC_USER, email, null, u.getAvailableTables());
    }

    @Override
    public UserInfo getDefaultUser(String dbID, UserInfo ui) throws AuthenticationException {
        DBConfig dbConfig = this.dbConfigMap.get(dbID);
        User u = dbConfig.getUser(DEFAULT_USER);
        return new UserInfo(DEFAULT_USER, null, u.getAvailableTables(), ui.getCredential());
    }

    @Override
    public synchronized boolean isAuthorized(UserInfo userInfo, String dbId, Object action) {
        User u = null;
        DBConfig dbConf = this.dbConfigMap.get(dbId);
        if (dbConf != null) {
            u = dbConf.getUser(userInfo.getName());
        }
        if (u == null) {
            return false;
        }
        String privName = (String)action;
        boolean hasPriv = u.hasPrivilege(privName);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("privName:" + privName + " User u:" + u.getName() + " dbId:" + dbId + " hasPrivilege:" + hasPriv));
        }
        return hasPriv;
    }

    @Override
    public DBConfig findBySiteID(String siteID) {
        for (DBConfig dbConfig : this.dbConfigMap.values()) {
            if (!dbConfig.getSiteID().equals(siteID)) continue;
            return dbConfig;
        }
        return null;
    }

    @Override
    public synchronized String findSiteIDByDbID(String dbID) {
        for (DBConfig dbConfig : this.dbConfigMap.values()) {
            if (!dbConfig.getId().equals(dbID)) continue;
            return dbConfig.getSiteID();
        }
        return null;
    }

    @Override
    public synchronized Map<String, String> getSiteURLs() {
        HashMap<String, String> map = new HashMap<String, String>(17);
        for (DBConfig dbConfig : this.dbConfigMap.values()) {
            map.put(dbConfig.getId(), dbConfig.getSiteURL());
        }
        return map;
    }

    @Override
    public String[] getAllDBIDs() {
        String[] arr = new String[this.dbConfigMap.size()];
        int i = 0;
        for (String dbID : this.dbConfigMap.keySet()) {
            arr[i++] = dbID;
        }
        return arr;
    }

    @Override
    public Map<String, User> getAllNamedUsers(String dbID) {
        return this.dbConfigMap.get(dbID).getDBUserMap();
    }

    @Override
    public Map<String, User> getAllUsers(String dbID) {
        return this.dbConfigMap.get(dbID).getUserMap();
    }

    @Override
    public String getDBType(String dbID) {
        DBConfig dbConfig = this.dbConfigMap.get(dbID);
        if (dbConfig == null) {
            System.out.println("dbConfig is null");
            if (this.dbID == dbID) {
                return this.dbType;
            }
            return null;
        }
        return dbConfig.getDbType();
    }

    @Override
    public String getDefaultDBID() {
        return this.currentDBConfig.getId();
    }

    @Override
    public User getRestrictedUser(String dbID) {
        DBConfig dbConfig = this.dbConfigMap.get(dbID);
        User guestUser = dbConfig.getUser(GUEST_USER);
        if (guestUser == null) {
            guestUser = new User(GUEST_USER, "");
            guestUser.setDbUser(this.getDefaultDBUser(dbConfig));
            dbConfig.addUser(guestUser);
        }
        return guestUser;
    }

    @Override
    public Map<String, DBConfig> getDBConfigMap() {
        return this.dbConfigMap;
    }

    @Override
    public List<Privilege> getPrivileges() {
        ArrayList<Privilege> privList = new ArrayList<Privilege>(this.privilegesMap.values());
        Collections.sort(privList, new Comparator<Privilege>(){

            @Override
            public int compare(Privilege p1, Privilege p2) {
                return p1.getName().compareTo(p2.getName());
            }
        });
        return privList;
    }

    @Override
    public synchronized void updateUserPoolForDatabase(DBConfig dbConfig) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    public DBConfig getCurrentDBConfig() {
        return this.currentDBConfig;
    }

    private User getDefaultDBUser(DBConfig dbConfig) {
        Iterator<User> iterator = dbConfig.getDBUserMap().values().iterator();
        if (iterator.hasNext()) {
            User dbUser = iterator.next();
            return dbUser;
        }
        return null;
    }

    public void prepareTableCache(String dbID) throws Exception {
    }

    protected void prepareAvailableTables(User user, String dbID) {
        Connection con = null;
        IDBPoolService pool = null;
        if (!user.getAvailableTables().isEmpty()) {
            return;
        }
        try {
            try {
                pool = MinimalServiceFactory.getPoolService(dbID);
                con = pool.getConnection(user.getName());
                Map<String, String> dbMasterTableMap = this.masterTableMap.get(dbID);
                for (String tableName : dbMasterTableMap.keySet()) {
                    if (SecurityService.canAccessTable(con, tableName)) {
                        user.addAvailableTable(tableName);
                        continue;
                    }
                    this.log.error((Object)(String.valueOf(user.getName()) + " cannot access table: " + tableName));
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                this.log.error((Object)x, (Throwable)x);
                try {
                    this.log.info((Object)("****** Releasing connection " + user.getName() + " con=" + con + " dbID=" + dbID));
                    pool.releaseConnection(user.getName(), con);
                }
                catch (Exception ex) {
                    this.log.error((Object)ex, (Throwable)ex);
                }
            }
        }
        finally {
            try {
                this.log.info((Object)("****** Releasing connection " + user.getName() + " con=" + con + " dbID=" + dbID));
                pool.releaseConnection(user.getName(), con);
            }
            catch (Exception ex) {
                this.log.error((Object)ex, (Throwable)ex);
            }
        }
    }

    public static boolean canAccessTable(Connection con, String tableName) {
        Statement st = null;
        try {
            st = con.createStatement();
            ResultSet rs = st.executeQuery("select 1 from " + tableName);
            rs.close();
            return true;
        }
        catch (SQLException x) {
            return false;
        }
        finally {
            DBUtils.close(st);
        }
    }

    public List<Site> getAllSites() throws Exception {
        Connection con = null;
        try {
            List<Site> sites;
            con = this.poolService.getConnection(DEFAULT_USER);
            SiteDAO dao = DAOFactory.createSiteDAO(this.dbID);
            List<Site> list = sites = dao.find(con, new Site());
            return list;
        }
        catch (Exception x) {
            this.handleErrorAndRollBack(con, "", x);
            return null;
        }
        finally {
            this.poolService.releaseConnection(DEFAULT_USER, con);
        }
    }

    public Site getSite(String siteUniqueId) throws Exception {
        Connection con = null;
        try {
            con = this.poolService.getConnection(DEFAULT_USER);
            Site site = this.getSite(con, siteUniqueId);
            return site;
        }
        catch (Exception x) {
            this.handleErrorAndRollBack(con, "", x);
            return null;
        }
        finally {
            this.poolService.releaseConnection(DEFAULT_USER, con);
        }
    }

    public Site getSite(Connection con, String siteUniqueId) throws Exception {
        SiteDAO dao = DAOFactory.createSiteDAO(this.dbID);
        Site cr = new Site();
        cr.setUniqueid(new BigDecimal(siteUniqueId));
        List<Site> sites = dao.find(con, cr);
        if (sites.isEmpty()) {
            return null;
        }
        return sites.get(0);
    }

    public Site getSiteByID(Connection con, String siteID) throws Exception {
        SiteDAO dao = DAOFactory.createSiteDAO(this.dbID);
        Site cr = new Site();
        cr.setSiteid(siteID);
        List<Site> sites = dao.find(con, cr);
        if (sites.isEmpty()) {
            return null;
        }
        return sites.get(0);
    }

    public synchronized String getSiteID(String dbID) {
        DBConfig dbc = this.dbConfigMap.get(dbID);
        if (dbc == null) {
            return null;
        }
        return dbc.getSiteID();
    }

    @Override
    public synchronized String findDBForSiteID(String siteID) {
        for (DBConfig dbConf : this.dbConfigMap.values()) {
            if (!dbConf.getSiteID().equals(siteID)) continue;
            return dbConf.getId();
        }
        return null;
    }

    public void removePrivileges(DBConfig dbConf, String webUserName, List<String> privNames) throws Exception {
        Connection con = null;
        try {
            try {
                con = this.poolService.getConnection(DEFAULT_USER);
                con.setAutoCommit(false);
                this.removePrivileges(con, dbConf, webUserName, privNames);
                con.commit();
                for (User webUser : dbConf.getWebUsers()) {
                    if (!webUser.getName().equals(webUserName)) continue;
                    for (String privName : privNames) {
                        webUser.removePrivilege(privName);
                    }
                }
            }
            catch (Exception x) {
                this.handleErrorAndRollBack(con, "", x);
                this.poolService.releaseConnection(DEFAULT_USER, con);
            }
        }
        finally {
            this.poolService.releaseConnection(DEFAULT_USER, con);
        }
    }

    public void addPrivileges(DBConfig dbConf, String webUserName, List<String> privNames) throws Exception {
        Connection con = null;
        try {
            try {
                con = this.poolService.getConnection(DEFAULT_USER);
                con.setAutoCommit(false);
                this.addPrivileges(con, dbConf, webUserName, privNames);
                con.commit();
                for (User webUser : dbConf.getWebUsers()) {
                    if (!webUser.getName().equals(webUserName)) continue;
                    for (String privName : privNames) {
                        webUser.addPrivilege(this.privilegesMap.get(privName));
                    }
                }
            }
            catch (Exception x) {
                this.handleErrorAndRollBack(con, "", x);
                this.poolService.releaseConnection(DEFAULT_USER, con);
            }
        }
        finally {
            this.poolService.releaseConnection(DEFAULT_USER, con);
        }
    }

    public void saveProjectPrivileges(DBConfig dbConf, User webUser) throws Exception {
        Connection con = null;
        try {
            try {
                con = this.poolService.getConnection(DEFAULT_USER);
                con.setAutoCommit(false);
                ConfWebuserDAO dao = DAOFactory.createConfWebuserDAO(this.dbID);
                ConfWebuser cr = new ConfWebuser();
                cr.setName(webUser.getName());
                List<ConfWebuser> wuList = dao.find(con, cr);
                if (!wuList.isEmpty() && wuList.size() == 1) {
                    ConfWebuser wu = wuList.get(0);
                    this.updateUserProjPrivileges(con, wu, webUser, dbConf);
                }
                con.commit();
            }
            catch (Exception x) {
                this.handleErrorAndRollBack(con, "", x);
                this.poolService.releaseConnection(DEFAULT_USER, con);
            }
        }
        finally {
            this.poolService.releaseConnection(DEFAULT_USER, con);
        }
    }

    public void addWebUser(DBConfig dbConf, User webUser) throws Exception {
        Connection con = null;
        try {
            try {
                con = this.poolService.getConnection(DEFAULT_USER);
                con.setAutoCommit(false);
                webUser.setFullPrivilegesMap(this.privilegesMap);
                this.addUpdateWebUser(con, webUser, dbConf);
                con.commit();
                dbConf.addUser(webUser);
                IDBPoolService aPoolService = DBPoolService.getPoolService(dbConf.getId());
                Assertion.assertNotNull(aPoolService);
                aPoolService.addUser(webUser);
                DBChangeNotifySupport.getInstance().fireDBChangeNotifyEvent(this.getSiteID(this.dbID), "NC_DATABASEUSER");
            }
            catch (Exception x) {
                this.handleErrorAndRollBack(con, "", x);
                this.poolService.releaseConnection(DEFAULT_USER, con);
            }
        }
        finally {
            this.poolService.releaseConnection(DEFAULT_USER, con);
        }
    }

    public void removeWebUser(DBConfig dbConf, String webUserName) throws Exception {
        Connection con = null;
        try {
            try {
                con = this.poolService.getConnection(DEFAULT_USER);
                con.setAutoCommit(false);
                this.removeWebUser(con, dbConf, webUserName);
                con.commit();
                User webUser = dbConf.removeUser(webUserName);
                IDBPoolService aPoolService = DBPoolService.getPoolService(dbConf.getId());
                Assertion.assertNotNull(aPoolService);
                aPoolService.removeUser(webUser);
            }
            catch (Exception x) {
                this.handleErrorAndRollBack(con, "", x);
                this.poolService.releaseConnection(DEFAULT_USER, con);
            }
        }
        finally {
            this.poolService.releaseConnection(DEFAULT_USER, con);
        }
    }

    public void editWebUser(DBConfig dbConf, User webUser) throws Exception {
        Connection con = null;
        try {
            try {
                con = this.poolService.getConnection(DEFAULT_USER);
                con.setAutoCommit(false);
                webUser.setFullPrivilegesMap(this.privilegesMap);
                this.addUpdateWebUser(con, webUser, dbConf);
                con.commit();
                User user = dbConf.findUser(webUser.getName());
                user.setDbUser(webUser.getDbUser());
                user.setPwd(webUser.getPwd());
                user.setUseGSI(webUser.isUseGSI());
            }
            catch (Exception x) {
                this.handleErrorAndRollBack(con, "", x);
                this.poolService.releaseConnection(DEFAULT_USER, con);
            }
        }
        finally {
            this.poolService.releaseConnection(DEFAULT_USER, con);
        }
    }

    public void editDBUser(DBConfig dbConf, User dbUser) throws Exception {
        Connection con = null;
        try {
            try {
                con = this.poolService.getConnection(DEFAULT_USER);
                con.setAutoCommit(false);
                dbUser.setFullPrivilegesMap(this.privilegesMap);
                this.addUpdateDBUser(con, dbUser, dbConf);
                con.commit();
                User user = dbConf.findDBUser(dbUser.getName());
                user.setPwd(dbUser.getPwd());
            }
            catch (Exception x) {
                this.handleErrorAndRollBack(con, "", x);
                this.poolService.releaseConnection(DEFAULT_USER, con);
            }
        }
        finally {
            this.poolService.releaseConnection(DEFAULT_USER, con);
        }
    }

    public void addDbUser(DBConfig dbConf, User dbUser) throws Exception {
        Connection con = null;
        try {
            try {
                con = this.poolService.getConnection(DEFAULT_USER);
                con.setAutoCommit(false);
                ConfDbuser du = this.addUpdateDBUser(con, dbUser, dbConf);
                User webUser = new User(DEFAULT_USER, DEFAULT_USER);
                webUser.setDbUser(dbUser);
                for (String privName : this.privilegesMap.keySet()) {
                    if (privName.equalsIgnoreCase(DEFAULT_USER)) continue;
                    webUser.addPrivilege(this.privilegesMap.get(privName));
                }
                this.addWebUser(con, webUser, dbConf, du);
                dbConf.addDbUser(dbUser);
                dbConf.addUser(webUser);
                DBPoolService.addDatabase(dbConf);
                con.commit();
            }
            catch (Exception x) {
                this.handleErrorAndRollBack(con, "", x);
                this.poolService.releaseConnection(DEFAULT_USER, con);
            }
        }
        finally {
            this.poolService.releaseConnection(DEFAULT_USER, con);
        }
    }

    public void removeDbUser(DBConfig dbConf, String dbUserName) throws Exception {
        Connection con = null;
        try {
            try {
                con = this.poolService.getConnection(DEFAULT_USER);
                con.setAutoCommit(false);
                this.removeDBUser(con, dbConf, dbUserName);
                con.commit();
                dbConf.removeDBUser(dbUserName);
            }
            catch (Exception x) {
                this.handleErrorAndRollBack(con, "", x);
                this.poolService.releaseConnection(DEFAULT_USER, con);
            }
        }
        finally {
            this.poolService.releaseConnection(DEFAULT_USER, con);
        }
    }

    public DBConfig addUpdateDatabase(String dbId, String dbURL, String dbType, String siteUniqueId, String siteURL) throws Exception {
        Connection con;
        block5: {
            con = null;
            Site site = this.getSite(siteUniqueId);
            Assertion.assertNotNull(site);
            con = this.poolService.getConnection(DEFAULT_USER);
            con.setAutoCommit(false);
            DBConfig dbConf = new DBConfig(dbId, site.getSitename(), site.getSiteid());
            dbConf.setDbType(dbType);
            dbConf.setDbURL(dbURL);
            dbConf.setSiteURL(siteURL);
            this.addUpdateDatabase(con, dbConf);
            con.commit();
            if (this.dbConfigMap.containsKey(dbId)) break block5;
            this.dbConfigMap.put(dbId, dbConf);
            DBConfig dBConfig = dbConf;
            this.poolService.releaseConnection(DEFAULT_USER, con);
            return dBConfig;
        }
        try {
            DBConfig origDBConf = this.dbConfigMap.get(dbId);
            origDBConf.setDbType(dbType);
            origDBConf.setDbURL(dbURL);
            origDBConf.setSiteURL(siteURL);
            DBPoolService.removeDatabase(origDBConf.getId());
            DBPoolService.addDatabase(origDBConf);
        }
        catch (Exception x) {
            try {
                this.handleErrorAndRollBack(con, "", x);
            }
            catch (Throwable throwable) {
                this.poolService.releaseConnection(DEFAULT_USER, con);
                throw throwable;
            }
            this.poolService.releaseConnection(DEFAULT_USER, con);
            return null;
        }
        this.poolService.releaseConnection(DEFAULT_USER, con);
        return null;
    }

    public void removeDatabase(DBConfig dbConfig) throws Exception {
        Connection con = null;
        try {
            try {
                con = this.poolService.getConnection(DEFAULT_USER);
                con.setAutoCommit(false);
                this.removeDatabase(con, dbConfig);
                con.commit();
                this.dbConfigMap.remove(dbConfig.getId());
            }
            catch (Exception x) {
                this.handleErrorAndRollBack(con, "", x);
                this.poolService.releaseConnection(DEFAULT_USER, con);
            }
        }
        finally {
            this.poolService.releaseConnection(DEFAULT_USER, con);
        }
    }

    protected synchronized void removePrivileges(Connection con, DBConfig dbConf, String webUserName, List<String> privNames) throws Exception {
        ConfWebuserDAO wuDAO = DAOFactory.createConfWebuserDAO(this.dbID);
        ConfWebuserPrivDAO wupDAO = DAOFactory.createConfWebuserPrivDAO(this.dbID);
        ConfDatabase cd = this.getDatabaseRec(con, dbConf);
        if (cd == null) {
            return;
        }
        ConfWebuser wuCR = new ConfWebuser();
        wuCR.setDbUniqueId(cd.getUniqueId());
        wuCR.setName(webUserName);
        List<ConfWebuser> wuList = wuDAO.find(con, wuCR);
        if (wuList.isEmpty()) {
            System.err.println("Found no ConfWebuser matching " + wuCR);
            return;
        }
        Assertion.assertTrue(wuList.size() == 1);
        ConfWebuserPriv cr = new ConfWebuserPriv();
        cr.setWebuserId(wuList.get(0).getUniqueId());
        for (String privName : privNames) {
            cr.setPrivName(privName);
            wupDAO.delete(con, cr);
        }
    }

    protected synchronized void removeWebUser(Connection con, DBConfig dbConf, String webUserName) throws Exception {
        if (webUserName == null || dbConf == null) {
            throw new IllegalArgumentException();
        }
        ConfWebuserDAO wuDAO = DAOFactory.createConfWebuserDAO(this.dbID);
        ConfWebuserPrivDAO wupDAO = DAOFactory.createConfWebuserPrivDAO(this.dbID);
        ConfDatabase cd = this.getDatabaseRec(con, dbConf);
        if (cd == null) {
            return;
        }
        ConfWebuser wuCR = new ConfWebuser();
        wuCR.setDbUniqueId(cd.getUniqueId());
        wuCR.setName(webUserName);
        List<ConfWebuser> wuList = wuDAO.find(con, wuCR);
        Assertion.assertTrue(wuList.size() == 1);
        ConfWebuser wu = wuList.get(0);
        ConfWebuserPriv cr = new ConfWebuserPriv();
        cr.setWebuserId(wu.getUniqueId());
        wupDAO.delete(con, cr);
        wuCR = new ConfWebuser();
        wuCR.setUniqueId(wu.getUniqueId());
        wuDAO.delete(con, wuCR);
    }

    protected synchronized void removeDBUser(Connection con, DBConfig dbConf, String dbUserName) throws Exception {
        if (dbUserName == null || dbConf == null) {
            throw new IllegalArgumentException();
        }
        ConfDbuserDAO duDAO = DAOFactory.createConfDBuserDAO(this.dbID);
        ConfWebuserDAO wuDAO = DAOFactory.createConfWebuserDAO(this.dbID);
        ConfWebuserPrivDAO wupDAO = DAOFactory.createConfWebuserPrivDAO(this.dbID);
        ConfDatabase cd = this.getDatabaseRec(con, dbConf);
        if (cd == null) {
            return;
        }
        ConfDbuser duCR = new ConfDbuser();
        duCR.setName(dbUserName);
        duCR.setDbUniqueId(cd.getUniqueId());
        List<ConfDbuser> duList = duDAO.find(con, duCR);
        if (duList.isEmpty()) {
            return;
        }
        Assertion.assertTrue(duList.size() == 1);
        ConfDbuser du = duList.get(0);
        ConfWebuser wuCR = new ConfWebuser();
        wuCR.setDbUniqueId(cd.getUniqueId());
        wuCR.setDbuserId(du.getUniqueId());
        List<ConfWebuser> wuList = wuDAO.find(con, wuCR);
        for (ConfWebuser wu : wuList) {
            ConfWebuserPriv cr = new ConfWebuserPriv();
            cr.setWebuserId(wu.getUniqueId());
            wupDAO.delete(con, cr);
            wuCR = new ConfWebuser();
            wuCR.setUniqueId(wu.getUniqueId());
            wuDAO.delete(con, wuCR);
        }
        duCR = new ConfDbuser();
        duCR.setUniqueId(du.getUniqueId());
        duDAO.delete(con, duCR);
    }

    protected synchronized void addPrivileges(Connection con, DBConfig dbConf, String webUserName, List<String> privNames) throws Exception {
        ISequenceHelper sequenceHelper = MinimalServiceFactory.getSequenceHelper(this.dbID);
        ConfWebuserDAO wuDAO = DAOFactory.createConfWebuserDAO(this.dbID);
        ConfWebuserPrivDAO wupDAO = DAOFactory.createConfWebuserPrivDAO(this.dbID);
        ConfDatabase cd = this.getDatabaseRec(con, dbConf);
        if (cd == null) {
            return;
        }
        ConfWebuser wuCR = new ConfWebuser();
        wuCR.setDbUniqueId(cd.getUniqueId());
        wuCR.setName(webUserName);
        List<ConfWebuser> wuList = wuDAO.find(con, wuCR);
        if (wuList.isEmpty()) {
            System.err.println("Found no ConfWebuser matching " + wuCR);
            return;
        }
        Assertion.assertTrue(wuList.size() == 1);
        Databaseuser d = this.getDatabaseUser(con);
        ConfWebuserPriv wup = new ConfWebuserPriv();
        for (String privName : privNames) {
            BigDecimal uniqueId = sequenceHelper.getNextUID(con, "nc_conf_webuser_priv", "uniqueId");
            wup.setPrivName(privName);
            wup.setWebuserId(wuList.get(0).getUniqueId());
            wup.setUniqueId(uniqueId);
            wup.setOwner(d.getUniqueid());
            wup.setModUser(d.getUniqueid());
            wup.setModTime(new Date());
            wupDAO.insert(con, wup);
        }
    }

    protected synchronized void addUpdateDatabase(Connection con, DBConfig dbConf) throws Exception {
        ConfDatabase cd;
        ISequenceHelper sequenceHelper = MinimalServiceFactory.getSequenceHelper(this.dbID);
        ConfDatabaseDAO cdDAO = DAOFactory.createConfDatabaseDAO(this.dbID);
        Site site = this.getSiteByID(con, dbConf.getSiteID());
        StringBuilder sb = new StringBuilder(200);
        sb.append(dbConf.getDbURL());
        if (dbConf.getSiteURL() != null && dbConf.getSiteURL().length() > 0) {
            sb.append(';');
            sb.append(dbConf.getSiteURL());
        }
        if ((cd = this.getDatabaseRec(con, dbConf.getId())) == null) {
            cd = new ConfDatabase();
            cd.setDbId(dbConf.getId());
            cd.setDbType(dbConf.getDbType());
            cd.setDbUrl(sb.toString());
            cd.setIsDefault(dbConf.isDefaultDB());
            cd.setForceSchemaOwnerCheck(new Boolean(false));
            cd.setSiteUniqueId(site.getUniqueid());
            BigDecimal uniqueId = sequenceHelper.getNextUID(con, "nc_conf_database", "uniqueId");
            cd.setUniqueId(uniqueId);
            Databaseuser d = this.getDatabaseUser(con);
            cd.setModUser(d.getUniqueid());
            cd.setOwner(d.getUniqueid());
            cd.setModTime(new Date());
            cdDAO.insert(con, cd);
        } else {
            ConfDatabase bean = new ConfDatabase();
            bean.setDbId(dbConf.getId());
            bean.setDbType(dbConf.getDbType());
            bean.setDbUrl(sb.toString());
            bean.setIsDefault(dbConf.isDefaultDB());
            ConfDatabase cdCR = new ConfDatabase();
            cdCR.setUniqueId(cd.getUniqueId());
            cdDAO.update(con, bean, cdCR);
        }
    }

    protected synchronized void removeDatabase(Connection con, DBConfig dbConf) throws Exception {
        ConfDatabaseDAO cdDAO = DAOFactory.createConfDatabaseDAO(this.dbID);
        ConfDbuserDAO duDAO = DAOFactory.createConfDBuserDAO(this.dbID);
        ConfDatabase cd = this.getDatabaseRec(con, dbConf.getId());
        if (cd == null) {
            return;
        }
        ConfDbuser cr = new ConfDbuser();
        cr.setDbUniqueId(cd.getUniqueId());
        List<ConfDbuser> duList = duDAO.find(con, cr);
        for (ConfDbuser du : duList) {
            this.removeDBUser(con, dbConf, du.getName());
        }
        ConfDatabase cdCR = new ConfDatabase();
        cdCR.setUniqueId(cd.getUniqueId());
        cdDAO.delete(con, cdCR);
    }

    protected synchronized ConfDbuser addUpdateDBUser(Connection con, User dbUser, DBConfig dbConf) throws Exception {
        ISequenceHelper sequenceHelper = MinimalServiceFactory.getSequenceHelper(this.dbID);
        ConfDbuserDAO duDAO = DAOFactory.createConfDBuserDAO(this.dbID);
        ConfDatabase cd = this.getDatabaseRec(con, dbConf);
        ConfDbuser cr = new ConfDbuser();
        cr.setName(dbUser.getName());
        cr.setDbUniqueId(cd.getUniqueId());
        List<ConfDbuser> duList = duDAO.find(con, cr);
        if (duList.isEmpty()) {
            ConfDbuser du = new ConfDbuser();
            du.setName(dbUser.getName());
            du.setPwd(dbUser.getPwd());
            du.setDbUniqueId(cd.getUniqueId());
            Databaseuser d = this.getDatabaseUser(con);
            du.setModUser(d.getUniqueid());
            du.setOwner(d.getUniqueid());
            du.setModTime(new Date());
            BigDecimal uniqueId = sequenceHelper.getNextUID(con, "nc_conf_dbuser", "uniqueId");
            du.setUniqueId(uniqueId);
            this.log.info((Object)("inserting " + du));
            duDAO.insert(con, du);
            return du;
        }
        ConfDbuser du = duList.get(0);
        ConfDbuser bean = new ConfDbuser();
        bean.setPwd(dbUser.getPwd());
        ConfDbuser duCR = new ConfDbuser();
        duCR.setUniqueId(du.getUniqueId());
        duDAO.update(con, bean, duCR);
        return du;
    }

    protected synchronized void addWebUser(Connection con, User webUser, DBConfig dbConf, ConfDbuser du) throws Exception {
        ISequenceHelper sequenceHelper = MinimalServiceFactory.getSequenceHelper(this.dbID);
        ConfWebuserDAO wuDAO = DAOFactory.createConfWebuserDAO(this.dbID);
        ConfDatabase cd = this.getDatabaseRec(con, dbConf);
        List<Privilege> privList = webUser.listPrivileges();
        ConfWebuser wu = new ConfWebuser();
        wu.setName(webUser.getName());
        String digest = GenUtils.getMD5Digest(webUser.getPwd());
        wu.setPwd(digest);
        wu.setDbuserId(du.getUniqueId());
        wu.setDbUniqueId(cd.getUniqueId());
        Databaseuser dbUser = this.getDatabaseUser(con);
        wu.setOwner(dbUser.getUniqueid());
        wu.setModUser(dbUser.getUniqueid());
        wu.setModTime(new Date());
        if (webUser.isUseGSI()) {
            wu.setOptionFlags(USEGSI);
        }
        BigDecimal dbUniqueId = sequenceHelper.getNextUID(con, "nc_conf_webuser", "uniqueId");
        wu.setUniqueId(dbUniqueId);
        wuDAO.insert(con, wu);
        dbConf.addUser(webUser);
        if (privList != null && !privList.isEmpty()) {
            this.updateUserPrivileges(con, wu, privList, dbConf);
        }
    }

    protected synchronized void addUpdateWebUser(Connection con, User webUser, DBConfig dbConf) throws Exception {
        ISequenceHelper sequenceHelper = MinimalServiceFactory.getSequenceHelper(this.dbID);
        ConfWebuserDAO wuDAO = DAOFactory.createConfWebuserDAO(this.dbID);
        ConfDatabase cd = this.getDatabaseRec(con, dbConf);
        List<Privilege> privList = webUser.listPrivileges();
        ConfDbuserDAO duDAO = DAOFactory.createConfDBuserDAO(this.dbID);
        ConfDbuser duCR = new ConfDbuser();
        duCR.setDbUniqueId(cd.getUniqueId());
        List<ConfDbuser> duList = duDAO.find(con, duCR);
        HashMap<String, ConfDbuser> duMap = new HashMap<String, ConfDbuser>(7);
        for (ConfDbuser du : duList) {
            duMap.put(du.getName(), du);
        }
        duList = null;
        ConfWebuser criteria = new ConfWebuser();
        criteria.setName(webUser.getName());
        ConfDbuser du = (ConfDbuser)duMap.get(webUser.getDbUser().getName());
        criteria.setDbUniqueId(du.getDbUniqueId());
        List<ConfWebuser> wuList = wuDAO.find(con, criteria);
        if (wuList.isEmpty()) {
            ConfWebuser wu = new ConfWebuser();
            wu.setName(webUser.getName());
            String digest = GenUtils.getMD5Digest(webUser.getPwd());
            wu.setPwd(digest);
            webUser.setPwd(digest);
            wu.setDbuserId(du.getUniqueId());
            wu.setDbUniqueId(cd.getUniqueId());
            Databaseuser dbUser = this.getDatabaseUser(con);
            wu.setOwner(dbUser.getUniqueid());
            wu.setModUser(dbUser.getUniqueid());
            wu.setModTime(new Date());
            if (webUser.isUseGSI()) {
                wu.setOptionFlags(USEGSI);
            }
            BigDecimal dbUniqueId = sequenceHelper.getNextUID(con, "nc_conf_webuser", "uniqueId");
            wu.setUniqueId(dbUniqueId);
            wuDAO.insert(con, wu);
            dbConf.addUser(webUser);
            if (privList != null && !privList.isEmpty()) {
                this.updateUserPrivileges(con, wu, privList, dbConf);
            }
        } else {
            ConfWebuser theWU = null;
            for (ConfWebuser wu : wuList) {
                if (!wu.getDbUniqueId().equals(cd.getUniqueId())) continue;
                theWU = wu;
                break;
            }
            ConfWebuser update = new ConfWebuser();
            String digest = GenUtils.getMD5Digest(webUser.getPwd());
            update.setPwd(digest);
            webUser.setPwd(digest);
            if (webUser.isUseGSI()) {
                update.setOptionFlags(USEGSI);
            } else {
                update.setOptionFlags("");
            }
            ConfWebuser wuCR = new ConfWebuser();
            wuCR.setUniqueId(theWU.getUniqueId());
            wuDAO.update(con, update, wuCR);
            if (privList != null && !privList.isEmpty()) {
                this.updateUserPrivileges(con, theWU, privList, dbConf);
            }
        }
    }

    protected void updateUserPrivileges(Connection con, ConfWebuser wu, List<Privilege> privList, DBConfig dbConf) throws Exception {
        ISequenceHelper sequenceHelper = MinimalServiceFactory.getSequenceHelper(this.dbID);
        ConfWebuserPrivDAO wupDAO = DAOFactory.createConfWebuserPrivDAO(this.dbID);
        ConfWebuserPriv cr = new ConfWebuserPriv();
        cr.setWebuserId(wu.getUniqueId());
        List<ConfWebuserPriv> wupList = wupDAO.find(con, cr);
        if (!wupList.isEmpty()) {
            wupDAO.delete(con, cr);
        }
        for (Privilege priv : privList) {
            ConfWebuserPriv wup = new ConfWebuserPriv();
            wup.setPrivName(priv.getName());
            wup.setWebuserId(wu.getUniqueId());
            BigDecimal uniqueId = sequenceHelper.getNextUID(con, "nc_conf_webuser_priv", "uniqueId");
            wup.setUniqueId(uniqueId);
            Databaseuser dbUser = this.getDatabaseUser(con);
            wup.setModUser(dbUser.getUniqueid());
            wup.setOwner(dbUser.getUniqueid());
            wup.setModTime(new Date());
            wupDAO.insert(con, wup);
        }
    }

    protected synchronized ConfRole addRole(Connection con, String role, String descr) throws Exception {
        ConfRole criterion = new ConfRole();
        criterion.setRole(role);
        ConfRoleDAO dao = DAOFactory.createConfRoleDAO(this.dbID);
        List<ConfRole> list = dao.find(con, criterion);
        if (!list.isEmpty()) {
            throw new Exception("Role already exists in the database:" + role);
        }
        ISequenceHelper sequenceHelper = MinimalServiceFactory.getSequenceHelper(this.dbID);
        ConfRole cr = new ConfRole();
        cr.setRole(role);
        BigDecimal uniqueId = sequenceHelper.getNextUID(con, "nc_conf_role", "uniqueId");
        cr.setRoleId(uniqueId);
        cr.setDescr(descr);
        Databaseuser dbUser = this.getDatabaseUser(con);
        cr.setModUser(dbUser.getUniqueid());
        cr.setOwner(dbUser.getUniqueid());
        cr.setModTime(new Date());
        dao.insert(con, cr);
        return cr;
    }

    protected synchronized void addPrivileges2Role(Connection con, ConfRole role, List<ProjectPrivilege> ppList, List<Privilege> privList) throws Exception {
        ConfRolePrivs crp;
        ConfRolePrivsDAO dao = DAOFactory.createConfRolePrivsDAO(this.dbID);
        Date modTime = new Date();
        Databaseuser dbUser = this.getDatabaseUser(con);
        for (ProjectPrivilege pp : ppList) {
            crp = new ConfRolePrivs();
            crp.setExpId(GenUtils.toBigDecimal(pp.getExpID()));
            crp.setPrivName(pp.getPrivilege().getName());
            crp.setRoleId(role.getRoleId());
            crp.setOwner(dbUser.getUniqueid());
            crp.setModUser(dbUser.getUniqueid());
            crp.setModTime(modTime);
            dao.insert(con, crp);
        }
        for (Privilege p : privList) {
            crp = new ConfRolePrivs();
            crp.setExpId(GenUtils.toBigDecimal(-1));
            crp.setPrivName(p.getName());
            crp.setRoleId(role.getRoleId());
            crp.setOwner(dbUser.getUniqueid());
            crp.setModUser(dbUser.getUniqueid());
            crp.setModTime(modTime);
            dao.insert(con, crp);
        }
    }

    protected void updateUserProjPrivileges(Connection con, ConfWebuser wu, User webUser, DBConfig dbConf) throws Exception {
        ISequenceHelper sequenceHelper = MinimalServiceFactory.getSequenceHelper(this.dbID);
        ConfWebuserPrivDAO wupDAO = DAOFactory.createConfWebuserPrivDAO(this.dbID);
        ConfWebuserProjPrivDAO wuppDAO = DAOFactory.createConfWebuserProjPrivDAO(this.dbID);
        List<ConfPrivilege> privList = this.getProjectSpecPrivilegeList(con);
        HashSet<String> privSet = new HashSet<String>(7);
        for (ConfPrivilege p : privList) {
            privSet.add(p.getName());
        }
        privList = null;
        ConfWebuserPriv cr = new ConfWebuserPriv();
        cr.setWebuserId(wu.getUniqueId());
        List<ConfWebuserPriv> wupList = wupDAO.find(con, cr);
        if (!wupList.isEmpty()) {
            ConfWebuserProjPriv wuppCR = new ConfWebuserProjPriv();
            wuppCR.setWebuserId(wu.getUniqueId());
            wuppDAO.delete(con, wuppCR);
            for (String privName : privSet) {
                cr.setPrivName(privName);
                wupDAO.delete(con, cr);
            }
        }
        Databaseuser dbUser = this.getDatabaseUser(con);
        for (User.PrivilegeExperiments pe : webUser.getPrivExperiments()) {
            if (!pe.hasGranted()) continue;
            ConfWebuserPriv wup = new ConfWebuserPriv();
            wup.setPrivName(pe.getPrivilege());
            wup.setWebuserId(wu.getUniqueId());
            BigDecimal uniqueId = sequenceHelper.getNextUID(con, "nc_conf_webuser_priv", "uniqueId");
            wup.setUniqueId(uniqueId);
            wup.setModUser(dbUser.getUniqueid());
            wup.setOwner(dbUser.getUniqueid());
            wup.setModTime(new Date());
            wupDAO.insert(con, wup);
            Date modTime = new Date();
            for (User.ProjectPrivilegeStatus pps : pe.getPpStatusList()) {
                if (!pps.isGranted()) continue;
                ConfWebuserProjPriv wupp = new ConfWebuserProjPriv();
                int expID = pps.getExpId();
                wupp.setExpId(GenUtils.toBigDecimal(expID));
                wupp.setWebuserId(wu.getUniqueId());
                wupp.setPrivName(pe.getPrivilege());
                wupp.setOwner(dbUser.getUniqueid());
                wupp.setModUser(dbUser.getUniqueid());
                wupp.setModTime(modTime);
                wuppDAO.insert(con, wupp);
            }
        }
    }

    private List<ConfPrivilege> getProjectSpecPrivilegeList(Connection con) throws Exception {
        ConfPrivilegeDAO privDAO = DAOFactory.createConfPrivilegeDAO(this.dbID);
        ConfPrivilege cp = new ConfPrivilege();
        cp.setProjectSpecific(Boolean.TRUE);
        List<ConfPrivilege> privList = privDAO.find(con, cp);
        return privList;
    }

    protected ConfDatabase getDatabaseRec(Connection con, DBConfig dbConf) throws Exception {
        ConfDatabaseDAO cdDAO = DAOFactory.createConfDatabaseDAO(this.dbID);
        ConfDatabase cr = new ConfDatabase();
        cr.setDbId(dbConf.getId());
        List<ConfDatabase> list = cdDAO.find(con, cr);
        if (list.isEmpty() || list.size() != 1) {
            throw new Exception("Exactly one database record is required for dbID:" + dbConf.getId());
        }
        return list.get(0);
    }

    protected ConfDatabase getDatabaseRec(Connection con, String databaseId) throws Exception {
        ConfDatabaseDAO cdDAO = DAOFactory.createConfDatabaseDAO(this.dbID);
        ConfDatabase cr = new ConfDatabase();
        cr.setDbId(databaseId);
        List<ConfDatabase> list = cdDAO.find(con, cr);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    protected Databaseuser getDatabaseUser(Connection con) throws Exception {
        ISQLDialect sqlDialect = MinimalServiceFactory.getSQLDialect(this.dbID);
        TSQLProcessor tsp = new TSQLProcessor(sqlDialect);
        List<?> results = tsp.executeQuery(con, "select u.* from Databaseuser as u where u.name ='ADMIN' and u.isgroup = false");
        Assertion.assertFalse(results.isEmpty());
        Databaseuser dbUser = (Databaseuser)results.get(0);
        return dbUser;
    }

    protected synchronized void retrieveUserDBAdminData(Connection con) throws Exception {
        User dbUser;
        DBConfig dbConfig;
        ConfDatabase cd;
        ISQLDialect sqlDialect = MinimalServiceFactory.getSQLDialect(this.dbID);
        TSQLProcessor tsp = new TSQLProcessor(sqlDialect);
        ConfDatabaseDAO cdDAO = DAOFactory.createConfDatabaseDAO(this.dbID);
        ConfPrivilegeDAO privDAO = DAOFactory.createConfPrivilegeDAO(this.dbID);
        ConfDbuserDAO dbUserDAO = DAOFactory.createConfDBuserDAO(this.dbID);
        List<ConfPrivilege> privList = privDAO.find(con, new ConfPrivilege());
        for (ConfPrivilege priv : privList) {
            Privilege p = new Privilege(priv.getName(), priv.getProjectSpecific());
            p.setDescription(priv.getDescription());
            this.privilegesMap.put(p.getName(), p);
        }
        List<ConfDatabase> cdList = cdDAO.find(con, new ConfDatabase());
        HashMap<BigDecimal, ConfDatabase> cdMap = new HashMap<BigDecimal, ConfDatabase>(7);
        this.currentDBConfig = null;
        boolean first = true;
        for (ConfDatabase cd2 : cdList) {
            Site site = this.getSite(cd2.getSiteUniqueId().toString());
            Assertion.assertNotNull(site);
            DBConfig dbConfig2 = new DBConfig(cd2.getDbId(), site.getSitename(), site.getSiteid());
            String[] toks = cd2.getDbUrl().split(";");
            String dbURL = null;
            String siteURL = null;
            Assertion.assertTrue(toks.length >= 1);
            dbURL = toks[0];
            if (toks.length == 2) {
                siteURL = toks[1];
            }
            dbConfig2.setDbType(cd2.getDbType());
            dbConfig2.setDbURL(dbURL);
            dbConfig2.setSiteURL(siteURL);
            dbConfig2.setDefaultDB(cd2.getIsDefault());
            this.dbConfigMap.put(dbConfig2.getId(), dbConfig2);
            cdMap.put(cd2.getUniqueId(), cd2);
            if (first) {
                this.currentDBConfig = dbConfig2;
            }
            if (dbConfig2.isDefaultDB()) {
                this.currentDBConfig = dbConfig2;
            }
            first = false;
        }
        List<ConfDbuser> dbUserList = dbUserDAO.find(con, new ConfDbuser());
        HashMap<BigDecimal, User> dbUserMap = new HashMap<BigDecimal, User>();
        for (ConfDbuser cdu : dbUserList) {
            User dbUser2 = new User(cdu.getName(), cdu.getPwd());
            ConfDatabase cd3 = (ConfDatabase)cdMap.get(cdu.getDbUniqueId());
            DBConfig dbConfig3 = this.dbConfigMap.get(cd3.getDbId());
            dbConfig3.addDbUser(dbUser2);
            dbUserMap.put(cdu.getUniqueId(), dbUser2);
        }
        List<ConfPrivilege> ppList = this.getProjectSpecPrivilegeList(con);
        HashSet<String> ppSet = new HashSet<String>(7);
        for (ConfPrivilege pp : ppList) {
            ppSet.add(pp.getName());
        }
        IDBCache dbCache = ServiceFactory.getDBCache((String)this.dbID);
        List<Experiment> experiments = dbCache.getExperiments(new UserInfo(DEFAULT_USER, null, null), false);
        StringBuffer qBuf = new StringBuffer(128);
        qBuf.append("select w.*, p.* from ConfWebuser as w, ConfWebuserPriv as p where ");
        qBuf.append("w.uniqueId = p.webuserId order by w.name");
        List<?> results = tsp.executeQuery(con, qBuf.toString());
        HashMap<BigDecimal, User> webUserMap = new HashMap<BigDecimal, User>(7);
        for (Object[] row : results) {
            ConfWebuser wu = (ConfWebuser)row[0];
            ConfWebuserPriv wup = (ConfWebuserPriv)row[1];
            User webUser = (User)webUserMap.get(wu.getUniqueId());
            if (webUser == null) {
                boolean useGSI = SecurityService.useGSI(wu.getOptionFlags());
                System.out.println(String.valueOf(wu.getName()) + " useGSI=" + useGSI);
                webUser = new User(wu.getName(), wu.getPwd(), useGSI);
                webUserMap.put(wu.getUniqueId(), webUser);
                cd = (ConfDatabase)cdMap.get(wu.getDbUniqueId());
                dbConfig = this.dbConfigMap.get(cd.getDbId());
                Assertion.assertNotNull(dbConfig);
                dbConfig.addUser(webUser);
                dbUser = (User)dbUserMap.get(wu.getDbuserId());
                Assertion.assertNotNull(dbUser);
                webUser.setDbUser(dbUser);
                webUser.setFullPrivilegesMap(this.privilegesMap);
                if (cd.getDbId().equals(this.dbID)) {
                    this.poolService.addUser(webUser);
                }
                this.prepProjectPrivData(con, wu, experiments, ppList, webUser);
            }
            Privilege priv = this.privilegesMap.get(wup.getPrivName());
            assert (priv != null);
            if (ppSet.contains(wup.getPrivName())) continue;
            webUser.addPrivilege(priv);
        }
        ConfWebuserDAO wuDAO = DAOFactory.createConfWebuserDAO(this.dbID);
        List<ConfWebuser> wuList = wuDAO.find(con, new ConfWebuser());
        for (ConfWebuser wu : wuList) {
            if (webUserMap.get(wu.getUniqueId()) != null) continue;
            boolean useGSI = SecurityService.useGSI(wu.getOptionFlags());
            System.out.println("useGSI=" + useGSI);
            User webUser = new User(wu.getName(), wu.getPwd(), useGSI);
            cd = (ConfDatabase)cdMap.get(wu.getDbUniqueId());
            dbConfig = this.dbConfigMap.get(cd.getDbId());
            Assertion.assertNotNull(dbConfig);
            dbConfig.addUser(webUser);
            dbUser = (User)dbUserMap.get(wu.getDbuserId());
            Assertion.assertNotNull(dbUser);
            webUser.setDbUser(dbUser);
            this.prepProjectPrivData(con, wu, experiments, ppList, webUser);
            webUser.setFullPrivilegesMap(this.privilegesMap);
            if (!cd.getDbId().equals(this.dbID)) continue;
            this.poolService.addUser(webUser);
        }
        for (DBConfig dbConfig4 : this.dbConfigMap.values()) {
            DBPoolService.addDatabase(dbConfig4);
        }
    }

    protected synchronized void prepProjectPrivData(Connection con, ConfWebuser wu, List<Experiment> experiments, List<ConfPrivilege> ppList, User webUser) throws Exception {
        ConfWebuserProjPrivDAO wuppDAO = DAOFactory.createConfWebuserProjPrivDAO(this.dbID);
        ConfWebuserProjPriv cr = new ConfWebuserProjPriv();
        cr.setWebuserId(wu.getUniqueId());
        List<ConfWebuserProjPriv> wuppList = wuppDAO.find(con, cr);
        HashSet<String> wuppSet = new HashSet<String>(17);
        for (ConfWebuserProjPriv wupp : wuppList) {
            StringBuilder sb = new StringBuilder();
            sb.append(wupp.getPrivName()).append('.');
            sb.append(wupp.getExpId());
            wuppSet.add(sb.toString());
        }
        ArrayList<User.PrivilegeExperiments> peList = new ArrayList<User.PrivilegeExperiments>(ppList.size());
        for (ConfPrivilege priv : ppList) {
            ArrayList<User.ProjectPrivilegeStatus> ppStatusList = new ArrayList<User.ProjectPrivilegeStatus>(experiments.size());
            for (Experiment exp : experiments) {
                StringBuilder sb = new StringBuilder();
                sb.append(priv.getName()).append('.');
                sb.append(exp.getUniqueid());
                String key = sb.toString();
                boolean granted = wuppSet.contains(key);
                User.ProjectPrivilegeStatus pps = new User.ProjectPrivilegeStatus(exp.getUniqueid().intValue(), granted, exp.getName());
                ppStatusList.add(pps);
            }
            User.PrivilegeExperiments pe = new User.PrivilegeExperiments(priv.getName(), ppStatusList);
            peList.add(pe);
        }
        webUser.setPrivExperiments(peList);
    }

    public static boolean useGSI(String optionFlags) {
        String[] toks;
        if (optionFlags == null || optionFlags.trim().isEmpty()) {
            return false;
        }
        optionFlags = optionFlags.trim();
        String[] stringArray = toks = optionFlags.split("::");
        int n = toks.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            if (tok.equalsIgnoreCase(USEGSI)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void handleErrorAndRollBack(Connection con, String msg, Exception x) throws BaseException {
        if (con != null) {
            try {
                con.rollback();
            }
            catch (SQLException se) {
                this.log.error((Object)"", (Throwable)se);
                throw new BaseException(se);
            }
        }
        this.log.error((Object)msg, (Throwable)x);
        if (x instanceof BaseException) {
            throw (BaseException)x;
        }
        throw new BaseException(x);
    }
}

