/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.services;

import clinical.utils.DBTableInfo;
import clinical.web.DBUtils;
import clinical.web.MinimalServiceFactory;
import clinical.web.common.IAuthenticationService;
import clinical.web.common.IAuthorizationService;
import clinical.web.common.IDBPoolService;
import clinical.web.common.ISecurityAdminService;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.common.security.DBConfig;
import clinical.web.common.security.Privilege;
import clinical.web.common.security.User;
import clinical.web.exception.AuthenticationException;
import clinical.web.exception.BaseException;
import clinical.web.exception.UnknownUserException;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class SimpleSecurityService
implements IAuthenticationService,
IAuthorizationService,
ISecurityService,
ISecurityAdminService {
    private Document doc;
    private Map<String, Privilege> privilegesMap = new HashMap<String, Privilege>(23);
    private Map<String, DBConfig> dbConfigMap = Collections.synchronizedMap(new HashMap(7));
    private Map<String, Map<String, String>> masterTableMap = new HashMap<String, Map<String, String>>();
    private DBConfig currentDBConfig;
    private Log log = LogFactory.getLog((String)"security");
    private static SimpleSecurityService instance = null;

    private SimpleSecurityService(InputStream is) throws BaseException {
        try {
            SAXBuilder builder = null;
            builder = new SAXBuilder(false);
            this.doc = builder.build(is);
            this.extractData();
        }
        catch (Exception x) {
            throw new BaseException(x);
        }
    }

    private SimpleSecurityService(String userInfoFile) throws BaseException {
        SAXBuilder builder = null;
        try {
            builder = new SAXBuilder(false);
            this.doc = builder.build(new File(userInfoFile));
            this.extractData();
        }
        catch (Exception x) {
            throw new BaseException(x);
        }
    }

    @Override
    public List<Privilege> getPrivileges() {
        ArrayList<Privilege> privList = new ArrayList<Privilege>(this.privilegesMap.values());
        Collections.sort(privList, new Comparator<Privilege>(){

            @Override
            public int compare(Privilege p1, Privilege p2) {
                return p1.getName().compareTo(p2.getName());
            }
        });
        return privList;
    }

    public Map<String, Privilege> getPrivilegesMap() {
        return this.privilegesMap;
    }

    @Override
    public String getDefaultDBID() {
        return this.currentDBConfig.getId();
    }

    @Override
    public String[] getAllDBIDs() {
        String[] arr = new String[this.dbConfigMap.size()];
        int i = 0;
        for (String dbID : this.dbConfigMap.keySet()) {
            arr[i++] = dbID;
        }
        return arr;
    }

    public DBConfig getDBConfig(String dbID) {
        return this.dbConfigMap.get(dbID);
    }

    @Override
    public String getDBType(String dbID) {
        DBConfig dbConfig = this.dbConfigMap.get(dbID);
        return dbConfig.getDbType();
    }

    @Override
    public DBConfig findBySiteID(String siteID) {
        siteID = siteID.toLowerCase();
        for (DBConfig dbConfig : this.dbConfigMap.values()) {
            String dbID = dbConfig.getId();
            if (!dbID.toLowerCase().startsWith(siteID)) continue;
            return dbConfig;
        }
        return null;
    }

    @Override
    public String findSiteIDByDbID(String dbID) {
        for (DBConfig dbConfig : this.dbConfigMap.values()) {
            if (!dbConfig.getId().equals(dbConfig)) continue;
            return dbConfig.getSiteID();
        }
        return null;
    }

    @Override
    public Map<String, String> getSiteURLs() {
        HashMap<String, String> map = new HashMap<String, String>(17);
        for (DBConfig dbConfig : this.dbConfigMap.values()) {
            map.put(dbConfig.getId(), dbConfig.getSiteURL());
        }
        return map;
    }

    @Override
    public String findDBForSiteID(String siteID) {
        for (DBConfig dbConf : this.dbConfigMap.values()) {
            if (!dbConf.getSiteID().equals(siteID)) continue;
            return dbConf.getId();
        }
        return null;
    }

    private SimpleSecurityService(String userInfoFile, String schemaFile) throws BaseException {
        SAXBuilder builder = null;
        try {
            File f = null;
            if (schemaFile != null && (f = new File(schemaFile)).exists()) {
                builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", true);
                builder.setFeature("http://apache.org/xml/features/validation/schema", true);
                builder.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)f.toURI().toURL().toString());
                this.log.info((Object)("Using XML Schema " + schemaFile + " for web-user/database user map validation."));
            } else {
                builder = new SAXBuilder(false);
            }
            this.doc = builder.build(new File(userInfoFile));
            this.extractData();
            this.log.info((Object)"finished parsing the users.xml file.");
        }
        catch (Exception x) {
            this.log.error((Object)"SimpleSecurityService", (Throwable)x);
            throw new BaseException(x);
        }
    }

    public static boolean canAccessTable(Connection con, String tableName) {
        Statement st = null;
        try {
            st = con.createStatement();
            ResultSet rs = st.executeQuery("select 1 from " + tableName);
            rs.close();
            return true;
        }
        catch (SQLException x) {
            return false;
        }
        finally {
            DBUtils.close(st);
        }
    }

    public static synchronized SimpleSecurityService getInstance(String userInfoFile) throws BaseException {
        if (instance == null) {
            instance = new SimpleSecurityService(userInfoFile);
        }
        return instance;
    }

    public static synchronized SimpleSecurityService getInstance(InputStream is) throws BaseException {
        if (instance == null) {
            instance = new SimpleSecurityService(is);
        }
        return instance;
    }

    public static synchronized SimpleSecurityService getInstance(String userInfoFile, String xmlSchema) throws BaseException {
        if (instance == null) {
            instance = new SimpleSecurityService(userInfoFile, xmlSchema);
        }
        return instance;
    }

    public static synchronized SimpleSecurityService getInstance() throws BaseException {
        if (instance == null) {
            throw new BaseException("Service is not initialized!");
        }
        return instance;
    }

    public void prepareTableCache(String dbID) throws Exception {
        HashMap<String, String> dbMasterTableMap = new HashMap<String, String>(67);
        UserInfo ui = new UserInfo("admin", null, null);
        DBConfig adbc = this.dbConfigMap.get(dbID);
        Map<String, DBTableInfo> tableInfoMap = DBUtils.prepareTableInfoCache(ui, dbID, false, adbc.getDbType());
        for (DBTableInfo dbti : tableInfoMap.values()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("prepareTableCache: Adding " + dbti.getTableName()));
            }
            dbMasterTableMap.put(dbti.getTableName().toUpperCase(), dbti.getTableName());
        }
        this.masterTableMap.put(dbID, dbMasterTableMap);
    }

    public DBConfig getCurrentDBConfig() {
        return this.currentDBConfig;
    }

    public void extractData() throws Exception {
        Element root = this.doc.getRootElement();
        Element databasesElem = root.getChild("databases");
        List dbChildren = databasesElem.getChildren("database");
        boolean first = true;
        for (Element elem : dbChildren) {
            String siteId = null;
            String siteName = null;
            if (elem.getAttribute("siteName") != null) {
                siteName = elem.getAttributeValue("siteName");
            }
            if (elem.getAttribute("siteId") != null) {
                siteId = elem.getAttributeValue("siteId");
            }
            DBConfig dbConfig = new DBConfig(elem.getAttributeValue("id"), siteName, siteId);
            Element dbURLElem = elem.getChild("db-url");
            dbConfig.setDbURL(dbURLElem.getText().trim());
            this.dbConfigMap.put(dbConfig.getId(), dbConfig);
            Element dbTypeElem = elem.getChild("db-type");
            if (dbTypeElem != null) {
                dbConfig.setDbType(dbTypeElem.getText().trim());
            } else {
                dbConfig.setDbType("oracle");
            }
            if (first) {
                this.currentDBConfig = dbConfig;
                first = false;
            }
            if (elem.getAttribute("default") != null && elem.getAttributeValue("default").equalsIgnoreCase("true")) {
                this.currentDBConfig = dbConfig;
                dbConfig.setDefaultDB(true);
            }
            if (elem.getAttribute("force-schema-owner-check") == null || !elem.getAttributeValue("force-schema-owner-check").equalsIgnoreCase("true")) continue;
            dbConfig.setForceSchemaOwnerCheck(true);
        }
        this.currentDBConfig.setDefaultDB(true);
        Element dbUsersElem = root.getChild("dbusers");
        List children = dbUsersElem.getChildren("dbuser");
        for (Element elem : children) {
            String dbID = elem.getAttributeValue("dbid");
            DBConfig dbConfig = this.dbConfigMap.get(dbID);
            if (dbConfig == null) {
                throw new BaseException(String.valueOf(dbID) + " is not a valid database id!");
            }
            User dbUser = new User(elem.getAttributeValue("name"), elem.getAttributeValue("pwd"));
            dbConfig.addDbUser(dbUser);
        }
        Element privsElem = root.getChild("privileges");
        children = privsElem.getChildren("privilege");
        for (Element elem : children) {
            String name = elem.getAttributeValue("name");
            boolean projSpec = false;
            if (elem.getAttribute("project-specific") != null) {
                projSpec = elem.getAttributeValue("project-specific").equalsIgnoreCase("true");
            }
            Privilege privilege = new Privilege(name, projSpec);
            Element descElem = elem.getChild("description");
            if (descElem != null) {
                privilege.setDescription(descElem.getText());
            }
            this.privilegesMap.put(name, privilege);
        }
        Element usersElem = root.getChild("users");
        children = usersElem.getChildren("user");
        for (Element elem : children) {
            String dbUserName = elem.getAttributeValue("dbuser");
            String dbID = elem.getAttributeValue("dbid");
            DBConfig dbConfig = this.dbConfigMap.get(dbID);
            if (dbConfig == null) {
                throw new BaseException(String.valueOf(dbID) + " is not a valid database id!");
            }
            User user = new User(elem.getAttributeValue("name"), elem.getAttributeValue("pwd"));
            User dbUser = dbConfig.getDBUser(dbUserName);
            if (dbUser == null) {
                throw new BaseException("Database User <" + dbUserName + "> does not exists!");
            }
            user.setDbUser(dbUser);
            this.setUserPrivileges(elem, user);
            dbConfig.addUser(user);
        }
    }

    protected void setUserPrivileges(Element userElm, User user) {
        Element privsElem = userElm.getChild("privileges");
        if (privsElem == null) {
            return;
        }
        List children = privsElem.getChildren("privilege");
        for (Element privElem : children) {
            if (privElem.getAttributeValue("name").equals("all")) {
                Iterator<Privilege> it2 = this.privilegesMap.values().iterator();
                while (it2.hasNext()) {
                    user.addPrivilege(it2.next());
                }
                break;
            }
            Privilege priv = this.privilegesMap.get(privElem.getAttributeValue("name"));
            if (priv == null) continue;
            user.addPrivilege(priv);
        }
    }

    @Override
    public UserInfo getDefaultUser(String dbID, UserInfo ui) throws AuthenticationException {
        DBConfig dbConfig = this.dbConfigMap.get(dbID);
        this.log.info((Object)("dbID=" + dbID + " dbConfig=" + dbConfig));
        User u = dbConfig.getUser("admin");
        if (u.getAvailableTables() == null || u.getAvailableTables().isEmpty()) {
            this.prepareAvailableTables(u, dbID);
        }
        return new UserInfo("admin", null, u.getAvailableTables());
    }

    @Override
    public User getRestrictedUser(String dbID) {
        DBConfig dbConfig = this.dbConfigMap.get(dbID);
        this.log.info((Object)("dbID=" + dbID + " dbConfig=" + dbConfig));
        User guestUser = dbConfig.getUser("guest");
        if (guestUser == null) {
            guestUser = new User("guest", "");
            guestUser.setDbUser(this.getDefaultDBUser(dbConfig));
            dbConfig.addUser(guestUser);
            if (guestUser.getAvailableTables() == null || guestUser.getAvailableTables().isEmpty()) {
                this.prepareAvailableTables(guestUser, dbID);
            }
        }
        return guestUser;
    }

    private User getDefaultDBUser(DBConfig dbConfig) {
        Iterator<User> iterator = dbConfig.getDBUserMap().values().iterator();
        if (iterator.hasNext()) {
            User dbUser = iterator.next();
            return dbUser;
        }
        return null;
    }

    @Override
    public UserInfo authenticate(String user, String pwd, String dbID) throws AuthenticationException {
        DBConfig dbConfig = this.dbConfigMap.get(dbID);
        if (dbConfig == null) {
            throw new AuthenticationException("Unknown dbID:" + dbID);
        }
        User u = dbConfig.getUser(user);
        if (u == null) {
            throw new UnknownUserException("User '" + user + "' is not recognized!");
        }
        if (!u.getPwd().equals(pwd)) {
            throw new AuthenticationException();
        }
        this.prepareAvailableTables(u, dbID);
        return new UserInfo(user, null, u.getAvailableTables());
    }

    @Override
    public UserInfo authenticateAnonymous(String email, String dbID) throws AuthenticationException {
        String PUBLIC_USER = "public";
        DBConfig dbConfig = this.dbConfigMap.get(dbID);
        if (dbConfig == null) {
            throw new AuthenticationException("Unknown dbID:" + dbID);
        }
        if (email.indexOf("@") == -1) {
            throw new AuthenticationException("Not a valid email address");
        }
        User u = dbConfig.getUser("public");
        if (u == null) {
            throw new UnknownUserException("errors.notrecognized", "public");
        }
        this.prepareAvailableTables(u, dbID);
        return new UserInfo("public", email, null, u.getAvailableTables());
    }

    protected void prepareAvailableTables(User user, String dbID) {
        Connection con = null;
        IDBPoolService pool = null;
        if (!user.getAvailableTables().isEmpty()) {
            return;
        }
        try {
            try {
                pool = MinimalServiceFactory.getPoolService(dbID);
                con = pool.getConnection(user.getName());
                Map<String, String> dbMasterTableMap = this.masterTableMap.get(dbID);
                for (String tableName : dbMasterTableMap.keySet()) {
                    if (SimpleSecurityService.canAccessTable(con, tableName)) {
                        user.addAvailableTable(tableName);
                        continue;
                    }
                    this.log.error((Object)(String.valueOf(user.getName()) + " cannot access table: " + tableName));
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                this.log.error((Object)x, (Throwable)x);
                try {
                    this.log.info((Object)("****** Releasing connection " + user.getName() + " con=" + con + " dbID=" + dbID));
                    pool.releaseConnection(user.getName(), con);
                }
                catch (Exception ex) {
                    this.log.error((Object)ex, (Throwable)ex);
                }
            }
        }
        finally {
            try {
                this.log.info((Object)("****** Releasing connection " + user.getName() + " con=" + con + " dbID=" + dbID));
                pool.releaseConnection(user.getName(), con);
            }
            catch (Exception ex) {
                this.log.error((Object)ex, (Throwable)ex);
            }
        }
    }

    @Override
    public boolean isAuthorized(UserInfo userInfo, String dbID, Object action) {
        if (!this.getCurrentDBConfig().getId().equals(dbID)) {
            return false;
        }
        User u = this.getCurrentDBConfig().getUser(userInfo.getName());
        if (u == null) {
            return false;
        }
        String privName = (String)action;
        return u.hasPrivilege(privName);
    }

    @Override
    public Map<String, User> getAllUsers(String dbID) {
        return this.dbConfigMap.get(dbID).getUserMap();
    }

    @Override
    public Map<String, User> getAllNamedUsers(String dbID) {
        return this.dbConfigMap.get(dbID).getDBUserMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateUserPoolForDatabase(DBConfig dbConfig) throws SecurityException {
        DBConfig dbc = this.dbConfigMap.get(dbConfig.getId());
        if (dbc == null) {
            this.dbConfigMap.put(dbConfig.getId(), dbConfig);
        } else {
            Map<String, DBConfig> map = this.dbConfigMap;
            synchronized (map) {
                this.updateUsers(dbc, dbConfig);
            }
        }
    }

    private void updateUsers(DBConfig origDBConfig, DBConfig dbConfig) {
        for (User dbUser : dbConfig.getDBUserMap().values()) {
            User origDBUser = origDBConfig.getDBUser(dbUser.getName());
            if (origDBUser == null) {
                origDBConfig.addDbUser(dbUser);
                continue;
            }
            if (origDBUser.isSame(dbUser)) continue;
            origDBConfig.addDbUser(dbUser);
        }
    }

    @Override
    public Map<String, DBConfig> getDBConfigMap() {
        return this.dbConfigMap;
    }

    public static void main(String[] args) {
        SimpleSecurityService sss = null;
        try {
            sss = SimpleSecurityService.getInstance("/data1/opt/tomcat-4.1.24/webapps/clinical/WEB-INF/users.xml", "/home/bozyurt/dev/java/clinical/conf/users.xsd");
            Map<String, User> users = sss.getAllUsers("ucsd_mbirn");
            for (String userName : users.keySet()) {
                System.out.println(userName);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

